/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.core_av.usb_camera.capturer.video.provider;

import android.view.Surface;
import com.bandyer.core_av.capturer.video.CaptureFrameListener;
import com.bandyer.core_av.capturer.video.VideoFrame;
import com.bandyer.core_av.capturer.video.YuvFrame;
import com.bandyer.core_av.capturer.video.dispatcher.FrameDispatcher;
import com.bandyer.core_av.capturer.video.provider.FrameProvider;
import com.bandyer.core_av.capturer.video.provider.FrameProviderKt;
import com.bandyer.core_av.capturer.video.provider.FrameQuality;
import com.bandyer.core_av.usb_camera.UsbData;
import com.bandyer.core_av.usb_camera.capturer.video.provider.UsbFrameProvider;
import com.bandyer.core_av.usb_camera.internal.IFrameCallback;
import com.bandyer.core_av.usb_camera.internal.UVCCamera;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!H\u0016J\b\u0010$\u001a\u00020\u0014H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lcom/bandyer/core_av/usb_camera/capturer/video/provider/BaseUsbFrameProvider;", "Lcom/bandyer/core_av/usb_camera/capturer/video/provider/UsbFrameProvider;", "Lcom/bandyer/core_av/usb_camera/internal/IFrameCallback;", "usbData", "Lcom/bandyer/core_av/usb_camera/UsbData;", "(Lcom/bandyer/core_av/usb_camera/UsbData;)V", "camera", "Lcom/bandyer/core_av/usb_camera/internal/UVCCamera;", "frameDispatcher", "Lcom/bandyer/core_av/capturer/video/dispatcher/FrameDispatcher;", "value", "Lcom/bandyer/core_av/capturer/video/provider/FrameQuality;", "frameQuality", "getFrameQuality", "()Lcom/bandyer/core_av/capturer/video/provider/FrameQuality;", "setFrameQuality", "(Lcom/bandyer/core_av/capturer/video/provider/FrameQuality;)V", "getUsbData", "()Lcom/bandyer/core_av/usb_camera/UsbData;", "captureFrame", "", "onCaptureFrameListener", "Lcom/bandyer/core_av/capturer/video/CaptureFrameListener;", "onDispose", "onFailure", "exception", "Lcom/bandyer/core_av/capturer/video/provider/FrameProvider$Exception;", "onFrame", "buffer", "Ljava/nio/ByteBuffer;", "onInit", "onStart", "width", "", "height", "fps", "onStop", "extension_usb_camera_release"})
public final class BaseUsbFrameProvider
implements UsbFrameProvider,
IFrameCallback {
    @NotNull
    private FrameQuality frameQuality;
    private UVCCamera camera;
    private FrameDispatcher frameDispatcher;
    @NotNull
    private final UsbData usbData;

    @NotNull
    public FrameQuality getFrameQuality() {
        return this.frameQuality;
    }

    public void setFrameQuality(@NotNull FrameQuality value) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (Intrinsics.areEqual((Object)this.frameQuality, (Object)value)) {
                return;
            }
            this.frameQuality = value;
            UVCCamera uVCCamera = this.camera;
            if (uVCCamera == null) break block1;
            UVCCamera.setPreviewSize$default(uVCCamera, value.getWidth(), value.getHeight(), value.getFps(), 0, 0.0f, 24, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onInit(@NotNull FrameDispatcher frameDispatcher) {
        Intrinsics.checkNotNullParameter((Object)frameDispatcher, (String)"frameDispatcher");
        this.frameDispatcher = frameDispatcher;
        try {
            void $this$apply;
            UVCCamera uVCCamera = new UVCCamera();
            boolean bl = false;
            boolean bl2 = false;
            UVCCamera uVCCamera2 = uVCCamera;
            BaseUsbFrameProvider baseUsbFrameProvider = this;
            boolean bl3 = false;
            $this$apply.setPreviewDisplay(frameDispatcher.getSurfaceTexture());
            $this$apply.setFrameCallback(this);
            $this$apply.startPreview();
            Unit unit = Unit.INSTANCE;
            baseUsbFrameProvider.camera = uVCCamera;
            UVCCamera uVCCamera3 = this.camera;
            Intrinsics.checkNotNull((Object)uVCCamera3);
            uVCCamera3.connect(this.usbData);
        }
        catch (Exception e) {
            FrameProviderKt.fail((FrameProvider)this, (FrameProvider.Exception)new FrameProvider.Exception("Camera is already in use."));
            return;
        }
    }

    public void onStart(int width, int height, int fps) {
        block2: {
            if (this.frameDispatcher == null) {
                return;
            }
            UVCCamera uVCCamera = this.camera;
            if (uVCCamera != null) {
                FrameDispatcher frameDispatcher = this.frameDispatcher;
                Intrinsics.checkNotNull((Object)frameDispatcher);
                uVCCamera.initialize(new Surface(frameDispatcher.getSurfaceTexture()), this);
            }
            this.setFrameQuality(new FrameQuality(width, height, fps));
            UVCCamera uVCCamera2 = this.camera;
            if (uVCCamera2 == null) break block2;
            uVCCamera2.startPreview();
        }
    }

    public void onStop() throws InterruptedException {
        block0: {
            UVCCamera uVCCamera = this.camera;
            if (uVCCamera == null) break block0;
            uVCCamera.stopPreview();
        }
    }

    public void onDispose() {
        block0: {
            UVCCamera uVCCamera = this.camera;
            if (uVCCamera == null) break block0;
            uVCCamera.destroy();
        }
    }

    public void onFailure(@NotNull FrameProvider.Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.onDispose();
    }

    public void captureFrame(@NotNull CaptureFrameListener onCaptureFrameListener) {
        Intrinsics.checkNotNullParameter((Object)onCaptureFrameListener, (String)"onCaptureFrameListener");
    }

    @Override
    public void onFrame(@NotNull ByteBuffer buffer) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            YuvFrame yuvFrame = VideoFrame.Companion.create$default((VideoFrame.Companion)VideoFrame.Companion, (ByteBuffer)buffer, (int)this.getFrameQuality().getWidth(), (int)this.getFrameQuality().getHeight(), (int)0, (long)0L, (int)24, null);
            FrameDispatcher frameDispatcher = this.frameDispatcher;
            if (frameDispatcher == null) break block0;
            frameDispatcher.dispatch(yuvFrame);
        }
    }

    @NotNull
    public final UsbData getUsbData() {
        return this.usbData;
    }

    public BaseUsbFrameProvider(@NotNull UsbData usbData) {
        Intrinsics.checkNotNullParameter((Object)usbData, (String)"usbData");
        this.usbData = usbData;
        this.frameQuality = new FrameQuality(UVCCamera.Companion.getDEFAULT_PREVIEW_WIDTH(), UVCCamera.Companion.getDEFAULT_PREVIEW_HEIGHT(), UVCCamera.Companion.getDEFAULT_PREVIEW_MIN_FPS());
    }

    @NotNull
    public FrameProvider.State getState() {
        return UsbFrameProvider.DefaultImpls.getState(this);
    }
}

