/*
 * Copyright (C) 2020 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.core_av.usb_camera.capturer.video.provider

import androidx.appcompat.app.AppCompatActivity
import com.bandyer.core_av.capturer.video.provider.FrameProvider
import com.bandyer.core_av.usb_camera.UsbData

/**
 * Represents an usb frame provider
 */
interface UsbFrameProvider : FrameProvider {

    /**
     * @suppress
     */
    companion object {

        private var currentProvider: UsbFrameProvider? = null

        internal fun get(usbData: UsbData) = currentProvider?.takeIf { it.state == FrameProvider.State.STARTED }
                ?: BaseUsbFrameProvider(usbData).apply { currentProvider = this }
    }
}