/*
 * Copyright (C) 2020 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.core_av.usb_camera.capturer

import com.bandyer.core_av.capturer.Capturer
import com.bandyer.core_av.capturer.CapturerFactory
import com.bandyer.core_av.capturer.audio.AudioController
import com.bandyer.core_av.capturer.video.VideoController
import com.bandyer.core_av.capturer.video.dispatcher.FrameDispatcher
import com.bandyer.core_av.usb_camera.UsbData
import com.bandyer.core_av.usb_camera.capturer.video.provider.UsbFrameProvider

/**
 * Represents an UsbCapturer
 * @since v1.1.0
 */
interface UsbCapturer : Capturer<VideoController<UsbFrameProvider, FrameDispatcher>, AudioController>

/**
 * Creates an usb video controller
 * @param usbData the usb permissions data
 */
fun usbCamera(usbData: UsbData): CapturerFactory.Video.() -> Unit = { frameProvider = UsbFrameProvider.get(usbData) }

/**
 * Invokes block if the the capturer is of type usb
 * @param block invoked if the the capturer is of type usb
 * @return true if condition was verified, false otherwise
 * @since v1.1.0
 */
infix fun Capturer<*, *>?.isUsb(block: UsbCapturer.() -> Unit): Boolean {
    if (!isUsb) return false
    block.invoke(this as UsbCapturer)
    return true
}

/**
 * Returns true if the capturer is of type usb, false otherwise
 * @since v1.1.0
 */
val Capturer<*, *>?.isUsb
    get() = this?.video?.frameProvider is UsbFrameProvider