/*
 * Copyright (C) 2020 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.core_av.usb_camera

import android.content.Context
import android.hardware.usb.UsbDevice
import com.bandyer.core_av.usb_camera.internal.BaseUsbConnector

/**
 * Usb connector
 * Object to handle an usb device connection
 * @constructor Create empty Usb connector
 */
interface UsbConnector {

    /**
     * Factory
     */
    companion object Factory {
        /**
         * Create an UsbConnector
         *
         * @param context Context
         * @param listener listener for the device events
         * @return
         */
        fun create(context: Context, listener: OnDeviceConnectListener): UsbConnector = BaseUsbConnector(context, listener)
    }

    /**
     * Request permission to use an usb device
     *
     * @param device the device needing permissions
     * @return
     */
    fun requestPermission(device: UsbDevice): Boolean

    /**
     * Register the listener
     */
    fun register()

    /**
     * Unregister the listener
     */
    fun unregister()

    /**
     * Destroy the usb connector
     *
     */
    fun destroy()
}