/*
 * Copyright (C) 2020 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.core_av.usb_camera

import android.hardware.usb.UsbDevice

/**
 * Usb device connection listener
 */
interface OnDeviceConnectListener {

    /**
     * Called when device attached
     * @param device
     */
    fun onAttach(device: UsbDevice)

    /**
     * Called when device detach(after onDisconnect)
     *
     * @param device
     */
    fun onDetach(device: UsbDevice)

    /**
     * Called after device opened
     *
     * @param device the usb device whose permissions were granted
     * @param usbData the usb data to use to connect the device
     */
    fun onDeviceUsageGranted(device: UsbDevice, usbData: UsbData)

    /**
     * Called when USB device removed or its power off (this callback is called after device closing)
     *
     * @param device the usb device whose permissions were granted
     * @param usbData the usb data to used to connect the device
     */
    fun onDisconnect(device: UsbDevice, usbData: UsbData)

    /**
     * Called when canceled or could not get permission from user
     *
     * @param device the usb device whose permissions were granted
     */
    fun onDeviceUsageDenied(device: UsbDevice?)
}