/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.core_av.usb_camera.internal;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.RequiresApi;
import com.bandyer.core_av.usb_camera.OnDeviceConnectListener;
import com.bandyer.core_av.usb_camera.UsbData;
import com.bandyer.core_av.usb_camera.UsbDeviceInfo;
import com.bandyer.core_av.usb_camera.internal.BaseUsbConnector;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\b\b\u0000\u0018\u0000 Z2\u00020\u0001:\u0001ZB\u001f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0012\u0012\u0006\u0010\t\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\nJ\b\u0010I\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020J2\b\u0010L\u001a\u0004\u0018\u000100J\u0018\u0010K\u001a\u00020J2\b\u0010L\u001a\u0004\u0018\u0001002\u0006\u0010M\u001a\u00020NJ\b\u0010O\u001a\u00020\u0000H\u0016J\b\u0010P\u001a\u00020JH\u0016J\u0013\u0010Q\u001a\u00020N2\b\u0010R\u001a\u0004\u0018\u00010SH\u0096\u0002J\u000e\u0010\u001d\u001a\u00020\f2\u0006\u0010T\u001a\u00020NJ\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010T\u001a\u00020NJ\u0012\u0010U\u001a\u0004\u0018\u0001002\u0006\u0010V\u001a\u00020\fH\u0007J\u001a\u0010U\u001a\u0004\u0018\u0001002\u0006\u0010V\u001a\u00020\f2\u0006\u0010W\u001a\u00020\fH\u0007J\b\u0010X\u001a\u00020\fH\u0016J\u000e\u0010Y\u001a\u00020J2\u0006\u0010L\u001a\u000200R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR*\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u00108F@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000eR\u0011\u0010\u001c\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000eR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u0011\u0010$\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000eR\u0014\u0010&\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010!R\u0014\u0010(\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000eR\u0014\u0010*\u001a\u00020+X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002000/0/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u000702X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\u000502X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u00104\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010!R\u0014\u00106\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u000eR\u0013\u00108\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010!R\u0011\u0010:\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0013\u0010>\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010!R\u0016\u0010@\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u0013\u0010C\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010!R\u0014\u0010E\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u000eR\u0013\u0010G\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010!\u00a8\u0006["}, d2={"Lcom/bandyer/core_av/usb_camera/internal/BaseUsbData;", "Lcom/bandyer/core_av/usb_camera/UsbData;", "context", "Landroid/content/Context;", "monitor", "Lcom/bandyer/core_av/usb_camera/internal/BaseUsbConnector;", "device", "Landroid/hardware/usb/UsbDevice;", "(Landroid/content/Context;Lcom/bandyer/core_av/usb_camera/internal/BaseUsbConnector;Landroid/hardware/usb/UsbDevice;)V", "src", "(Lcom/bandyer/core_av/usb_camera/internal/BaseUsbData;)V", "busNum", "", "getBusNum", "()I", "<set-?>", "Landroid/hardware/usb/UsbDeviceConnection;", "connection", "getConnection", "()Landroid/hardware/usb/UsbDeviceConnection;", "setConnection", "(Landroid/hardware/usb/UsbDeviceConnection;)V", "devNum", "getDevNum", "getDevice", "()Landroid/hardware/usb/UsbDevice;", "deviceId", "getDeviceId", "deviceKey", "getDeviceKey", "deviceKeyName", "", "getDeviceKeyName", "()Ljava/lang/String;", "deviceKeyNameWithSerial", "getDeviceKeyNameWithSerial", "deviceKeyWithSerial", "getDeviceKeyWithSerial", "deviceName", "getDeviceName", "fileDescriptor", "getFileDescriptor", "mInfo", "Lcom/bandyer/core_av/usb_camera/UsbDeviceInfo;", "getMInfo", "()Lcom/bandyer/core_av/usb_camera/UsbDeviceInfo;", "mInterfaces", "Landroid/util/SparseArray;", "Landroid/hardware/usb/UsbInterface;", "mWeakDevice", "Ljava/lang/ref/WeakReference;", "mWeakMonitor", "manufacture", "getManufacture", "productId", "getProductId", "productName", "getProductName", "rawDescriptors", "", "getRawDescriptors", "()[B", "serial", "getSerial", "uSBMonitor", "getUSBMonitor", "()Lcom/bandyer/core_av/usb_camera/internal/BaseUsbConnector;", "usbVersion", "getUsbVersion", "venderId", "getVenderId", "version", "getVersion", "checkConnection", "", "claimInterface", "intf", "force", "", "clone", "close", "equals", "other", "", "useNewAPI", "getInterface", "interface_id", "altsetting", "hashCode", "releaseInterface", "Companion", "extension_usb_camera_release"})
public final class BaseUsbData
implements UsbData {
    private final WeakReference<BaseUsbConnector> mWeakMonitor;
    private final WeakReference<UsbDevice> mWeakDevice;
    @Nullable
    private UsbDeviceConnection connection;
    @NotNull
    private final UsbDeviceInfo mInfo;
    private final int busNum;
    private final int devNum;
    private final SparseArray<SparseArray<UsbInterface>> mInterfaces;
    @NotNull
    public static final String TAG = "UsbData";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final synchronized UsbDeviceConnection getConnection() {
        return this.connection;
    }

    protected final void setConnection(@Nullable UsbDeviceConnection usbDeviceConnection) {
        this.connection = usbDeviceConnection;
    }

    @NotNull
    protected final UsbDeviceInfo getMInfo() {
        return this.mInfo;
    }

    @Override
    public int getBusNum() {
        return this.busNum;
    }

    @Override
    public int getDevNum() {
        return this.devNum;
    }

    @Override
    @NotNull
    public BaseUsbData clone() throws CloneNotSupportedException {
        BaseUsbData usbData = null;
        try {
            usbData = new BaseUsbData(this);
        }
        catch (IllegalStateException e) {
            throw (Throwable)new CloneNotSupportedException(e.getMessage());
        }
        return usbData;
    }

    private final BaseUsbConnector getUSBMonitor() {
        return (BaseUsbConnector)this.mWeakMonitor.get();
    }

    @Nullable
    public final UsbDevice getDevice() {
        return (UsbDevice)this.mWeakDevice.get();
    }

    @Override
    @NotNull
    public String getDeviceName() {
        UsbDevice device = (UsbDevice)this.mWeakDevice.get();
        Object object = device;
        if (object == null || (object = object.getDeviceName()) == null) {
            object = "";
        }
        return object;
    }

    public final int getDeviceId() {
        UsbDevice device;
        UsbDevice usbDevice = device = (UsbDevice)this.mWeakDevice.get();
        return usbDevice != null ? usbDevice.getDeviceId() : 0;
    }

    @NotNull
    public final String getDeviceKeyName() {
        return BaseUsbConnector.Companion.getDeviceKeyName((UsbDevice)this.mWeakDevice.get());
    }

    @NotNull
    public final String getDeviceKeyName(boolean useNewAPI) throws IllegalStateException {
        if (useNewAPI) {
            this.checkConnection();
        }
        return BaseUsbConnector.Companion.getDeviceKeyName((UsbDevice)this.mWeakDevice.get(), this.mInfo.getSerial(), useNewAPI);
    }

    public final int getDeviceKey() throws IllegalStateException {
        this.checkConnection();
        return BaseUsbConnector.Companion.getDeviceKey((UsbDevice)this.mWeakDevice.get());
    }

    public final int getDeviceKey(boolean useNewAPI) throws IllegalStateException {
        if (useNewAPI) {
            this.checkConnection();
        }
        return BaseUsbConnector.Companion.getDeviceKey((UsbDevice)this.mWeakDevice.get(), this.mInfo.getSerial(), useNewAPI);
    }

    @NotNull
    public final String getDeviceKeyNameWithSerial() {
        return BaseUsbConnector.Companion.getDeviceKeyName((UsbDevice)this.mWeakDevice.get(), this.mInfo.getSerial(), false);
    }

    public final int getDeviceKeyWithSerial() {
        return this.getDeviceKeyNameWithSerial().hashCode();
    }

    @Override
    public synchronized int getFileDescriptor() throws IllegalStateException {
        this.checkConnection();
        UsbDeviceConnection usbDeviceConnection = this.connection;
        Intrinsics.checkNotNull((Object)usbDeviceConnection);
        return usbDeviceConnection.getFileDescriptor();
    }

    @NotNull
    public final synchronized byte[] getRawDescriptors() throws IllegalStateException {
        this.checkConnection();
        UsbDeviceConnection usbDeviceConnection = this.connection;
        Intrinsics.checkNotNull((Object)usbDeviceConnection);
        byte[] byArray = usbDeviceConnection.getRawDescriptors();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"connection!!.rawDescriptors");
        return byArray;
    }

    @Override
    public int getVenderId() {
        UsbDevice device;
        UsbDevice usbDevice = device = (UsbDevice)this.mWeakDevice.get();
        return usbDevice != null ? usbDevice.getVendorId() : 0;
    }

    @Override
    public int getProductId() {
        UsbDevice device;
        UsbDevice usbDevice = device = (UsbDevice)this.mWeakDevice.get();
        return usbDevice != null ? usbDevice.getProductId() : 0;
    }

    @Nullable
    public final String getUsbVersion() {
        return this.mInfo.getUsb_version();
    }

    @Nullable
    public final String getManufacture() {
        return this.mInfo.getManufacturer();
    }

    @Nullable
    public final String getProductName() {
        return this.mInfo.getProductName();
    }

    @Nullable
    public final String getVersion() {
        return this.mInfo.getVersion();
    }

    @Nullable
    public final String getSerial() {
        return this.mInfo.getSerial();
    }

    @RequiresApi(value=21)
    @Nullable
    public final synchronized UsbInterface getInterface(int interface_id) throws IllegalStateException {
        return this.getInterface(interface_id, 0);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=21)
    @Nullable
    public final synchronized UsbInterface getInterface(int interface_id, int altsetting) throws IllegalStateException {
        UsbInterface intf;
        this.checkConnection();
        SparseArray intfs = (SparseArray)this.mInterfaces.get(interface_id);
        if (intfs == null) {
            intfs = new SparseArray();
            this.mInterfaces.put(interface_id, (Object)intfs);
        }
        if ((intf = (UsbInterface)intfs.get(altsetting)) == null) {
            UsbDevice device;
            UsbDevice usbDevice = device = (UsbDevice)this.mWeakDevice.get();
            Intrinsics.checkNotNull((Object)usbDevice);
            int n = usbDevice.getInterfaceCount();
            int n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                UsbInterface temp;
                void i;
                Intrinsics.checkNotNullExpressionValue((Object)device.getInterface((int)i), (String)"device.getInterface(i)");
                if (temp.getId() == interface_id && temp.getAlternateSetting() == altsetting) {
                    intf = temp;
                    break;
                }
                ++i;
            }
            if (intf != null) {
                intfs.append(altsetting, (Object)intf);
            }
        }
        return intf;
    }

    public final synchronized void claimInterface(@Nullable UsbInterface intf) {
        this.claimInterface(intf, true);
    }

    public final synchronized void claimInterface(@Nullable UsbInterface intf, boolean force) {
        this.checkConnection();
        UsbDeviceConnection usbDeviceConnection = this.connection;
        Intrinsics.checkNotNull((Object)usbDeviceConnection);
        usbDeviceConnection.claimInterface(intf, force);
    }

    public final synchronized void releaseInterface(@NotNull UsbInterface intf) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)intf, (String)"intf");
        this.checkConnection();
        SparseArray intfs = (SparseArray)this.mInterfaces.get(intf.getId());
        if (intfs != null) {
            int index = intfs.indexOfValue((Object)intf);
            intfs.removeAt(index);
            if (intfs.size() == 0) {
                this.mInterfaces.remove(intf.getId());
            }
        }
        UsbDeviceConnection usbDeviceConnection = this.connection;
        Intrinsics.checkNotNull((Object)usbDeviceConnection);
        usbDeviceConnection.releaseInterface(intf);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void close() {
        block7: {
            if (this.connection == null) break block7;
            int n = this.mInterfaces.size();
            int n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                void i;
                SparseArray intfs = (SparseArray)this.mInterfaces.valueAt((int)i);
                if (intfs != null) {
                    int m = intfs.size();
                    int n4 = 0;
                    int n5 = m;
                    while (n4 < n5) {
                        void j;
                        UsbInterface intf = (UsbInterface)intfs.valueAt((int)j);
                        UsbDeviceConnection usbDeviceConnection = this.connection;
                        Intrinsics.checkNotNull((Object)usbDeviceConnection);
                        usbDeviceConnection.releaseInterface(intf);
                        ++j;
                    }
                    intfs.clear();
                }
                ++i;
            }
            this.mInterfaces.clear();
            UsbDeviceConnection usbDeviceConnection = this.connection;
            Intrinsics.checkNotNull((Object)usbDeviceConnection);
            usbDeviceConnection.close();
            this.connection = null;
            BaseUsbConnector baseUsbConnector = (BaseUsbConnector)this.mWeakMonitor.get();
            if (baseUsbConnector == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)baseUsbConnector, (String)"mWeakMonitor.get() ?: return");
            BaseUsbConnector monitor = baseUsbConnector;
            if (this.getDevice() == null) {
                return;
            }
            if (monitor.getMusbDatas().isEmpty()) {
                return;
            }
            ConcurrentHashMap<UsbDevice, BaseUsbData> concurrentHashMap = monitor.getMusbDatas();
            UsbDevice usbDevice = this.getDevice();
            Intrinsics.checkNotNull((Object)usbDevice);
            concurrentHashMap.remove(usbDevice);
            OnDeviceConnectListener onDeviceConnectListener = monitor.getMOnDeviceConnectListener();
            if (onDeviceConnectListener != null) {
                UsbDevice usbDevice2 = this.getDevice();
                Intrinsics.checkNotNull((Object)usbDevice2);
                onDeviceConnectListener.onDisconnect(usbDevice2, this);
            }
        }
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof BaseUsbData) {
            UsbDevice device = ((BaseUsbData)other).getDevice();
            return device == null ? this.mWeakDevice.get() == null : Intrinsics.areEqual((Object)device, (Object)((UsbDevice)this.mWeakDevice.get()));
        }
        if (other instanceof UsbDevice) {
            return Intrinsics.areEqual((Object)other, (Object)((UsbDevice)this.mWeakDevice.get()));
        }
        return super.equals(other);
    }

    private final synchronized void checkConnection() throws IllegalStateException {
        if (this.connection == null) {
            throw (Throwable)new IllegalStateException("already closed");
        }
    }

    public int hashCode() {
        return this.mWeakDevice.hashCode();
    }

    public BaseUsbData(@NotNull Context context, @NotNull BaseUsbConnector monitor, @NotNull UsbDevice device) {
        String[] stringArray;
        Collection thisCollection$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        this.mInterfaces = new SparseArray();
        this.mWeakMonitor = new WeakReference<BaseUsbConnector>(monitor);
        this.mWeakDevice = new WeakReference<UsbDevice>(device);
        Object object = context.getSystemService("usb");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.hardware.usb.UsbManager");
        }
        UsbManager mUsbManager = (UsbManager)object;
        this.connection = mUsbManager.openDevice(device);
        this.mInfo = monitor.getDeviceInfo(device);
        String string = device.getDeviceName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.deviceName");
        String name = string;
        if (!TextUtils.isEmpty((CharSequence)name)) {
            CharSequence charSequence = name;
            String string2 = "/";
            int n = 0;
            string2 = new Regex(string2);
            n = 0;
            bl = false;
            Collection $this$toTypedArray$iv = string2.split(charSequence, n);
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            stringArray = stringArray2;
        } else {
            stringArray = null;
        }
        String[] v = stringArray;
        int busnum = 0;
        int devnum = 0;
        if (v != null) {
            thisCollection$iv = v[v.length - 2];
            bl = false;
            busnum = Integer.parseInt((String)((Object)thisCollection$iv));
            thisCollection$iv = v[v.length - 1];
            bl = false;
            devnum = Integer.parseInt((String)((Object)thisCollection$iv));
        }
        this.busNum = busnum;
        this.devNum = devnum;
        if (this.connection != null) {
            UsbDeviceConnection usbDeviceConnection = this.connection;
            Intrinsics.checkNotNull((Object)usbDeviceConnection);
            int desc = usbDeviceConnection.getFileDescriptor();
            UsbDeviceConnection usbDeviceConnection2 = this.connection;
            Intrinsics.checkNotNull((Object)usbDeviceConnection2);
            byte[] rawDesc = usbDeviceConnection2.getRawDescriptors();
            StringBuilder stringBuilder = new StringBuilder();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            String string3 = "name=%s,desc=%d,busnum=%d,devnum=%d,rawDesc=";
            Object[] objectArray = new Object[]{name, desc, busnum, devnum};
            boolean bl2 = false;
            String string4 = String.format(locale, string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(locale, format, *args)");
            Log.i((String)TAG, (String)stringBuilder.append(string4).append(rawDesc).toString());
        } else {
            Log.e((String)TAG, (String)("could not connect to device " + name));
        }
    }

    private BaseUsbData(BaseUsbData src) {
        this.mInterfaces = new SparseArray();
        BaseUsbConnector monitor = src.getUSBMonitor();
        UsbDevice usbDevice = src.getDevice();
        if (usbDevice == null) {
            throw (Throwable)new IllegalStateException("device may already be removed");
        }
        UsbDevice device = usbDevice;
        BaseUsbConnector baseUsbConnector = monitor;
        Intrinsics.checkNotNull((Object)baseUsbConnector);
        this.connection = baseUsbConnector.getMUsbManager().openDevice(device);
        if (this.connection == null) {
            throw (Throwable)new IllegalStateException("device may already be removed or have no permission");
        }
        this.mInfo = monitor.getDeviceInfo(device);
        this.mWeakMonitor = new WeakReference<BaseUsbConnector>(monitor);
        this.mWeakDevice = new WeakReference<UsbDevice>(device);
        this.busNum = src.getBusNum();
        this.devNum = src.getDevNum();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/bandyer/core_av/usb_camera/internal/BaseUsbData$Companion;", "", "()V", "TAG", "", "extension_usb_camera_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

