/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.core_av.usb_camera;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import android.os.Build;
import com.bandyer.core_av.usb_camera.UsbDeviceInfo;
import com.bandyer.core_av.usb_camera.internal.USBVendorId;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a8\u0006\u0010"}, d2={"getString", "", "connection", "Landroid/hardware/usb/UsbDeviceConnection;", "id", "", "languageCount", "languages", "", "info", "Lcom/bandyer/core_av/usb_camera/UsbDeviceInfo;", "Landroid/hardware/usb/UsbDevice;", "context", "Landroid/content/Context;", "manager", "Landroid/hardware/usb/UsbManager;", "extension_usb_camera_release"})
public final class UsbDeviceExtensionsKt {
    @NotNull
    public static final UsbDeviceInfo info(@NotNull UsbDevice $this$info, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$info, (String)"$this$info");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getApplicationContext().getSystemService("usb");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.hardware.usb.UsbManager");
        }
        UsbManager manager = (UsbManager)object;
        return UsbDeviceExtensionsKt.info($this$info, manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final UsbDeviceInfo info(@NotNull UsbDevice $this$info, @NotNull UsbManager manager) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$info, (String)"$this$info");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        UsbDeviceInfo usbDeviceInfo = new UsbDeviceInfo(null, null, null, null, null, 31, null);
        boolean bl2 = false;
        boolean bl3 = false;
        UsbDeviceInfo $this$apply = usbDeviceInfo;
        boolean bl4 = false;
        if (Build.VERSION.SDK_INT >= 21) {
            $this$apply.setManufacturer($this$info.getManufacturerName());
            $this$apply.setProductName($this$info.getProductName());
        }
        if (Build.VERSION.SDK_INT >= 23) {
            $this$apply.setUsb_version($this$info.getVersion());
        }
        if (manager.hasPermission($this$info)) {
            UsbDeviceConnection connection;
            block16: {
                if (Build.VERSION.SDK_INT >= 29) {
                    $this$apply.setSerial($this$info.getSerialNumber());
                }
                connection = manager.openDevice($this$info);
                try {
                    boolean bl5;
                    UsbDeviceConnection usbDeviceConnection = connection;
                    Intrinsics.checkNotNullExpressionValue((Object)usbDeviceConnection, (String)"connection");
                    byte[] desc = usbDeviceConnection.getRawDescriptors();
                    CharSequence charSequence = $this$apply.getUsb_version();
                    boolean bl6 = false;
                    boolean bl7 = false;
                    if (charSequence == null || charSequence.length() == 0) {
                        charSequence = StringCompanionObject.INSTANCE;
                        String string = "%x.%02x";
                        Object[] objectArray = new Object[]{desc[3] & 0xFF, desc[2] & 0xFF};
                        bl5 = false;
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                        $this$apply.setUsb_version(string2);
                    }
                    charSequence = $this$apply.getVersion();
                    bl6 = false;
                    bl7 = false;
                    if (charSequence == null || charSequence.length() == 0) {
                        charSequence = StringCompanionObject.INSTANCE;
                        String string = "%x.%02x";
                        Object[] objectArray = new Object[]{desc[13] & 0xFF, desc[12] & 0xFF};
                        bl5 = false;
                        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                        $this$apply.setVersion(string3);
                    }
                    charSequence = $this$apply.getSerial();
                    bl = false;
                    boolean bl8 = false;
                    if (charSequence == null || charSequence.length() == 0) {
                        $this$apply.setSerial(connection.getSerial());
                    }
                    byte[] languages = new byte[256];
                    int languageCount = 0;
                    int result = connection.controlTransfer(128, 6, 768, 0, languages, 256, 0);
                    if (result > 0) {
                        languageCount = (result - 2) / 2;
                    }
                    if (languageCount <= 0) break block16;
                    CharSequence charSequence2 = $this$apply.getManufacturer();
                    boolean bl9 = false;
                    boolean bl10 = false;
                    if (charSequence2 == null || charSequence2.length() == 0) {
                        $this$apply.setManufacturer(UsbDeviceExtensionsKt.getString(connection, desc[14], languageCount, languages));
                    }
                    charSequence2 = $this$apply.getProductName();
                    bl9 = false;
                    bl10 = false;
                    if (charSequence2 == null || charSequence2.length() == 0) {
                        $this$apply.setProductName(UsbDeviceExtensionsKt.getString(connection, desc[15], languageCount, languages));
                    }
                    charSequence2 = $this$apply.getSerial();
                    bl9 = false;
                    bl10 = false;
                    if (!(charSequence2 == null || charSequence2.length() == 0)) break block16;
                    $this$apply.setSerial(UsbDeviceExtensionsKt.getString(connection, desc[16], languageCount, languages));
                }
                catch (Throwable throwable) {
                    UsbDeviceConnection usbDeviceConnection = connection;
                    if (usbDeviceConnection != null) {
                        usbDeviceConnection.close();
                    }
                    throw throwable;
                }
            }
            connection.close();
        }
        CharSequence charSequence = $this$apply.getManufacturer();
        boolean bl11 = false;
        boolean bl12 = false;
        if (charSequence == null || charSequence.length() == 0) {
            $this$apply.setManufacturer(USBVendorId.vendorName($this$info.getVendorId()));
        }
        charSequence = $this$apply.getManufacturer();
        bl11 = false;
        bl12 = false;
        if (charSequence == null || charSequence.length() == 0) {
            charSequence = StringCompanionObject.INSTANCE;
            String string = "%04x";
            Object[] objectArray = new Object[]{$this$info.getVendorId()};
            bl = false;
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
            $this$apply.setManufacturer(string4);
        }
        charSequence = $this$apply.getProductName();
        boolean bl13 = false;
        boolean bl14 = false;
        if (charSequence == null || charSequence.length() == 0) {
            charSequence = StringCompanionObject.INSTANCE;
            String string = "%04x";
            Object[] objectArray = new Object[]{$this$info.getProductId()};
            bl = false;
            String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
            $this$apply.setProductName(string5);
        }
        return usbDeviceInfo;
    }

    /*
     * WARNING - void declaration
     */
    private static final String getString(UsbDeviceConnection connection, int id, int languageCount, byte[] languages) {
        byte[] work = new byte[256];
        String result = null;
        int n = 1;
        int n2 = languageCount;
        if (n <= n2) {
            while (true) {
                void i;
                int ret;
                if ((ret = connection.controlTransfer(128, 6, 0x300 | id, (int)languages[i], work, 256, 0)) > 2 && work[0] == ret && work[1] == 3) {
                    try {
                        Charset charset;
                        int n3 = 2;
                        int n4 = ret - 2;
                        Intrinsics.checkNotNullExpressionValue((Object)Charset.forName("UTF-16LE"), (String)"Charset.forName(\"UTF-16LE\")");
                        boolean bl = false;
                        result = new String(work, n3, n4, charset);
                        if (Intrinsics.areEqual((Object)"\u0409", (Object)result) ^ true) break;
                        result = null;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
        return result;
    }
}

