/*
 * Copyright (C) 2020 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.core_av.usb_camera.capturer

import com.bandyer.core_av.capturer.CapturerFactory
import com.bandyer.core_av.usb_camera.UsbData
import com.bandyer.core_av.usb_camera.capturer.video.provider.UsbFrameProvider

/**
 * Creates an usb video controller
 */
fun usbCamera(usbData: UsbData): CapturerFactory.Video.() -> Unit = { frameProvider = UsbFrameProvider.get(usbData) }