/*
 * Copyright (C) 2020 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.core_av.usb_camera

/**
 * Usb device info
 *
 * @property usb_version the Usb version
 * @property manufacturer the manufacturer of the device
 * @property productName product name of the device
 * @property version version of device
 * @property serial serial of the device
 * @constructor Create empty Usb device info
 */
data class UsbDeviceInfo(var usb_version: String? = null,
                         var manufacturer: String? = null,
                         var productName: String? = null,
                         var version: String? = null,
                         var serial: String? = null)