/*
 * Copyright (C) 2020 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.core_av.usb_camera

/**
 * Permissions data needed to connect a device
 */
interface UsbData : Cloneable {

    /**
     * Device name
     */
    val deviceName: String

    /**
     * Vendor id
     */
    val venderId: Int

    /**
     * Product id
     */
    val productId: Int

    /**
     * File descriptor to access USB device
     */
    val fileDescriptor: Int

    /**
     * Close device
     */
    fun close()

    /**
     * @suppress
     */
    val busNum: Int

    /**
     * @suppress
     */
    val devNum: Int

    /**
     * @suppress
     */
    public override fun clone(): UsbData
}