package com.bandyer.communication_center.live_pointer.utils

import com.bandyer.communication_center.call.Call
import com.bandyer.communication_center.call.CustomEvent
import com.bandyer.communication_center.call.OnCustomEventObserver
import com.bandyer.communication_center.live_pointer.model.PointerEvent
import com.bandyer.communication_center.live_pointer.model.toPointerEvent
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.SupervisorJob
import kotlinx.coroutines.launch


internal abstract class PointerObserver(var call: Call) : OnCustomEventObserver {

    companion object {
        const val communicationCenterLivePointerEventName = "stream:cursor:move"
    }

    private val ioScope by lazy { CoroutineScope(SupervisorJob() + Dispatchers.IO) }

    override val eventNames = listOf(communicationCenterLivePointerEventName)

    override fun onEventReceived(event: CustomEvent) {
        ioScope.launch { onEvent(event.toPointerEvent(call)) }
    }

    abstract fun onEvent(event: PointerEvent)

    fun dispose() {
        call.removeCustomEventObserver(this)
    }

    init {
        call.addCustomEventObserver(this)
    }
}