package com.bandyer.communication_center.live_pointer.utils

import kotlinx.coroutines.FlowPreview
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.flow.*

@FlowPreview
internal suspend fun <T> Flow<T>.sampleWithTimeout(onSample: (T) -> Unit, onIdle: (T) -> Unit, sampleTimeout: Long?, idleTimeout: Long?) = flow {
    this@sampleWithTimeout.sample(sampleTimeout?.takeIf { it > 0 }
            ?: 1).collect { onSample(it); emit(it) }
}.debounce(idleTimeout?.takeIf { it > 0 } ?: 1).collect { onIdle.invoke(it) }


internal suspend fun <T> Channel<T>.sampleWithTimeout(onSample: (T) -> Unit, onIdle: (T) -> Unit, sampleTimeout: Long?, idleTimeout: Long?) = receiveAsFlow().sampleWithTimeout(onSample, onIdle, sampleTimeout, idleTimeout)