package com.bandyer.communication_center.live_pointer.model

import com.bandyer.communication_center.call.Call
import com.bandyer.communication_center.call.participant.CallParticipant

/**
 * PointerEvent model
 * @property call the call that has generated the live pointer event.
 * @property requester the CallParticipant that requested the live pointer upon the provided streamId
 * @property streamId the stream's identifier for the live pointer event
 * @property pointerPosition the representation of the pointer location.
 * @constructor
 */
data class PointerEvent(val call: Call, val requester: CallParticipant, val streamId: String, val pointerPosition: PointerPosition)