package com.bandyer.communication_center.live_pointer.model

import com.bandyer.communication_center.call.Call
import com.bandyer.communication_center.call.CustomEvent
import com.bandyer.communication_center.live_pointer.LivePointer
import com.google.gson.annotations.SerializedName

internal data class CommunicationCenterPointerEvent(
        @SerializedName("relativeX")
        val relativeX: Float,
        @SerializedName("relativeY")
        val relativeY: Float,
        @SerializedName("videoWidth")
        val videoWidth: Float,
        @SerializedName("videoHeight")
        val videoHeight: Float,
        @SerializedName("streamId")
        val streamId: String,
        @SerializedName("userAlias")
        val userAlias: String)

internal fun CustomEvent.toPointerEvent(call: Call) = LivePointer.gson.fromJson((data as Array<Object>)[0].toString(), CommunicationCenterPointerEvent::class.java).let {
    PointerEvent(
            call,
            call.participants.getParticipant(it.userAlias)!!,
            it.streamId,
            PointerPosition(
                    (it.relativeX * 100f / it.videoWidth).coerceIn(0f, 100f),
                    (it.relativeY * 100f / it.videoHeight).coerceIn(0f, 100f)))
}