/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.communication_center.call_client;

import com.bandyer.communication_center.CommunicationCenter;
import com.bandyer.communication_center.EnvironmentImpl;
import com.bandyer.communication_center.call.BaseCall;
import com.bandyer.communication_center.call.Call;
import com.bandyer.communication_center.call.CallOptions;
import com.bandyer.communication_center.call.IncomingCall;
import com.bandyer.communication_center.call.OnCallCreationObserver;
import com.bandyer.communication_center.call.OnCallEventObserver;
import com.bandyer.communication_center.call.participant.BaseCallParticipant;
import com.bandyer.communication_center.call.participant.BaseCallParticipants;
import com.bandyer.communication_center.call.participant.CallParticipantStatus;
import com.bandyer.communication_center.call_client.CallClient;
import com.bandyer.communication_center.call_client.CallClientInstance;
import com.bandyer.communication_center.call_client.CallClientStatus;
import com.bandyer.communication_center.call_client.CallClientUser;
import com.bandyer.communication_center.call_client.CallException;
import com.bandyer.communication_center.call_client.OnCallClientObservable;
import com.bandyer.communication_center.call_client.OnCallClientObserver;
import com.bandyer.communication_center.call_client.OnIncomingCallObservable;
import com.bandyer.communication_center.call_client.OnIncomingCallObserver;
import com.bandyer.communication_center.call_client.OnNotificationObserver;
import com.bandyer.communication_center.call_client.User;
import com.bandyer.communication_center.networking.b.b;
import com.bandyer.communication_center.networking.b.c;
import com.bandyer.communication_center.networking.b.e;
import com.bandyer.communication_center.networking.b.f;
import com.bandyer.communication_center.networking.g;
import com.bandyer.communication_center.networking.i;
import com.bandyer.communication_center.networking.models.CallOptionResponse;
import com.bandyer.communication_center.networking.models.DialCallResponse;
import com.bandyer.communication_center.networking.models.DialingHost;
import com.bandyer.communication_center.networking.models.Response;
import com.bandyer.communication_center.networking.models.ResponseError;
import com.bandyer.core_av.room.RoomToken;
import com.bandyer.core_av.utils.logging.PriorityLogger;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 {2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001{B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010H\u001a\u00020\u00002\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\u00012\u0006\u0010I\u001a\u00020LH\u0016J(\u0010M\u001a\u00020N2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020Q0P2\b\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010T\u001a\u00020\u0002H\u0016J(\u0010U\u001a\u00020N2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020Q0P2\b\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010T\u001a\u00020\u0002H\u0002J\b\u0010V\u001a\u00020NH\u0016J\u0018\u0010W\u001a\u00020N2\u0006\u0010X\u001a\u00020Q2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020N2\u0006\u0010\\\u001a\u00020QH\u0016J\u0018\u0010]\u001a\u00020N2\u0006\u0010^\u001a\u00020Q2\u0006\u0010T\u001a\u00020\u0002H\u0016J1\u0010_\u001a\u00020N2\u0006\u0010`\u001a\u00020Q2\u0006\u0010a\u001a\u00020\u00062\u0012\u0010b\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020N0cH\u0000\u00a2\u0006\u0002\bdJ\u0010\u0010e\u001a\u00020N2\u0006\u0010f\u001a\u00020gH\u0016J\u0010\u0010h\u001a\u00020N2\u0006\u0010M\u001a\u000201H\u0016J\u0018\u0010i\u001a\u00020N2\u0006\u0010M\u001a\u0002012\u0006\u0010j\u001a\u00020kH\u0016J\u0018\u0010l\u001a\u00020N2\u0006\u0010M\u001a\u0002012\u0006\u0010f\u001a\u00020gH\u0016J\u0018\u0010m\u001a\u00020N2\u0006\u0010M\u001a\u0002012\u0006\u0010n\u001a\u00020oH\u0016J\u0018\u0010p\u001a\u00020N2\u0006\u0010M\u001a\u0002012\u0006\u0010<\u001a\u00020qH\u0016J8\u0010r\u001a\u00020N2\u0006\u0010s\u001a\u00020Q2\u0012\u0010t\u001a\u000e\u0012\u0004\u0012\u00020u\u0012\u0004\u0012\u00020N0c2\u0012\u0010v\u001a\u000e\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020N0cH\u0002J\u0010\u0010w\u001a\u00020\u00002\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010x\u001a\u00020\u00012\u0006\u0010I\u001a\u00020LH\u0016J\b\u0010y\u001a\u00020NH\u0016J\b\u0010z\u001a\u00020NH\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001e\u00100\u001a\u0004\u0018\u0001018VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001c\u00106\u001a\u0004\u0018\u000107X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u001a\u0010<\u001a\u00020=X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u001a\u0010B\u001a\u00020CX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010G\u00a8\u0006|"}, d2={"Lcom/bandyer/communication_center/call_client/CallClient;", "Lcom/bandyer/communication_center/call_client/CallClientInstance;", "Lcom/bandyer/communication_center/call/OnCallCreationObserver;", "Lcom/bandyer/communication_center/call/OnCallEventObserver;", "()V", "baseCall", "Lcom/bandyer/communication_center/call/BaseCall;", "getBaseCall$communication_center_release", "()Lcom/bandyer/communication_center/call/BaseCall;", "setBaseCall$communication_center_release", "(Lcom/bandyer/communication_center/call/BaseCall;)V", "busy", "", "getBusy", "()Z", "setBusy", "(Z)V", "dialingChannel", "Lcom/bandyer/communication_center/networking/DialingChannel;", "getDialingChannel$communication_center_release", "()Lcom/bandyer/communication_center/networking/DialingChannel;", "setDialingChannel$communication_center_release", "(Lcom/bandyer/communication_center/networking/DialingChannel;)V", "incomingCallObserver", "Lcom/bandyer/communication_center/networking/dial_channel/DialChannelIncomingCallObserver;", "getIncomingCallObserver$communication_center_release", "()Lcom/bandyer/communication_center/networking/dial_channel/DialChannelIncomingCallObserver;", "setIncomingCallObserver$communication_center_release", "(Lcom/bandyer/communication_center/networking/dial_channel/DialChannelIncomingCallObserver;)V", "incomingCallObservers", "Lcom/bandyer/communication_center/call_client/OnIncomingCallObservable;", "getIncomingCallObservers$communication_center_release", "()Lcom/bandyer/communication_center/call_client/OnIncomingCallObservable;", "setIncomingCallObservers$communication_center_release", "(Lcom/bandyer/communication_center/call_client/OnIncomingCallObservable;)V", "incomingCalls", "", "Lcom/bandyer/communication_center/call/IncomingCall;", "getIncomingCalls$communication_center_release", "()Ljava/util/List;", "setIncomingCalls$communication_center_release", "(Ljava/util/List;)V", "onDialingChannelObserver", "Lcom/bandyer/communication_center/networking/dial_channel/DialingChannelObserver;", "getOnDialingChannelObserver$communication_center_release", "()Lcom/bandyer/communication_center/networking/dial_channel/DialingChannelObserver;", "setOnDialingChannelObserver$communication_center_release", "(Lcom/bandyer/communication_center/networking/dial_channel/DialingChannelObserver;)V", "ongoingCall", "Lcom/bandyer/communication_center/call/Call;", "getOngoingCall", "()Lcom/bandyer/communication_center/call/Call;", "setOngoingCall", "(Lcom/bandyer/communication_center/call/Call;)V", "sessionUser", "Lcom/bandyer/communication_center/call_client/User;", "getSessionUser", "()Lcom/bandyer/communication_center/call_client/User;", "setSessionUser", "(Lcom/bandyer/communication_center/call_client/User;)V", "status", "Lcom/bandyer/communication_center/call_client/CallClientStatus;", "getStatus", "()Lcom/bandyer/communication_center/call_client/CallClientStatus;", "setStatus", "(Lcom/bandyer/communication_center/call_client/CallClientStatus;)V", "statusCallObservers", "Lcom/bandyer/communication_center/call_client/OnCallClientObservable;", "getStatusCallObservers$communication_center_release", "()Lcom/bandyer/communication_center/call_client/OnCallClientObservable;", "setStatusCallObservers$communication_center_release", "(Lcom/bandyer/communication_center/call_client/OnCallClientObservable;)V", "addIncomingCallObserver", "observer", "Lcom/bandyer/communication_center/call_client/OnIncomingCallObserver;", "addStatusObserver", "Lcom/bandyer/communication_center/call_client/OnCallClientObserver;", "call", "", "users", "", "", "callOptions", "Lcom/bandyer/communication_center/call/CallOptions;", "onCallCreationObserver", "createCall", "destroy", "handleNotification", "data", "onNotificationObserver", "Lcom/bandyer/communication_center/call_client/OnNotificationObserver;", "init", "userAlias", "join", "url", "notifyIncomingCall", "callId", "incomingCall", "callback", "Lkotlin/Function1;", "notifyIncomingCall$communication_center_release", "onCallCreationError", "reason", "Lcom/bandyer/communication_center/call_client/CallException;", "onCallCreationSuccess", "onCallEnded", "callEndReason", "Lcom/bandyer/communication_center/call/Call$EndReason;", "onCallError", "onCallStarted", "roomToken", "Lcom/bandyer/core_av/room/RoomToken;", "onCallStatusChanged", "Lcom/bandyer/communication_center/call/Call$Status;", "parseNotification", "payload", "success", "Lcom/bandyer/communication_center/networking/models/DialCallResponse;", "error", "removeIncomingCallObserver", "removeStatusObserver", "resume", "stop", "_", "communication_center_release"})
public final class CallClient
implements OnCallCreationObserver,
OnCallEventObserver,
CallClientInstance {
    @NotNull
    private CallClientStatus status = CallClientStatus.DESTROYED;
    @Nullable
    private List<IncomingCall> incomingCalls;
    @Nullable
    private Call ongoingCall;
    @Nullable
    private BaseCall baseCall;
    private boolean busy;
    @Nullable
    private i dialingChannel;
    @NotNull
    private OnIncomingCallObservable incomingCallObservers;
    @NotNull
    private OnCallClientObservable statusCallObservers;
    @Nullable
    private User sessionUser;
    @NotNull
    private e onDialingChannelObserver;
    @NotNull
    private b incomingCallObserver;
    private static volatile CallClientInstance mInstance;
    public static final _ _;

    @Override
    @NotNull
    public CallClientStatus getStatus() {
        return this.status;
    }

    public void setStatus(@NotNull CallClientStatus callClientStatus) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)callClientStatus), (String)"<set-?>");
        this.status = callClientStatus;
    }

    @Nullable
    public final List<IncomingCall> getIncomingCalls$communication_center_release() {
        return this.incomingCalls;
    }

    public final void setIncomingCalls$communication_center_release(@Nullable List<IncomingCall> list) {
        this.incomingCalls = list;
    }

    @Override
    @Nullable
    public Call getOngoingCall() {
        return this.baseCall;
    }

    public void setOngoingCall(@Nullable Call call) {
        this.ongoingCall = call;
    }

    @Nullable
    public final BaseCall getBaseCall$communication_center_release() {
        return this.baseCall;
    }

    public final void setBaseCall$communication_center_release(@Nullable BaseCall baseCall) {
        this.baseCall = baseCall;
    }

    @Override
    public boolean getBusy() {
        return this.busy;
    }

    public void setBusy(boolean bl) {
        this.busy = bl;
    }

    @Nullable
    public final i getDialingChannel$communication_center_release() {
        return this.dialingChannel;
    }

    public final void setDialingChannel$communication_center_release(@Nullable i i2) {
        this.dialingChannel = i2;
    }

    @NotNull
    public final OnIncomingCallObservable getIncomingCallObservers$communication_center_release() {
        return this.incomingCallObservers;
    }

    public final void setIncomingCallObservers$communication_center_release(@NotNull OnIncomingCallObservable onIncomingCallObservable) {
        Intrinsics.checkParameterIsNotNull((Object)onIncomingCallObservable, (String)"<set-?>");
        this.incomingCallObservers = onIncomingCallObservable;
    }

    @NotNull
    public final OnCallClientObservable getStatusCallObservers$communication_center_release() {
        return this.statusCallObservers;
    }

    public final void setStatusCallObservers$communication_center_release(@NotNull OnCallClientObservable onCallClientObservable) {
        Intrinsics.checkParameterIsNotNull((Object)onCallClientObservable, (String)"<set-?>");
        this.statusCallObservers = onCallClientObservable;
    }

    @Override
    @Nullable
    public User getSessionUser() {
        return this.sessionUser;
    }

    public void setSessionUser(@Nullable User user) {
        this.sessionUser = user;
    }

    @Override
    public void init(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"userAlias");
        CommunicationCenter communicationCenter = CommunicationCenter.Companion.getInstance();
        if (communicationCenter == null) {
            Intrinsics.throwNpe();
        }
        PriorityLogger priorityLogger = communicationCenter.getLogger$communication_center_release();
        if (priorityLogger != null) {
            PriorityLogger.info$default((PriorityLogger)priorityLogger, (int)128, null, (String)"Requested initialize callClient...", (int)2, null);
        }
        if (this.getStatus() == CallClientStatus.RUNNING || this.getStatus() == CallClientStatus.INITIALIZING) {
            CommunicationCenter communicationCenter2 = CommunicationCenter.Companion.getInstance();
            if (communicationCenter2 == null) {
                Intrinsics.throwNpe();
            }
            PriorityLogger priorityLogger2 = communicationCenter2.getLogger$communication_center_release();
            if (priorityLogger2 != null) {
                PriorityLogger.warn$default((PriorityLogger)priorityLogger2, (int)128, null, (String)"CallClient is already initialized", (int)2, null);
            }
            return;
        }
        if (StringsKt.isBlank((CharSequence)string)) {
            CommunicationCenter communicationCenter3 = CommunicationCenter.Companion.getInstance();
            if (communicationCenter3 == null) {
                Intrinsics.throwNpe();
            }
            PriorityLogger priorityLogger3 = communicationCenter3.getLogger$communication_center_release();
            if (priorityLogger3 != null) {
                PriorityLogger.error$default((PriorityLogger)priorityLogger3, (int)128, null, (String)("User provided has not a valid userAlias: " + string), (int)2, null);
            }
            return;
        }
        CommunicationCenter communicationCenter4 = CommunicationCenter.Companion.getInstance();
        if (communicationCenter4 == null) {
            Intrinsics.throwNpe();
        }
        PriorityLogger priorityLogger4 = communicationCenter4.getLogger$communication_center_release();
        if (priorityLogger4 != null) {
            PriorityLogger.debug$default((PriorityLogger)priorityLogger4, (int)128, null, (String)("Initializing CallClient for: " + string), (int)2, null);
        }
        this.setStatus(CallClientStatus.INITIALIZING);
        this.setSessionUser(new CallClientUser(string));
        if (this.dialingChannel == null) {
            User user = this.getSessionUser();
            if (user == null) {
                Intrinsics.throwNpe();
            }
            CommunicationCenter communicationCenter5 = CommunicationCenter.Companion.getInstance();
            if (communicationCenter5 == null) {
                Intrinsics.throwNpe();
            }
            EnvironmentImpl environmentImpl = communicationCenter5.getEnvironment$communication_center_release();
            if (environmentImpl == null) {
                Intrinsics.throwNpe();
            }
            String string2 = environmentImpl.getPath();
            CommunicationCenter communicationCenter6 = CommunicationCenter.Companion.getInstance();
            if (communicationCenter6 == null) {
                Intrinsics.throwNpe();
            }
            EnvironmentImpl environmentImpl2 = communicationCenter6.getEnvironment$communication_center_release();
            if (environmentImpl2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = environmentImpl2.getQuery();
            CommunicationCenter communicationCenter7 = CommunicationCenter.Companion.getInstance();
            if (communicationCenter7 == null) {
                Intrinsics.throwNpe();
            }
            EnvironmentImpl environmentImpl3 = communicationCenter7.getEnvironment$communication_center_release();
            if (environmentImpl3 == null) {
                Intrinsics.throwNpe();
            }
            String string4 = environmentImpl3.getUrl();
            String string5 = string3;
            String string6 = string2;
            this.dialingChannel = new f(user, new DialingHost(string4, string5, string6));
        }
        i i2 = this.dialingChannel;
        if (i2 == null) {
            Intrinsics.throwNpe();
        }
        i2.a(this.incomingCallObserver);
        i i3 = this.dialingChannel;
        if (i3 == null) {
            Intrinsics.throwNpe();
        }
        i3.a((g)this.onDialingChannelObserver);
        i i4 = this.dialingChannel;
        if (i4 == null) {
            Intrinsics.throwNpe();
        }
        i4.c();
    }

    private final void createCall(List<String> list, CallOptions callOptions, OnCallCreationObserver onCallCreationObserver) {
        block6: {
            Collection<BaseCallParticipant> collection;
            BaseCallParticipants baseCallParticipants;
            if (this.getSessionUser() == null || this.getStatus() != CallClientStatus.RUNNING) {
                onCallCreationObserver.onCallCreationError(new CallException("The callClient has not been started yet!!"));
                return;
            }
            if (this.getBusy()) {
                onCallCreationObserver.onCallCreationError(new CallException("You are already in another baseCall!!"));
                return;
            }
            this.setBusy(true);
            User user = this.getSessionUser();
            if (user == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.bandyer.communication_center.call_client.CallClientUser");
            }
            BaseCallParticipant baseCallParticipant = new BaseCallParticipant((CallClientUser)user, CallParticipantStatus.INVITED);
            Object object = list;
            BaseCallParticipant baseCallParticipant2 = baseCallParticipant;
            BaseCallParticipants baseCallParticipants2 = baseCallParticipants;
            BaseCallParticipants baseCallParticipants3 = baseCallParticipants;
            Object object2 = object;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                String string = (String)t;
                collection = collection2;
                BaseCallParticipant baseCallParticipant3 = new BaseCallParticipant(new CallClientUser(string), CallParticipantStatus.INVITED);
                collection.add(baseCallParticipant3);
            }
            collection = (List)collection2;
            baseCallParticipants2(baseCallParticipant2, (List<BaseCallParticipant>)collection);
            BaseCallParticipants baseCallParticipants4 = baseCallParticipants3;
            if (this.baseCall == null) {
                i i2 = this.dialingChannel;
                if (i2 == null) {
                    Intrinsics.throwNpe();
                }
                this.baseCall = new BaseCall(callOptions, Call.Direction.OUTGOING, baseCallParticipants4, i2);
            }
            BaseCall baseCall = this.baseCall;
            if (baseCall == null) break block6;
            object2 = object = baseCall;
            ((BaseCall)object2).addEventObserver(this);
            ((BaseCall)object2).addCreationObserver(this);
            ((BaseCall)object2).addCreationObserver(onCallCreationObserver);
        }
    }

    @Override
    public void call(@NotNull List<String> list, @Nullable CallOptions callOptions, @NotNull OnCallCreationObserver onCallCreationObserver) {
        block5: {
            Intrinsics.checkParameterIsNotNull(list, (String)"users");
            Intrinsics.checkParameterIsNotNull((Object)onCallCreationObserver, (String)"onCallCreationObserver");
            if (list.isEmpty()) {
                onCallCreationObserver.onCallCreationError(new CallException("You need to provide one or more users to be called!!"));
                return;
            }
            CommunicationCenter communicationCenter = CommunicationCenter.Companion.getInstance();
            if (communicationCenter == null) {
                Intrinsics.throwNpe();
            }
            PriorityLogger priorityLogger = communicationCenter.getLogger$communication_center_release();
            if (priorityLogger != null) {
                PriorityLogger.info$default((PriorityLogger)priorityLogger, (int)128, null, (String)"Calling...", (int)2, null);
            }
            this.createCall(list, callOptions, onCallCreationObserver);
            BaseCall baseCall = this.baseCall;
            if (baseCall != null) {
                baseCall.create(this.getSessionUser());
            }
            CommunicationCenter communicationCenter2 = CommunicationCenter.Companion.getInstance();
            if (communicationCenter2 == null) {
                Intrinsics.throwNpe();
            }
            PriorityLogger priorityLogger2 = communicationCenter2.getLogger$communication_center_release();
            if (priorityLogger2 == null) break block5;
            PriorityLogger.debug$default((PriorityLogger)priorityLogger2, (int)128, null, (String)("Created call: " + this.baseCall), (int)2, null);
        }
    }

    @Override
    public void join(@NotNull String string, @NotNull OnCallCreationObserver onCallCreationObserver) {
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)onCallCreationObserver, (String)"onCallCreationObserver");
            if (StringsKt.isBlank((CharSequence)string)) {
                onCallCreationObserver.onCallCreationError(new CallException("You need to provide a valid url!!"));
                return;
            }
            CommunicationCenter communicationCenter = CommunicationCenter.Companion.getInstance();
            if (communicationCenter == null) {
                Intrinsics.throwNpe();
            }
            PriorityLogger priorityLogger = communicationCenter.getLogger$communication_center_release();
            if (priorityLogger != null) {
                PriorityLogger.info$default((PriorityLogger)priorityLogger, (int)128, null, (String)"Joining call...", (int)2, null);
            }
            CallClient callClient = this;
            List list = CollectionsKt.emptyList();
            callClient.createCall(list, null, onCallCreationObserver);
            BaseCall baseCall = this.baseCall;
            if (baseCall != null) {
                baseCall.joinCall(string, this.getSessionUser());
            }
            CommunicationCenter communicationCenter2 = CommunicationCenter.Companion.getInstance();
            if (communicationCenter2 == null) {
                Intrinsics.throwNpe();
            }
            PriorityLogger priorityLogger2 = communicationCenter2.getLogger$communication_center_release();
            if (priorityLogger2 == null) break block5;
            PriorityLogger.debug$default((PriorityLogger)priorityLogger2, (int)128, null, (String)("Joining call: " + this.baseCall + " \nwith: " + string), (int)2, null);
        }
    }

    @Override
    public void handleNotification(@NotNull String string, @NotNull OnNotificationObserver onNotificationObserver) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)onNotificationObserver, (String)"onNotificationObserver");
        this.parseNotification(string, (Function1<? super DialCallResponse, Unit>)((Function1)new Function1<DialCallResponse, Unit>(this, onNotificationObserver){
            final /* synthetic */ CallClient this$0;
            final /* synthetic */ OnNotificationObserver $onNotificationObserver;

            public final void invoke(@NotNull DialCallResponse dialCallResponse) {
                Intrinsics.checkParameterIsNotNull((Object)dialCallResponse, (String)"response");
                CallOptionResponse callOptionResponse = dialCallResponse.getOptions();
                CallOptionResponse callOptionResponse2 = dialCallResponse.getOptions();
                CallOptionResponse callOptionResponse3 = dialCallResponse.getOptions();
                CallOptions callOptions = new CallOptions(callOptionResponse != null ? callOptionResponse.getRecord() : false, callOptionResponse2 != null ? callOptionResponse2.getDuration() : 0, callOptionResponse3 != null ? callOptionResponse3.getCreationDate() : null);
                String string = dialCallResponse.getRoomAlias();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                BaseCallParticipants baseCallParticipants = dialCallResponse.getParticipants();
                if (baseCallParticipants == null) {
                    Intrinsics.throwNpe();
                }
                i i2 = this.this$0.getDialingChannel$communication_center_release();
                if (i2 == null) {
                    Intrinsics.throwNpe();
                }
                this.this$0.notifyIncomingCall$communication_center_release(string, new BaseCall(callOptions, Call.Direction.INCOMING, baseCallParticipants, i2), (Function1<? super IncomingCall, Unit>)((Function1)new Function1<IncomingCall, Unit>(this){
                    final /* synthetic */ handleNotification.1 this$0;

                    public final void invoke(@NotNull IncomingCall incomingCall) {
                        Intrinsics.checkParameterIsNotNull((Object)incomingCall, (String)"it");
                        this.this$0.$onNotificationObserver.onSuccess(incomingCall);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = callClient;
                this.$onNotificationObserver = onNotificationObserver;
                super(1);
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(onNotificationObserver){
            final /* synthetic */ OnNotificationObserver $onNotificationObserver;

            public final void invoke(@NotNull String string) {
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"it");
                this.$onNotificationObserver.onError(string);
            }
            {
                this.$onNotificationObserver = onNotificationObserver;
                super(1);
            }
        }));
    }

    @Override
    public void destroy() {
        block9: {
            CommunicationCenter communicationCenter = CommunicationCenter.Companion.getInstance();
            if (communicationCenter == null) {
                Intrinsics.throwNpe();
            }
            PriorityLogger priorityLogger = communicationCenter.getLogger$communication_center_release();
            if (priorityLogger != null) {
                PriorityLogger.info$default((PriorityLogger)priorityLogger, (int)128, null, (String)"Destroying CallClient...", (int)2, null);
            }
            CommunicationCenter communicationCenter2 = CommunicationCenter.Companion.getInstance();
            if (communicationCenter2 == null) {
                Intrinsics.throwNpe();
            }
            PriorityLogger priorityLogger2 = communicationCenter2.getLogger$communication_center_release();
            if (priorityLogger2 != null) {
                PriorityLogger.debug$default((PriorityLogger)priorityLogger2, (int)128, null, (String)("Destroying CallClient " + this), (int)2, null);
            }
            this.setSessionUser(null);
            this.setBusy(false);
            this.setStatus(CallClientStatus.DESTROYED);
            this.statusCallObservers.onCallClientDestroyed();
            BaseCall baseCall = this.baseCall;
            if (baseCall != null) {
                baseCall.dispose(Call.Status.ENDED, Call.EndReason.NONE);
            }
            this.baseCall = null;
            this.incomingCallObservers.removeAllObservers$communication_center_release();
            this.statusCallObservers.removeAllObservers$communication_center_release();
            i i2 = this.dialingChannel;
            if (i2 != null) {
                i2.b((g)this.onDialingChannelObserver);
            }
            i i3 = this.dialingChannel;
            if (i3 != null) {
                i3.d();
            }
            this.dialingChannel = null;
            List<IncomingCall> list = this.incomingCalls;
            if (list != null) {
                list.clear();
            }
            CommunicationCenter communicationCenter3 = CommunicationCenter.Companion.getInstance();
            if (communicationCenter3 == null) {
                Intrinsics.throwNpe();
            }
            PriorityLogger priorityLogger3 = communicationCenter3.getLogger$communication_center_release();
            if (priorityLogger3 == null) break block9;
            PriorityLogger.debug$default((PriorityLogger)priorityLogger3, (int)128, null, (String)("CallClient " + (Object)((Object)this.getStatus())), (int)2, null);
        }
    }

    @Override
    public void stop() {
        block3: {
            if (this.getStatus() != CallClientStatus.RUNNING) {
                return;
            }
            CommunicationCenter communicationCenter = CommunicationCenter.Companion.getInstance();
            if (communicationCenter == null) {
                Intrinsics.throwNpe();
            }
            PriorityLogger priorityLogger = communicationCenter.getLogger$communication_center_release();
            if (priorityLogger != null) {
                PriorityLogger.info$default((PriorityLogger)priorityLogger, (int)128, null, (String)"CallClient stopping...", (int)2, null);
            }
            i i2 = this.dialingChannel;
            if (i2 == null) break block3;
            i2.d();
        }
    }

    @Override
    public void resume() {
        block3: {
            if (this.getStatus() != CallClientStatus.STOPPED) {
                return;
            }
            CommunicationCenter communicationCenter = CommunicationCenter.Companion.getInstance();
            if (communicationCenter == null) {
                Intrinsics.throwNpe();
            }
            PriorityLogger priorityLogger = communicationCenter.getLogger$communication_center_release();
            if (priorityLogger != null) {
                PriorityLogger.info$default((PriorityLogger)priorityLogger, (int)128, null, (String)"CallClient resuming...", (int)2, null);
            }
            i i2 = this.dialingChannel;
            if (i2 == null) break block3;
            i2.c();
        }
    }

    @Override
    @NotNull
    public CallClient addIncomingCallObserver(@NotNull OnIncomingCallObserver onIncomingCallObserver) {
        Intrinsics.checkParameterIsNotNull((Object)onIncomingCallObserver, (String)"observer");
        this.incomingCallObservers.addObserver(onIncomingCallObserver);
        return this;
    }

    @Override
    @NotNull
    public CallClient removeIncomingCallObserver(@NotNull OnIncomingCallObserver onIncomingCallObserver) {
        Intrinsics.checkParameterIsNotNull((Object)onIncomingCallObserver, (String)"observer");
        this.incomingCallObservers.removeObserver(onIncomingCallObserver);
        return this;
    }

    @Override
    @NotNull
    public CallClientInstance addStatusObserver(@NotNull OnCallClientObserver onCallClientObserver) {
        Intrinsics.checkParameterIsNotNull((Object)onCallClientObserver, (String)"observer");
        this.statusCallObservers.addObserver(onCallClientObserver);
        return this;
    }

    @Override
    @NotNull
    public CallClientInstance removeStatusObserver(@NotNull OnCallClientObserver onCallClientObserver) {
        Intrinsics.checkParameterIsNotNull((Object)onCallClientObserver, (String)"observer");
        this.statusCallObservers.removeObserver(onCallClientObserver);
        return this;
    }

    @NotNull
    public final e getOnDialingChannelObserver$communication_center_release() {
        return this.onDialingChannelObserver;
    }

    public final void setOnDialingChannelObserver$communication_center_release(@NotNull e e2) {
        Intrinsics.checkParameterIsNotNull((Object)e2, (String)"<set-?>");
        this.onDialingChannelObserver = e2;
    }

    @Override
    public void onCallStarted(@NotNull Call call, @NotNull RoomToken roomToken) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)roomToken, (String)"roomToken");
    }

    @Override
    public void onCallEnded(@NotNull Call call, @NotNull Call.EndReason endReason) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)((Object)endReason), (String)"callEndReason");
        this.setBusy(false);
        this.baseCall = null;
    }

    @Override
    public void onCallError(@NotNull Call call, @NotNull CallException callException) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)callException, (String)"reason");
        this.setBusy(false);
        this.baseCall = null;
    }

    @Override
    public void onCallCreationSuccess(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
    }

    @Override
    public void onCallStatusChanged(@NotNull Call call, @NotNull Call.Status status) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
    }

    @Override
    public void onCallCreationError(@NotNull CallException callException) {
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)callException, (String)"reason");
                if (this.baseCall == null) break block4;
                BaseCall baseCall = this.baseCall;
                if ((baseCall != null ? baseCall.getDirection() : null) != Call.Direction.INCOMING) break block5;
            }
            return;
        }
        this.setBusy(false);
        BaseCall baseCall = this.baseCall;
        if (baseCall != null) {
            baseCall.dispose(Call.Status.FAILED, Call.EndReason.ERROR);
        }
        this.baseCall = null;
    }

    @NotNull
    public final b getIncomingCallObserver$communication_center_release() {
        return this.incomingCallObserver;
    }

    public final void setIncomingCallObserver$communication_center_release(@NotNull b b2) {
        Intrinsics.checkParameterIsNotNull((Object)b2, (String)"<set-?>");
        this.incomingCallObserver = b2;
    }

    public final void notifyIncomingCall$communication_center_release(@NotNull String string, @NotNull BaseCall baseCall, @NotNull Function1<? super IncomingCall, Unit> function1) {
        block5: {
            BaseCall baseCall2;
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"callId");
            Intrinsics.checkParameterIsNotNull((Object)baseCall, (String)"incomingCall");
            Intrinsics.checkParameterIsNotNull(function1, (String)"callback");
            if (this.baseCall != null) {
                return;
            }
            CommunicationCenter communicationCenter = CommunicationCenter.Companion.getInstance();
            if (communicationCenter == null) {
                Intrinsics.throwNpe();
            }
            PriorityLogger priorityLogger = communicationCenter.getLogger$communication_center_release();
            if (priorityLogger != null) {
                PriorityLogger.info$default((PriorityLogger)priorityLogger, (int)128, null, (String)"Incoming call...", (int)2, null);
            }
            BaseCall baseCall3 = baseCall2 = baseCall;
            baseCall3.setRemoteId(string);
            baseCall3.setStatus(Call.Status.RINGING);
            baseCall3.getCallEventsObservers().onCallStatusChanged(baseCall3, baseCall3.getStatus());
            baseCall3.addEventObserver(this);
            baseCall3.addCreationObserver(this);
            this.baseCall = baseCall;
            List<IncomingCall> list = this.incomingCalls;
            if (list != null) {
                list.add(baseCall);
            }
            function1.invoke((Object)baseCall);
            CommunicationCenter communicationCenter2 = CommunicationCenter.Companion.getInstance();
            if (communicationCenter2 == null) {
                Intrinsics.throwNpe();
            }
            PriorityLogger priorityLogger2 = communicationCenter2.getLogger$communication_center_release();
            if (priorityLogger2 == null) break block5;
            PriorityLogger.debug$default((PriorityLogger)priorityLogger2, (int)128, null, (String)("Incoming call: " + this.baseCall), (int)2, null);
        }
    }

    private final void parseNotification(String string, Function1<? super DialCallResponse, Unit> function1, Function1<? super String, Unit> function12) {
        try {
            CommunicationCenter communicationCenter = CommunicationCenter.Companion.getInstance();
            if (communicationCenter == null) {
                Intrinsics.throwNpe();
            }
            PriorityLogger priorityLogger = communicationCenter.getLogger$communication_center_release();
            if (priorityLogger != null) {
                PriorityLogger.info$default((PriorityLogger)priorityLogger, (int)128, null, (String)"Parsing notification...", (int)2, null);
            }
            Type type = new TypeToken<Response<DialCallResponse>>(){}.getType();
            CommunicationCenter communicationCenter2 = CommunicationCenter.Companion.getInstance();
            if (communicationCenter2 == null) {
                Intrinsics.throwNpe();
            }
            Object object = communicationCenter2.getGson().fromJson(string, type);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"CommunicationCenter.inst\u2026on(payload, responseType)");
            Response response = (Response)object;
            if (response.getError() != null) {
                ResponseError responseError = response.getError();
                if (responseError == null) {
                    Intrinsics.throwNpe();
                }
                throw (Throwable)responseError;
            }
            CommunicationCenter communicationCenter3 = CommunicationCenter.Companion.getInstance();
            if (communicationCenter3 == null) {
                Intrinsics.throwNpe();
            }
            PriorityLogger priorityLogger2 = communicationCenter3.getLogger$communication_center_release();
            if (priorityLogger2 != null) {
                StringBuilder stringBuilder = new StringBuilder().append(' ');
                CommunicationCenter communicationCenter4 = CommunicationCenter.Companion.getInstance();
                if (communicationCenter4 == null) {
                    Intrinsics.throwNpe();
                }
                PriorityLogger.debug$default((PriorityLogger)priorityLogger2, (int)128, null, (String)stringBuilder.append(communicationCenter4.getGson().toJson((Object)string)).toString(), (int)2, null);
            }
            Object t = response.getData();
            if (t == null) {
                Intrinsics.throwNpe();
            }
            function1.invoke(t);
        }
        catch (Throwable throwable) {
            function12.invoke((Object)"Failed to parse the notification payload!!");
        }
    }

    private CallClient() {
        List list;
        CallClient callClient = this;
        callClient.incomingCalls = list = (List)new ArrayList();
        this.incomingCallObservers = new OnIncomingCallObservable();
        this.statusCallObservers = new OnCallClientObservable();
        this.onDialingChannelObserver = new e(this){
            final /* synthetic */ CallClient this$0;

            public void onCallDeclined(@NotNull String string, @NotNull String string2, @NotNull Call.DeclineReason declineReason) {
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"remoteId");
                Intrinsics.checkParameterIsNotNull((Object)string2, (String)"userAlias");
                Intrinsics.checkParameterIsNotNull((Object)((Object)declineReason), (String)"reason");
            }

            public void onCallAnswered(@NotNull String string, @NotNull String string2) {
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"remoteId");
                Intrinsics.checkParameterIsNotNull((Object)string2, (String)"userAlias");
            }

            public void onCallEnded(@NotNull String string, @Nullable String string2, @NotNull Call.EndReason endReason) {
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"remoteId");
                Intrinsics.checkParameterIsNotNull((Object)((Object)endReason), (String)"reason");
            }

            public void onCallError(@NotNull String string, @NotNull c c2) {
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"remoteId");
                Intrinsics.checkParameterIsNotNull((Object)c2, (String)"reason");
            }

            public void onCallParticipantStatusChanged(@NotNull String string, @Nullable String string2, @NotNull CallParticipantStatus callParticipantStatus) {
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"remoteId");
                Intrinsics.checkParameterIsNotNull((Object)((Object)callParticipantStatus), (String)"participantStatus");
            }

            public void onUserAuthenticated(@NotNull CallClientUser callClientUser) {
                Intrinsics.checkParameterIsNotNull((Object)callClientUser, (String)"user");
                this.this$0.setSessionUser(callClientUser);
            }

            public void onUserAuthenticationError(@NotNull c c2) {
                Intrinsics.checkParameterIsNotNull((Object)c2, (String)"reason");
                CommunicationCenter communicationCenter = CommunicationCenter.Companion.getInstance();
                if (communicationCenter == null) {
                    Intrinsics.throwNpe();
                }
                PriorityLogger priorityLogger = communicationCenter.getLogger$communication_center_release();
                if (priorityLogger != null) {
                    PriorityLogger.info$default((PriorityLogger)priorityLogger, (int)128, null, (String)"CallClient failed authentication", (int)2, null);
                }
                CommunicationCenter communicationCenter2 = CommunicationCenter.Companion.getInstance();
                if (communicationCenter2 == null) {
                    Intrinsics.throwNpe();
                }
                PriorityLogger priorityLogger2 = communicationCenter2.getLogger$communication_center_release();
                if (priorityLogger2 != null) {
                    PriorityLogger.debug$default((PriorityLogger)priorityLogger2, (int)128, null, (String)("CallClient " + c2), (int)2, null);
                }
                this.this$0.getStatusCallObservers$communication_center_release().onCallClientFailed();
                this.this$0.destroy();
            }

            public void onChannelConnected() {
                block4: {
                    CallClientStatus callClientStatus = this.this$0.getStatus();
                    this.this$0.setStatus(CallClientStatus.RUNNING);
                    if (callClientStatus == CallClientStatus.INITIALIZING) {
                        User user = this.this$0.getSessionUser();
                        if (user == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.bandyer.communication_center.call_client.User");
                        }
                        this.this$0.getStatusCallObservers$communication_center_release().onCallClientInitialized(user);
                    } else {
                        this.this$0.getStatusCallObservers$communication_center_release().onCallClientResumed();
                    }
                    CommunicationCenter communicationCenter = CommunicationCenter.Companion.getInstance();
                    if (communicationCenter == null) {
                        Intrinsics.throwNpe();
                    }
                    PriorityLogger priorityLogger = communicationCenter.getLogger$communication_center_release();
                    if (priorityLogger == null) break block4;
                    PriorityLogger.debug$default((PriorityLogger)priorityLogger, (int)128, null, (String)("CallClient " + (Object)((Object)this.this$0.getStatus())), (int)2, null);
                }
            }

            public void onChannelDisconnected() {
                if (this.this$0.getStatus() == CallClientStatus.DESTROYED || this.this$0.getStatus() == CallClientStatus.STOPPED) {
                    return;
                }
                this.this$0.setStatus(CallClientStatus.STOPPED);
                CommunicationCenter communicationCenter = CommunicationCenter.Companion.getInstance();
                if (communicationCenter == null) {
                    Intrinsics.throwNpe();
                }
                PriorityLogger priorityLogger = communicationCenter.getLogger$communication_center_release();
                if (priorityLogger != null) {
                    PriorityLogger.debug$default((PriorityLogger)priorityLogger, (int)128, null, (String)("CallClient " + (Object)((Object)this.this$0.getStatus())), (int)2, null);
                }
                this.this$0.getStatusCallObservers$communication_center_release().onCallClientStopped();
            }

            public void onChannelReconnecting() {
                if (this.this$0.getStatus() != CallClientStatus.RUNNING) {
                    return;
                }
                this.this$0.setStatus(CallClientStatus.RECONNECTING);
                CommunicationCenter communicationCenter = CommunicationCenter.Companion.getInstance();
                if (communicationCenter == null) {
                    Intrinsics.throwNpe();
                }
                PriorityLogger priorityLogger = communicationCenter.getLogger$communication_center_release();
                if (priorityLogger != null) {
                    PriorityLogger.debug$default((PriorityLogger)priorityLogger, (int)128, null, (String)("CallClient " + (Object)((Object)this.this$0.getStatus())), (int)2, null);
                }
                this.this$0.getStatusCallObservers$communication_center_release().onCallClientReconnecting();
            }
            {
                this.this$0 = callClient;
            }
        };
        this.incomingCallObserver = new b(this){
            final /* synthetic */ CallClient this$0;

            public void onIncomingCall(@NotNull String string, @Nullable CallOptionResponse callOptionResponse, @NotNull BaseCallParticipants baseCallParticipants) {
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"callId");
                Intrinsics.checkParameterIsNotNull((Object)baseCallParticipants, (String)"participants");
                CallOptionResponse callOptionResponse2 = callOptionResponse;
                CallOptionResponse callOptionResponse3 = callOptionResponse;
                CallOptionResponse callOptionResponse4 = callOptionResponse;
                CallOptions callOptions = new CallOptions(callOptionResponse2 != null ? callOptionResponse2.getRecord() : false, callOptionResponse3 != null ? callOptionResponse3.getDuration() : 0, callOptionResponse4 != null ? callOptionResponse4.getCreationDate() : null);
                i i2 = this.this$0.getDialingChannel$communication_center_release();
                if (i2 == null) {
                    Intrinsics.throwNpe();
                }
                this.this$0.notifyIncomingCall$communication_center_release(string, new BaseCall(callOptions, Call.Direction.INCOMING, baseCallParticipants, i2), (Function1<? super IncomingCall, Unit>)((Function1)new Function1<IncomingCall, Unit>(this){
                    final /* synthetic */ incomingCallObserver.1 this$0;

                    public final void invoke(@NotNull IncomingCall incomingCall) {
                        Intrinsics.checkParameterIsNotNull((Object)incomingCall, (String)"it");
                        this.this$0.this$0.getIncomingCallObservers$communication_center_release().onIncomingCall(incomingCall);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = callClient;
            }
        };
    }

    static {
        _ = new _(null);
    }

    @Override
    public void call(@NotNull List<String> list, @NotNull OnCallCreationObserver onCallCreationObserver) {
        Intrinsics.checkParameterIsNotNull(list, (String)"users");
        Intrinsics.checkParameterIsNotNull((Object)onCallCreationObserver, (String)"onCallCreationObserver");
        CallClientInstance.DefaultImpls.call(this, list, onCallCreationObserver);
    }

    public /* synthetic */ CallClient(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }

    @JvmStatic
    @NotNull
    public static final CallClientInstance getInstance() {
        return _.getInstance();
    }

    @JvmStatic
    public static final void setSingletonInstance$communication_center_release(@NotNull CallClient callClient) {
        _.setSingletonInstance$communication_center_release(callClient);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\u0004H\u0007J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u000eR \u0010\u0003\u001a\u0004\u0018\u00010\u00048B@\u0002X\u0083\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/bandyer/communication_center/call_client/CallClient$_;", "", "()V", "mInstance", "Lcom/bandyer/communication_center/call_client/CallClientInstance;", "getMInstance", "()Lcom/bandyer/communication_center/call_client/CallClientInstance;", "setMInstance", "(Lcom/bandyer/communication_center/call_client/CallClientInstance;)V", "getInstance", "setSingletonInstance", "", "callClient", "Lcom/bandyer/communication_center/call_client/CallClient;", "setSingletonInstance$communication_center_release", "communication_center_release"})
    public static final class _ {
        private final CallClientInstance getMInstance() {
            CommunicationCenter.Companion.getInstance();
            return mInstance;
        }

        private final void setMInstance(CallClientInstance callClientInstance) {
            mInstance = callClientInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final CallClientInstance getInstance() {
            if (this.getMInstance() == null) {
                Class<CallClient> clazz = CallClient.class;
                synchronized (clazz) {
                    if (_.getMInstance() == null) {
                        _.setMInstance(new CallClient(null));
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            CallClientInstance callClientInstance = this.getMInstance();
            if (callClientInstance == null) {
                Intrinsics.throwNpe();
            }
            return callClientInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void setSingletonInstance$communication_center_release(@NotNull CallClient callClient) {
            Intrinsics.checkParameterIsNotNull((Object)callClient, (String)"callClient");
            Class<CallClient> clazz = CallClient.class;
            synchronized (clazz) {
                _.setMInstance(callClient);
                Unit unit = Unit.INSTANCE;
            }
        }

        private _() {
        }

        public /* synthetic */ _(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

