/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.android_sdk.chat;

import android.content.Context;
import androidx.appcompat.app.AppCompatActivity;
import com.bandyer.android_chat_sdk.ChatAuthenticationException;
import com.bandyer.android_chat_sdk.ChatClient;
import com.bandyer.android_chat_sdk.ChatClientObserver;
import com.bandyer.android_chat_sdk.ChatClientState;
import com.bandyer.android_chat_sdk.IncomingChatMessage;
import com.bandyer.android_chat_sdk.OnIncomingChatMessageObserver;
import com.bandyer.android_chat_sdk.OnNotificationObserver;
import com.bandyer.android_sdk.BandyerSDK;
import com.bandyer.android_sdk.ForegroundBackgroundOperationsDispatcher;
import com.bandyer.android_sdk.chat.ChatException;
import com.bandyer.android_sdk.chat.ChatModule;
import com.bandyer.android_sdk.chat.ChatModuleImpl;
import com.bandyer.android_sdk.chat.ChatModuleImpl$WhenMappings;
import com.bandyer.android_sdk.chat.ChatObserver;
import com.bandyer.android_sdk.chat.notification.internal.b;
import com.bandyer.android_sdk.module.AuthenticationException;
import com.bandyer.android_sdk.module.BandyerModuleObserver;
import com.bandyer.android_sdk.module.BandyerModuleStatus;
import com.bandyer.android_sdk.module.BaseBandyerModule;
import com.bandyer.android_sdk.notification.BandyerNotificator;
import com.bandyer.android_sdk.utils.BandyerSDKLogger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000s\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n*\u0001\u0016\b\u0000\u0018\u0000 @2\u00020\u00012\u00020\u0002:\u0001@B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0012H\u0016J\b\u0010/\u001a\u00020-H\u0016J2\u00100\u001a\u00020-2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00062\f\u00102\u001a\b\u0012\u0004\u0012\u00020-032\f\u00104\u001a\b\u0012\u0004\u0012\u00020-03J\u0012\u00105\u001a\u00020-2\n\b\u0002\u00106\u001a\u0004\u0018\u000107J\u0006\u00108\u001a\u00020-J\b\u00109\u001a\u00020-H\u0016J\b\u0010:\u001a\u00020-H\u0016J\u0010\u0010;\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0012H\u0016J\b\u0010<\u001a\u00020-H\u0016J\b\u0010=\u001a\u00020-H\u0016J\b\u0010>\u001a\u00020-H\u0016J\b\u0010?\u001a\u00020-H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010 \u001a\u00020!X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006A"}, d2={"Lcom/bandyer/android_sdk/chat/ChatModuleImpl;", "Lcom/bandyer/android_sdk/module/BaseBandyerModule;", "Lcom/bandyer/android_sdk/chat/ChatModule;", "context", "Landroid/content/Context;", "userAlias", "", "bandyerModuleObserver", "Lcom/bandyer/android_sdk/module/BandyerModuleObserver;", "(Landroid/content/Context;Ljava/lang/String;Lcom/bandyer/android_sdk/module/BandyerModuleObserver;)V", "canInit", "", "getCanInit", "()Z", "chatClientObserver", "Lcom/bandyer/android_chat_sdk/ChatClientObserver;", "chatObservers", "", "Lcom/bandyer/android_sdk/chat/ChatObserver;", "getChatObservers", "()Ljava/util/List;", "incomingChatObserver", "com/bandyer/android_sdk/chat/ChatModuleImpl$incomingChatObserver$1", "Lcom/bandyer/android_sdk/chat/ChatModuleImpl$incomingChatObserver$1;", "isChatStarted", "isReady", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "lock$delegate", "Lkotlin/Lazy;", "reconnectionAttempts", "", "getReconnectionAttempts", "()I", "setReconnectionAttempts", "(I)V", "status", "Lcom/bandyer/android_sdk/module/BandyerModuleStatus;", "getStatus", "()Lcom/bandyer/android_sdk/module/BandyerModuleStatus;", "setStatus", "(Lcom/bandyer/android_sdk/module/BandyerModuleStatus;)V", "addChatObserver", "", "observer", "destroy", "handleNotification", "payload", "successCallback", "Lkotlin/Function0;", "errorCallback", "notifyChatEnded", "chatException", "Lcom/bandyer/android_sdk/chat/ChatException;", "notifyChatStarted", "reconnect", "removeAllChatObservers", "removeChatObserver", "resume", "startListening", "stop", "stopListening", "Companion", "bandyer-android-sdk_release"})
public final class ChatModuleImpl
extends BaseBandyerModule
implements ChatModule {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    public static final String TAG = "Chat Module";
    public static final Companion Companion;
    @NotNull
    private final List<ChatObserver> chatObservers = new ArrayList<ChatObserver>();
    private final Lazy lock$delegate = LazyKt.lazy((Function0)lock.2.INSTANCE);
    private boolean isChatStarted;
    private final boolean canInit;
    @NotNull
    private BandyerModuleStatus status;
    private final incomingChatObserver.1 incomingChatObserver;
    private final ChatClientObserver chatClientObserver;
    private int reconnectionAttempts;

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ChatModuleImpl.class), "lock", "getLock()Ljava/util/concurrent/locks/ReentrantReadWriteLock;"))};
        Companion = new Companion(null);
    }

    private final ReentrantReadWriteLock getLock() {
        KProperty cfr_ignored_0 = $$delegatedProperties[0];
        return (ReentrantReadWriteLock)this.lock$delegate.getValue();
    }

    public static /* synthetic */ void notifyChatEnded$default(ChatModuleImpl chatModuleImpl, ChatException chatException, int n2, Object object) {
        if ((n2 & 1) != 0) {
            chatException = null;
        }
        chatModuleImpl.notifyChatEnded(chatException);
    }

    public ChatModuleImpl(@NotNull Context context, @NotNull String string2, @NotNull BandyerModuleObserver bandyerModuleObserver) {
        super(context, string2, bandyerModuleObserver);
        boolean bl = ChatClient.Companion.getInstance().getState() == ChatClientState.UNINITIALIZED;
        ChatModuleImpl chatModuleImpl = this;
        chatModuleImpl.canInit = bl;
        chatModuleImpl.status = BandyerModuleStatus.DISCONNECTED;
        chatModuleImpl.incomingChatObserver = new OnIncomingChatMessageObserver(this, context){
            final /* synthetic */ ChatModuleImpl this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = chatModuleImpl;
                this.$context = context;
            }

            public void onIncomingChatMessage(@NotNull IncomingChatMessage incomingChatMessage) {
                b.c.a(bandyerSDKLogger.$context, incomingChatMessage);
                BandyerNotificator.INSTANCE.notificateChatListeners(bandyerSDKLogger.$context, ChatModuleImpl.access$getBandyerSdk$p(bandyerSDKLogger.this$0), incomingChatMessage);
                BandyerSDKLogger bandyerSDKLogger = ChatModuleImpl.access$getBandyerSdk$p(bandyerSDKLogger.this$0).getLogger$bandyer_android_sdk_release();
                if (bandyerSDKLogger != null) {
                    bandyerSDKLogger.info("Chat Module", "on incoming chat message...");
                }
            }
        };
        chatModuleImpl.chatClientObserver = new ChatClientObserver(this){
            final /* synthetic */ ChatModuleImpl this$0;
            {
                this.this$0 = chatModuleImpl;
            }

            public void onChatClientConnectionError(@NotNull Throwable throwable) {
                if (throwable instanceof ChatAuthenticationException) {
                    ChatModuleImpl.access$failed(this.this$0, new AuthenticationException("Authentication failed!"));
                } else {
                    ChatModuleImpl.access$statusChanged(this.this$0, BandyerModuleStatus.DISCONNECTED);
                }
            }

            public void onStatusChange(@NotNull ChatClientState chatClientState) {
                switch (ChatModuleImpl$WhenMappings.$EnumSwitchMapping$0[chatClientState.ordinal()]) {
                    default: {
                        break;
                    }
                    case 6: {
                        chatClientObserver.1 v0 = this;
                        v0.this$0.setReconnectionAttempts(0);
                        ChatModuleImpl.access$statusChanged(v0.this$0, BandyerModuleStatus.CONNECTED);
                        break;
                    }
                    case 5: {
                        ChatModuleImpl.access$paused(this.this$0);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        ChatModuleImpl.access$statusChanged(this.this$0, BandyerModuleStatus.CONNECTING);
                        if (chatClientState != ChatClientState.OFFLINE) break;
                        ChatModuleImpl.access$moduleReady(this.this$0);
                        break;
                    }
                    case 1: {
                        ChatModuleImpl.access$statusChanged(this.this$0, BandyerModuleStatus.INITIALIZING);
                    }
                }
            }
        };
        ChatClient.Companion.getInstance().addChatClientStateObserver(this.chatClientObserver);
        ChatClient.Companion.getInstance().init(this.getBandyerSdk().getApplicationContext$bandyer_android_sdk_release(), string2);
    }

    public static final /* synthetic */ BandyerSDK access$getBandyerSdk$p(ChatModuleImpl chatModuleImpl) {
        return chatModuleImpl.getBandyerSdk();
    }

    public static final /* synthetic */ void access$failed(ChatModuleImpl chatModuleImpl, Throwable throwable) {
        chatModuleImpl.failed(throwable);
    }

    public static final /* synthetic */ void access$statusChanged(ChatModuleImpl chatModuleImpl, BandyerModuleStatus bandyerModuleStatus) {
        chatModuleImpl.statusChanged(bandyerModuleStatus);
    }

    public static final /* synthetic */ void access$moduleReady(ChatModuleImpl chatModuleImpl) {
        chatModuleImpl.moduleReady();
    }

    public static final /* synthetic */ void access$paused(ChatModuleImpl chatModuleImpl) {
        chatModuleImpl.paused();
    }

    @Override
    @NotNull
    public List<ChatObserver> getChatObservers() {
        List<ChatObserver> list;
        ChatModuleImpl chatModuleImpl = readLock;
        ReentrantReadWriteLock.ReadLock readLock = chatModuleImpl.getLock().readLock();
        readLock.lock();
        try {
            list = chatModuleImpl.chatObservers;
            readLock.unlock();
        }
        catch (Throwable throwable) {
            readLock.unlock();
            throw throwable;
        }
        return list;
    }

    @Override
    public boolean getCanInit() {
        return this.canInit;
    }

    @Override
    @NotNull
    public BandyerModuleStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(@NotNull BandyerModuleStatus bandyerModuleStatus) {
        this.status = bandyerModuleStatus;
    }

    @Override
    public boolean isReady() {
        return this.getStatus() == BandyerModuleStatus.CONNECTED || this.getStatus() == BandyerModuleStatus.READY;
    }

    public final void handleNotification(@NotNull Context context, @NotNull String string2, @NotNull Function0<Unit> function0, @NotNull Function0<Unit> function02) {
        if (ChatClient.Companion.getInstance().getState() == ChatClientState.UNINITIALIZED) {
            if ((this = ((BaseBandyerModule)this).getBandyerSdk().getLogger$bandyer_android_sdk_release()) != null) {
                ((BandyerSDKLogger)((Object)this)).error(TAG, "handleNotification error: You must have the BandyerSDKClient running!");
            }
            function02.invoke();
            return;
        }
        if (ForegroundBackgroundOperationsDispatcher.b.a()) {
            if ((this = ((BaseBandyerModule)this).getBandyerSdk().getLogger$bandyer_android_sdk_release()) != null) {
                ((BandyerSDKLogger)((Object)this)).warn(TAG, "handleNotification error: You should not handle a notification while in foreground and running!");
            }
            function02.invoke();
            return;
        }
        ChatClient.Companion.getInstance().handleNotification(string2, new OnNotificationObserver((ChatModuleImpl)this, context, function0, function02){
            final /* synthetic */ ChatModuleImpl this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ Function0 $successCallback;
            final /* synthetic */ Function0 $errorCallback;
            {
                this.this$0 = chatModuleImpl;
                this.$context = context;
                this.$successCallback = function0;
                this.$errorCallback = function02;
            }

            public void onSuccess(@NotNull IncomingChatMessage incomingChatMessage) {
                BandyerSDKLogger bandyerSDKLogger = ChatModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release();
                if (bandyerSDKLogger != null) {
                    bandyerSDKLogger.info("Chat Module", "Handling notification payload...");
                }
                if ((bandyerSDKLogger = ChatModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release()) != null) {
                    bandyerSDKLogger.debug("Chat Module", "Notification handle payload success: " + incomingChatMessage);
                }
                BandyerNotificator.INSTANCE.notificateChatListeners(this.$context, ChatModuleImpl.access$getBandyerSdk$p(this.this$0), incomingChatMessage);
                this.$successCallback.invoke();
            }

            public void onError(@NotNull String string2) {
                BandyerSDKLogger bandyerSDKLogger = ChatModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release();
                if (bandyerSDKLogger != null) {
                    bandyerSDKLogger.error("Chat Module", "Notification handle payload error: " + string2);
                }
                this.$errorCallback.invoke();
            }
        });
    }

    @Override
    public void reconnect() {
        if (this.getStatus() == BandyerModuleStatus.FAILED) {
            return;
        }
        ChatModuleImpl chatModuleImpl = this;
        chatModuleImpl.setReconnectionAttempts(chatModuleImpl.getReconnectionAttempts() + 1);
        chatModuleImpl.statusChanged(BandyerModuleStatus.RECONNECTING);
        ChatClient.Companion.getInstance().connect();
    }

    @Override
    public int getReconnectionAttempts() {
        return this.reconnectionAttempts;
    }

    public void setReconnectionAttempts(int n2) {
        this.reconnectionAttempts = n2;
    }

    @Override
    public void stop() {
        this.setReconnectionAttempts(0);
        ChatClient.Companion.getInstance().stop();
    }

    @Override
    public void resume() {
        ChatClient.Companion.getInstance().resume();
    }

    @Override
    public void destroy() {
        this.setReconnectionAttempts(0);
        ChatClient.Companion.getInstance().dispose();
    }

    @Override
    public void startListening() {
        ChatClient.Companion.getInstance().addIncomingChatMessageObserver((OnIncomingChatMessageObserver)this.incomingChatObserver);
    }

    @Override
    public void stopListening() {
        ChatClient.Companion.getInstance().removeIncomingChatMessageObserver((OnIncomingChatMessageObserver)this.incomingChatObserver);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void notifyChatStarted() {
        ReentrantReadWriteLock.ReadLock readLock;
        ChatModuleImpl chatModuleImpl = readLock2;
        ReentrantReadWriteLock.ReadLock readLock2 = chatModuleImpl.getLock().readLock();
        readLock2.lock();
        try {
            Iterator iterator = chatModuleImpl.getChatObservers().iterator();
            while (iterator.hasNext()) {
                ((ChatObserver)iterator.next()).onChatStarted();
            }
            readLock = readLock2;
        }
        catch (Throwable throwable) {
            readLock2.unlock();
            throw throwable;
        }
        readLock.unlock();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void notifyChatEnded(@Nullable ChatException chatException) {
        ReentrantReadWriteLock.ReadLock readLock;
        ChatModuleImpl chatModuleImpl = readLock2;
        ReentrantReadWriteLock.ReadLock readLock2 = chatModuleImpl.getLock().readLock();
        readLock2.lock();
        try {
            for (ChatObserver chatObserver : chatModuleImpl.getChatObservers()) {
                if (chatException != null) {
                    chatObserver.onChatEndedWithError(chatException);
                    continue;
                }
                chatObserver.onChatEnded();
            }
            readLock = readLock2;
        }
        catch (Throwable throwable) {
            readLock2.unlock();
            throw throwable;
        }
        readLock.unlock();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addChatObserver(@NotNull ChatObserver chatObserver) {
        int n2;
        ReentrantReadWriteLock.ReadLock readLock;
        Serializable serializable;
        block13: {
            block12: {
                serializable = this.getLock();
                readLock = ((ReentrantReadWriteLock)serializable).readLock();
                n2 = ((ReentrantReadWriteLock)serializable).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)serializable).getReadHoldCount() : 0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    readLock.unlock();
                }
                serializable = ((ReentrantReadWriteLock)serializable).writeLock();
                ((ReentrantReadWriteLock.WriteLock)serializable).lock();
                if (!this.getChatObservers().contains(chatObserver)) break block12;
                int n3 = 0;
                while (true) {
                    if (n3 >= n2) {
                        ((ReentrantReadWriteLock.WriteLock)serializable).unlock();
                        return;
                    }
                    readLock.lock();
                    ++n3;
                }
            }
            ChatModuleImpl chatModuleImpl = this;
            ChatModuleImpl chatModuleImpl2 = chatModuleImpl;
            chatModuleImpl.getChatObservers().add(chatObserver);
            try {
                if (chatModuleImpl2.isChatStarted) {
                    chatObserver.onChatStarted();
                    break block13;
                }
                chatObserver.onChatEnded();
            }
            catch (Throwable throwable) {
                int n4 = 0;
                while (true) {
                    if (n4 >= n2) {
                        ((ReentrantReadWriteLock.WriteLock)serializable).unlock();
                        throw throwable;
                    }
                    readLock.lock();
                    ++n4;
                }
            }
        }
        int n5 = 0;
        while (true) {
            if (n5 >= n2) {
                ((ReentrantReadWriteLock.WriteLock)serializable).unlock();
                return;
            }
            readLock.lock();
            ++n5;
        }
    }

    @Override
    public void removeChatObserver(@NotNull ChatObserver chatObserver) {
        ReentrantReadWriteLock reentrantReadWriteLock = ((ChatModuleImpl)((Object)writeLock)).getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            readLock.unlock();
        }
        ChatModuleImpl chatModuleImpl = writeLock;
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            chatModuleImpl.getChatObservers().remove(chatObserver);
        }
        catch (Throwable throwable) {
            for (int i3 = 0; i3 < n2; ++i3) {
                readLock.lock();
            }
            writeLock.unlock();
            throw throwable;
        }
        for (int i4 = 0; i4 < n2; ++i4) {
            readLock.lock();
        }
        writeLock.unlock();
        return;
    }

    @Override
    public void removeAllChatObservers() {
        int n2;
        ReentrantReadWriteLock reentrantReadWriteLock = ((ChatModuleImpl)((Object)writeLock)).getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (n2 = 0; n2 < n3; ++n2) {
            readLock.unlock();
        }
        ChatModuleImpl chatModuleImpl = writeLock;
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            chatModuleImpl.getChatObservers().clear();
        }
        catch (Throwable throwable) {
            for (n2 = 0; n2 < n3; ++n2) {
                readLock.lock();
            }
            writeLock.unlock();
            throw throwable;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            readLock.lock();
        }
        writeLock.unlock();
        return;
    }

    @Override
    public void addChatObserver(@NotNull AppCompatActivity appCompatActivity, @NotNull ChatObserver chatObserver) {
        ChatModule.DefaultImpls.addChatObserver(this, appCompatActivity, chatObserver);
    }

    @Override
    @NotNull
    public String getName() {
        return ChatModule.DefaultImpls.getName(this);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/bandyer/android_sdk/chat/ChatModuleImpl$Companion;", "", "()V", "TAG", "", "bandyer-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

