/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.android_sdk.call;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentActivity;
import com.badoo.mobile.util.WeakHandler;
import com.bandyer.android_common.observer.BaseObserverCollection;
import com.bandyer.android_sdk.BandyerSDK;
import com.bandyer.android_sdk.ForegroundBackgroundOperationsDispatcher;
import com.bandyer.android_sdk.call.BandyerCallActivity;
import com.bandyer.android_sdk.call.CallException;
import com.bandyer.android_sdk.call.CallModule;
import com.bandyer.android_sdk.call.CallModuleImpl;
import com.bandyer.android_sdk.call.CallObserver;
import com.bandyer.android_sdk.call.CallUIObserver;
import com.bandyer.android_sdk.call.c;
import com.bandyer.android_sdk.call.d;
import com.bandyer.android_sdk.call.model.CallDirection;
import com.bandyer.android_sdk.call.model.CallDirectionKt;
import com.bandyer.android_sdk.call.model.CallInfo;
import com.bandyer.android_sdk.call.model.CallInfoImpl;
import com.bandyer.android_sdk.call.model.CallType;
import com.bandyer.android_sdk.call.model.CallTypeKt;
import com.bandyer.android_sdk.call.networking.model.IdentityVerification;
import com.bandyer.android_sdk.call.notification.CallForegroundService;
import com.bandyer.android_sdk.call.notification.internal.CallNotificationActionsReceiver;
import com.bandyer.android_sdk.client.BandyerSDKClient;
import com.bandyer.android_sdk.intent.call.BaseCallOptions;
import com.bandyer.android_sdk.intent.call.CallCapabilities;
import com.bandyer.android_sdk.intent.call.CallDisplayMode;
import com.bandyer.android_sdk.intent.call.CallImpl;
import com.bandyer.android_sdk.module.AuthenticationException;
import com.bandyer.android_sdk.module.BandyerModuleObserver;
import com.bandyer.android_sdk.module.BandyerModuleStatus;
import com.bandyer.android_sdk.module.BaseBandyerModule;
import com.bandyer.android_sdk.module.EndOfSupportException;
import com.bandyer.android_sdk.module.ModuleException;
import com.bandyer.android_sdk.notification.BandyerNotificator;
import com.bandyer.android_sdk.notification.BroadcastNotifierFactory;
import com.bandyer.android_sdk.screen_sharing.notification.ScreenShareForegroundService;
import com.bandyer.android_sdk.utils.BandyerSDKLogger;
import com.bandyer.android_sdk.utils.n;
import com.bandyer.android_sdk.utils.provider.UserDetails;
import com.bandyer.android_sdk.utils.x;
import com.bandyer.communication_center.call.Call;
import com.bandyer.communication_center.call.CallCreationException;
import com.bandyer.communication_center.call.CallOptions;
import com.bandyer.communication_center.call.CallUpgradeException;
import com.bandyer.communication_center.call.CustomEvent;
import com.bandyer.communication_center.call.IncomingCall;
import com.bandyer.communication_center.call.OnCallCreationObserver;
import com.bandyer.communication_center.call.OnCallEventObserver;
import com.bandyer.communication_center.call.participant.CallParticipant;
import com.bandyer.communication_center.call_client.CallClient;
import com.bandyer.communication_center.call_client.CallClientEndOfSupportException;
import com.bandyer.communication_center.call_client.CallClientException;
import com.bandyer.communication_center.call_client.CallClientStatus;
import com.bandyer.communication_center.call_client.OnCallClientObserver;
import com.bandyer.communication_center.call_client.OnIncomingCallObserver;
import com.bandyer.communication_center.call_client.OnNotificationObserver;
import com.bandyer.communication_center.call_client.User;
import com.bandyer.core_av.room.RoomToken;
import com.google.gson.Gson;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0002\r\u001c\b\u0000\u0018\u0000 s2\u00020\u00012\u00020\u0002:\u0002rsB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010/\u001a\u0002002\b\b\u0001\u00101\u001a\u00020\"H\u0016J\u0010\u00102\u001a\u0002002\u0006\u00101\u001a\u000203H\u0016J\b\u00104\u001a\u000200H\u0002J$\u00105\u001a\u0002002\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u0006072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;J\b\u0010<\u001a\u000200H\u0016J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J2\u0010A\u001a\u0002002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010B\u001a\u00020\u00062\f\u0010C\u001a\b\u0012\u0004\u0012\u0002000D2\f\u0010E\u001a\b\u0012\u0004\u0012\u0002000DJ\u0010\u0010F\u001a\u00020\u00142\u0006\u0010?\u001a\u00020@H\u0016J\u0016\u0010G\u001a\u0002002\u0006\u0010H\u001a\u00020\u00062\u0006\u0010:\u001a\u00020;J\b\u0010I\u001a\u000200H\u0002J\u001c\u0010J\u001a\u0002002\u0006\u0010K\u001a\u00020$2\n\b\u0002\u0010L\u001a\u0004\u0018\u00010MH\u0002J\u0010\u0010N\u001a\u0002002\u0006\u0010K\u001a\u00020OH\u0002J\u0016\u0010P\u001a\u0002002\u0006\u0010K\u001a\u00020O2\u0006\u0010Q\u001a\u00020RJ\u001e\u0010S\u001a\u0002002\u0006\u0010K\u001a\u00020O2\u0006\u0010Q\u001a\u00020R2\u0006\u0010T\u001a\u00020MJ\u0016\u0010U\u001a\u0002002\u0006\u0010K\u001a\u00020O2\u0006\u0010Q\u001a\u00020RJ\u0018\u0010V\u001a\u0002002\u0006\u0010W\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J\b\u0010X\u001a\u000200H\u0016J\b\u0010Y\u001a\u000200H\u0016J\b\u0010Z\u001a\u000200H\u0016J\u0010\u0010[\u001a\u0002002\u0006\u00101\u001a\u00020\"H\u0016J\u0010\u0010\\\u001a\u0002002\u0006\u00101\u001a\u000203H\u0016J\b\u0010]\u001a\u000200H\u0016J\u0018\u0010^\u001a\u0002002\u0006\u0010_\u001a\u00020\u00062\u0006\u0010`\u001a\u00020aH\u0016J\u0018\u0010b\u001a\u0002002\u0006\u0010_\u001a\u00020\u00062\u0006\u0010c\u001a\u00020\u0014H\u0016J\b\u0010d\u001a\u000200H\u0016J\b\u0010e\u001a\u000200H\u0016J\b\u0010f\u001a\u000200H\u0016J\u0018\u0010g\u001a\u0002002\u0006\u0010h\u001a\u00020$2\u0006\u0010K\u001a\u00020iH\u0002JD\u0010j\u001a\u0002002\u0006\u0010K\u001a\u00020$2\b\u0010k\u001a\u0004\u0018\u00010\u00062\u0006\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020o2\b\u0010p\u001a\u0004\u0018\u00010\u00062\u000e\u0010q\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u000107H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\u0019\u001a\b\u0018\u00010\u001aR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0016R\u0014\u0010\u001f\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0016R\u000e\u0010 \u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006t"}, d2={"Lcom/bandyer/android_sdk/call/CallModuleImpl;", "Lcom/bandyer/android_sdk/module/BaseBandyerModule;", "Lcom/bandyer/android_sdk/call/CallModule;", "context", "Landroid/content/Context;", "userAlias", "", "bandyerModuleObserver", "Lcom/bandyer/android_sdk/module/BandyerModuleObserver;", "(Landroid/content/Context;Ljava/lang/String;Lcom/bandyer/android_sdk/module/BandyerModuleObserver;)V", "callClientObserver", "Lcom/bandyer/communication_center/call_client/OnCallClientObserver;", "callEventObserver", "com/bandyer/android_sdk/call/CallModuleImpl$callEventObserver$1", "Lcom/bandyer/android_sdk/call/CallModuleImpl$callEventObserver$1;", "callObservers", "Lcom/bandyer/android_sdk/call/CallObservable;", "callUIObservers", "Lcom/bandyer/android_sdk/call/CallUIObservable;", "canBePaused", "", "getCanBePaused", "()Z", "canInit", "getCanInit", "creationObserver", "Lcom/bandyer/android_sdk/call/CallModuleImpl$CallModuleCreationObserver;", "incomingCallObserver", "com/bandyer/android_sdk/call/CallModuleImpl$incomingCallObserver$1", "Lcom/bandyer/android_sdk/call/CallModuleImpl$incomingCallObserver$1;", "isInCall", "isReady", "lifecyclePause", "notifier", "Lcom/bandyer/android_sdk/call/CallObserver;", "ongoingCall", "Lcom/bandyer/android_sdk/intent/call/CallImpl;", "getOngoingCall", "()Lcom/bandyer/android_sdk/intent/call/CallImpl;", "setOngoingCall", "(Lcom/bandyer/android_sdk/intent/call/CallImpl;)V", "reconnectionAttempts", "", "getReconnectionAttempts", "()I", "setReconnectionAttempts", "(I)V", "addCallObserver", "", "observer", "addCallUIObserver", "Lcom/bandyer/android_sdk/call/CallUIObserver;", "clean", "createCall", "users", "", "options", "Lcom/bandyer/communication_center/call/CallOptions;", "onCallCreationObserver", "Lcom/bandyer/communication_center/call/OnCallCreationObserver;", "destroy", "getFailureRecoveryStrategy", "Lcom/bandyer/android_sdk/exceptions/FailureRecoverStrategy;", "throwable", "", "handleNotification", "payload", "successCallback", "Lkotlin/Function0;", "errorCallback", "hasFailedWithThrowable", "joinCall", "joinUrl", "notifyCallCreated", "notifyCallEnded", "call", "callException", "Lcom/bandyer/android_sdk/call/CallException;", "notifyCallStarted", "Lcom/bandyer/android_sdk/intent/call/Call;", "notifyCallUIDestroyed", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "notifyCallUIError", "error", "notifyCallUIStarted", "onPreRecovery", "recoverStrategy", "reconnect", "removeAllCallObservers", "removeAllCallUIObservers", "removeCallObserver", "removeCallUIObserver", "resume", "setDisplayMode", "callId", "callDisplayMode", "Lcom/bandyer/android_sdk/intent/call/CallDisplayMode;", "setVerified", "verified", "startListening", "stop", "stopListening", "updateCall", "sdkCall", "Lcom/bandyer/communication_center/call/Call;", "updateCallInfo", "remoteId", "direction", "Lcom/bandyer/android_sdk/call/model/CallDirection;", "type", "Lcom/bandyer/android_sdk/call/model/CallType;", "caller", "callees", "CallModuleCreationObserver", "Companion", "bandyer-android-sdk_release"})
public final class CallModuleImpl
extends BaseBandyerModule
implements CallModule {
    @NotNull
    public static final String TAG = "Call Module";
    @NotNull
    public static final String USER_IDENTITY_VERIFICATION_EVENT = "call:user:verified";
    public static final Companion Companion = new Companion(null);
    private final c callObservers;
    private final d callUIObservers;
    private boolean lifecyclePause;
    @Nullable
    private CallImpl ongoingCall;
    private final OnCallClientObserver callClientObserver;
    private final callEventObserver.1 callEventObserver;
    private CallModuleCreationObserver creationObserver;
    private final incomingCallObserver.1 incomingCallObserver;
    private final CallObserver notifier;
    private int reconnectionAttempts;

    private final void notifyCallStarted(com.bandyer.android_sdk.intent.call.Call call) {
        this.callObservers.onCallStarted();
    }

    private final void notifyCallCreated() {
    }

    private final void updateCallInfo(CallImpl serializable, String string2, CallDirection callDirection, CallType callType, String object, List<String> object2) {
        CallInfoImpl callInfoImpl;
        UserDetails userDetails = object != null ? new UserDetails.Builder((String)object).build() : null;
        if (object2 != null) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
            object2 = object2.iterator();
            while (object2.hasNext()) {
                String string3 = (String)object2.next();
                object.add(new UserDetails.Builder(string3).build());
            }
        } else {
            object = null;
        }
        CallImpl callImpl = serializable;
        serializable = callInfoImpl;
        callInfoImpl = new CallInfoImpl(string2, callDirection, callType, userDetails, (List<UserDetails>)object);
        callImpl.setCallInfo((CallInfo)serializable);
    }

    private final void updateCall(CallImpl callImpl, Call call) {
        ArrayList<String> arrayList;
        Call call2 = call;
        String string2 = call2.getCallID();
        CallDirection callDirection = CallDirectionKt.toSDK(call2.getDirection());
        Object object = call2.getOptions();
        if (object == null || (object = object.getCallType()) == null) {
            object = com.bandyer.communication_center.call.CallType.AUDIO_VIDEO;
        }
        object = CallTypeKt.toSDK((com.bandyer.communication_center.call.CallType)object);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Call call3 = call;
        String string3 = call3.getParticipants().getCaller().getUser().getUserAlias();
        Object object2 = call3.getParticipants().getCallees();
        if (object2 != null) {
            ArrayList<String> arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
            object2 = object2.iterator();
            while (object2.hasNext()) {
                String string4 = ((CallParticipant)object2.next()).getUser().getUserAlias();
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                arrayList.add(string4);
            }
        } else {
            arrayList = null;
        }
        this.updateCallInfo(callImpl, string2, callDirection, (CallType)((Object)object), string3, arrayList);
        callImpl.setOngoingCall(call);
    }

    private final void notifyCallEnded(CallImpl callImpl, CallException callException) {
        if (callException != null) {
            this.callObservers.onCallEndedWithError(callException);
        } else {
            this.callObservers.onCallEnded();
        }
        callImpl = callImpl.getOngoingCall();
        if (callImpl != null) {
            callImpl.removeEventObserver(this.callEventObserver);
        }
        CallModuleImpl callModuleImpl = this;
        callModuleImpl.setOngoingCall(null);
        callModuleImpl.clean();
    }

    static /* synthetic */ void notifyCallEnded$default(CallModuleImpl callModuleImpl, CallImpl callImpl, CallException callException, int n2, Object object) {
        if ((n2 & 2) != 0) {
            callException = null;
        }
        callModuleImpl.notifyCallEnded(callImpl, callException);
    }

    private final void clean() {
        ScreenShareForegroundService.o.a();
        CallForegroundService.a.a(CallForegroundService.w, ((BaseBandyerModule)object).getContext(), null, 2, null);
        Object object = BandyerSDKClient.Companion.getInstance();
        if (object != null) {
            object = (BandyerSDKClient)object;
            if (!ForegroundBackgroundOperationsDispatcher.b.a()) {
                ((BandyerSDKClient)object).pause();
            }
            return;
        }
        throw new TypeCastException("null cannot be cast to non-null type com.bandyer.android_sdk.client.BandyerSDKClient");
    }

    public CallModuleImpl(@NotNull Context object, @NotNull String string2, @NotNull BandyerModuleObserver object2) {
        block7: {
            block11: {
                BroadcastNotifierFactory.AbstractBroadcastNotifier abstractBroadcastNotifier;
                block10: {
                    BaseObserverCollection baseObserverCollection;
                    ExecutorService executorService;
                    block8: {
                        block9: {
                            BaseObserverCollection baseObserverCollection2;
                            WeakHandler weakHandler;
                            BaseObserverCollection baseObserverCollection3;
                            block6: {
                                BaseObserverCollection baseObserverCollection4;
                                block4: {
                                    block5: {
                                        BaseObserverCollection baseObserverCollection5;
                                        WeakHandler weakHandler2;
                                        super((Context)object, string2, (BandyerModuleObserver)object2);
                                        object2 = weakHandler2;
                                        weakHandler2 = new WeakHandler(Looper.getMainLooper());
                                        executorService = Executors.newSingleThreadExecutor();
                                        if (executorService == null) break block4;
                                        baseObserverCollection3 = baseObserverCollection5;
                                        baseObserverCollection5 = new BaseObserverCollection((WeakHandler)object2, executorService);
                                        object2 = Proxy.newProxyInstance(c.class.getClassLoader(), new Class[]{c.class}, (InvocationHandler)baseObserverCollection3);
                                        if (object2 == null) break block5;
                                        object2 = (c)object2;
                                        break block6;
                                    }
                                    throw new TypeCastException("null cannot be cast to non-null type com.bandyer.android_sdk.call.CallObservable");
                                }
                                executorService = baseObserverCollection4;
                                baseObserverCollection4 = new BaseObserverCollection((WeakHandler)object2, null, 2, null);
                                object2 = Proxy.newProxyInstance(c.class.getClassLoader(), new Class[]{c.class}, (InvocationHandler)((Object)executorService));
                                if (object2 == null) break block7;
                                object2 = (c)object2;
                            }
                            this.callObservers = object2;
                            object2 = weakHandler;
                            weakHandler = new WeakHandler(Looper.getMainLooper());
                            executorService = Executors.newSingleThreadExecutor();
                            if (executorService == null) break block8;
                            baseObserverCollection3 = baseObserverCollection2;
                            baseObserverCollection2 = new BaseObserverCollection((WeakHandler)object2, executorService);
                            object2 = Proxy.newProxyInstance(d.class.getClassLoader(), new Class[]{d.class}, (InvocationHandler)baseObserverCollection3);
                            if (object2 == null) break block9;
                            object2 = (d)object2;
                            break block10;
                        }
                        throw new TypeCastException("null cannot be cast to non-null type com.bandyer.android_sdk.call.CallUIObservable");
                    }
                    executorService = baseObserverCollection;
                    baseObserverCollection = new BaseObserverCollection((WeakHandler)object2, null, 2, null);
                    object2 = Proxy.newProxyInstance(d.class.getClassLoader(), new Class[]{d.class}, (InvocationHandler)((Object)executorService));
                    if (object2 == null) break block11;
                    object2 = (d)object2;
                }
                CallModuleImpl callModuleImpl = this;
                callModuleImpl.callUIObservers = object2;
                callModuleImpl.callClientObserver = new OnCallClientObserver(this){
                    final /* synthetic */ CallModuleImpl this$0;
                    {
                        this.this$0 = callModuleImpl;
                    }

                    public void onCallClientDestroyed() {
                        CallModuleImpl.access$statusChanged(this.this$0, BandyerModuleStatus.DESTROYED);
                    }

                    public void onCallClientFailed(@NotNull CallClientException object) {
                        if (object instanceof CallClientEndOfSupportException) {
                            CallClientException callClientException = object;
                            CallModuleImpl callModuleImpl = callModuleImpl.this$0;
                            String string2 = callClientException.getMessage();
                            if (string2 == null) {
                                Intrinsics.throwNpe();
                            }
                            object = new EndOfSupportException(string2);
                            CallModuleImpl.access$failed(callModuleImpl, (Throwable)object);
                        } else {
                            String string3 = object.getMessage();
                            if (string3 != null && StringsKt.contains$default((CharSequence)string3, (CharSequence)" Authentication Error", (boolean)false, (int)2, null)) {
                                CallModuleImpl.access$failed(callModuleImpl.this$0, new AuthenticationException("Authentication failed!"));
                            } else {
                                CallModuleImpl.access$failed(callModuleImpl.this$0, new ModuleException(object.getLocalizedMessage()));
                            }
                        }
                    }

                    public void onCallClientInitialized(@NotNull User user) {
                        callClientObserver.1 v0 = this;
                        CallModuleImpl.access$statusChanged(v0.this$0, BandyerModuleStatus.CONNECTED);
                        CallModuleImpl.access$moduleReady(v0.this$0);
                    }

                    public void onCallClientReconnecting() {
                        CallModuleImpl.access$statusChanged(this.this$0, BandyerModuleStatus.RECONNECTING);
                    }

                    public void onCallClientResumed() {
                        callClientObserver.1 v0 = this;
                        CallModuleImpl.access$statusChanged(v0.this$0, BandyerModuleStatus.CONNECTED);
                        CallModuleImpl.access$moduleReady(v0.this$0);
                    }

                    public void onCallClientStopped() {
                        CallModuleImpl.access$paused(this.this$0);
                    }
                };
                callModuleImpl.callEventObserver = new OnCallEventObserver(this){
                    final /* synthetic */ CallModuleImpl this$0;
                    {
                        this.this$0 = callModuleImpl;
                    }

                    public void onCallEnded(@NotNull Call call, @NotNull Call.EndReason object) {
                        object = this.this$0.getOngoingCall();
                        if (object != null) {
                            if (!Intrinsics.areEqual((Object)((CallImpl)object).getOngoingCall(), (Object)call)) {
                                object = null;
                            }
                            if (object != null) {
                                CallModuleImpl.notifyCallEnded$default(this.this$0, (CallImpl)object, null, 2, null);
                            }
                        }
                    }

                    public void onCallError(@NotNull Call object, @NotNull com.bandyer.communication_center.call.CallException object2) {
                        if (object2 instanceof CallUpgradeException) {
                            return;
                        }
                        CallImpl callImpl = callModuleImpl.this$0.getOngoingCall();
                        if (callImpl != null) {
                            if (!Intrinsics.areEqual((Object)callImpl.getOngoingCall(), (Object)object)) {
                                callImpl = null;
                            }
                            if (callImpl != null) {
                                CallModuleImpl callModuleImpl = callModuleImpl.this$0;
                                if ((object2 = object2.getMessage()) == null) {
                                    object2 = "Call finished with unknown error.";
                                }
                                object = new CallException((String)object2);
                                CallModuleImpl.access$notifyCallEnded(callModuleImpl, callImpl, (CallException)object);
                            }
                        }
                    }

                    public void onCallStarted(@NotNull Call call, @NotNull RoomToken object) {
                        object = this.this$0.getOngoingCall();
                        if (object != null) {
                            if (!Intrinsics.areEqual((Object)((CallImpl)object).getOngoingCall(), (Object)call)) {
                                object = null;
                            }
                            if (object != null) {
                                CallModuleImpl.access$notifyCallStarted(this.this$0, (com.bandyer.android_sdk.intent.call.Call)object);
                            }
                        }
                    }

                    public void onCallStatusChanged(@NotNull Call call, @NotNull Call.Status status) {
                    }

                    public void onCallUpgraded() {
                    }
                };
                callModuleImpl.incomingCallObserver = new OnIncomingCallObserver(this, (Context)object, string2){
                    final /* synthetic */ CallModuleImpl this$0;
                    final /* synthetic */ Context $context;
                    final /* synthetic */ String $userAlias;
                    {
                        this.this$0 = callModuleImpl;
                        this.$context = context;
                        this.$userAlias = string2;
                    }

                    public void onIncomingCall(@NotNull IncomingCall incomingCall) {
                        Object object;
                        Object object2 = CallModuleImpl.access$getBandyerSdk$p(this_.this$0).getLogger$bandyer_android_sdk_release();
                        if (object2 != null) {
                            object2.info("Call Module", "Incoming call...");
                        }
                        if ((object2 = CallModuleImpl.access$getBandyerSdk$p(this_.this$0).getLogger$bandyer_android_sdk_release()) != null) {
                            object2.debug("Call Module", "Incoming call = " + incomingCall);
                        }
                        if ((object = ((CallModuleImpl)(object2 = this_.this$0)).getOngoingCall()) == null) {
                            CallInfoImpl callInfoImpl;
                            CallImpl callImpl;
                            object = callImpl;
                            CallInfoImpl callInfoImpl2 = callInfoImpl;
                            callInfoImpl = new CallInfoImpl();
                            callImpl = new CallImpl((Call)incomingCall, callInfoImpl2);
                        }
                        ((CallModuleImpl)object2).setOngoingCall((CallImpl)object);
                        object2 = this_.this$0;
                        object = ((CallModuleImpl)object2).getOngoingCall();
                        if (object == null) {
                            Intrinsics.throwNpe();
                        }
                        incomingCallObserver.1 v2 = this_;
                        CallModuleImpl.access$updateCall((CallModuleImpl)object2, (CallImpl)object, (Call)incomingCall);
                        CallModuleImpl.access$notifyCallCreated(v2.this$0);
                        incomingCall.addEventObserver((OnCallEventObserver)CallModuleImpl.access$getCallEventObserver$p(v2.this$0));
                        incomingCallObserver.1 v3 = this_;
                        incomingCallObserver.1 this_ = v3.$context;
                        object2 = CallModuleImpl.access$getBandyerSdk$p(v3.this$0);
                        object = v3.$userAlias;
                        BandyerNotificator.INSTANCE.notifyCallListeners((Context)this_, (BandyerSDK)object2, (String)object, (Call)incomingCall);
                    }
                };
                object2 = abstractBroadcastNotifier;
                abstractBroadcastNotifier = new BroadcastNotifierFactory.AbstractBroadcastNotifier((Context)object, "com.bandyer.android_sdk.CALL_EVENT_ACTION");
                object = Proxy.newProxyInstance(CallObserver.class.getClassLoader(), new Class[]{CallObserver.class}, (InvocationHandler)object2);
                if (object != null) {
                    CallModuleImpl callModuleImpl2 = this;
                    callModuleImpl2.notifier = (CallObserver)object;
                    CallClient._.getInstance().addStatusObserver(this.callClientObserver);
                    callModuleImpl2.addCallObserver(callModuleImpl2.notifier);
                    CallClient._.getInstance().init(string2);
                    callModuleImpl2.statusChanged(BandyerModuleStatus.CONNECTING);
                    return;
                }
                throw new TypeCastException("null cannot be cast to non-null type com.bandyer.android_sdk.call.CallObserver");
            }
            throw new TypeCastException("null cannot be cast to non-null type com.bandyer.android_sdk.call.CallUIObservable");
        }
        throw new TypeCastException("null cannot be cast to non-null type com.bandyer.android_sdk.call.CallObservable");
    }

    public static final /* synthetic */ BandyerSDK access$getBandyerSdk$p(CallModuleImpl callModuleImpl) {
        return callModuleImpl.getBandyerSdk();
    }

    public static final /* synthetic */ c access$getCallObservers$p(CallModuleImpl callModuleImpl) {
        return callModuleImpl.callObservers;
    }

    public static final /* synthetic */ d access$getCallUIObservers$p(CallModuleImpl callModuleImpl) {
        return callModuleImpl.callUIObservers;
    }

    public static final /* synthetic */ void access$statusChanged(CallModuleImpl callModuleImpl, BandyerModuleStatus bandyerModuleStatus) {
        callModuleImpl.statusChanged(bandyerModuleStatus);
    }

    public static final /* synthetic */ void access$failed(CallModuleImpl callModuleImpl, Throwable throwable) {
        callModuleImpl.failed(throwable);
    }

    public static final /* synthetic */ void access$moduleReady(CallModuleImpl callModuleImpl) {
        callModuleImpl.moduleReady();
    }

    public static final /* synthetic */ void access$paused(CallModuleImpl callModuleImpl) {
        callModuleImpl.paused();
    }

    public static final /* synthetic */ void access$notifyCallStarted(CallModuleImpl callModuleImpl, com.bandyer.android_sdk.intent.call.Call call) {
        callModuleImpl.notifyCallStarted(call);
    }

    @Override
    public void setVerified(@NotNull String string2, boolean bl) {
        Object object = ((CallModuleImpl)object2).getOngoingCall();
        if (Intrinsics.areEqual(object != null && (object = ((CallImpl)object).getCallInfo()) != null ? object.getCallId() : null, (Object)string2) ^ true) {
            return;
        }
        string2 = BandyerSDKClient.Companion.getInstance().getMyAlias();
        if (string2 != null) {
            object = BandyerSDK.Companion.getInstance();
            if (object != null) {
                CallModuleImpl callModuleImpl = object2;
                Object object2 = ((BandyerSDK)object).getGson();
                object = callModuleImpl.getOngoingCall();
                if (object != null && (object = ((CallImpl)object).getOngoingCall()) != null) {
                    IdentityVerification identityVerification;
                    CustomEvent customEvent;
                    Object object3 = object;
                    object = customEvent;
                    CallModuleImpl callModuleImpl2 = object2;
                    object2 = identityVerification;
                    identityVerification = new IdentityVerification(string2, bl);
                    customEvent = new CustomEvent(USER_IDENTITY_VERIFICATION_EVENT, (Object)n.a((Gson)callModuleImpl2, object2));
                    object3.sendCustomEvent((CustomEvent)object);
                }
                return;
            }
            throw new TypeCastException("null cannot be cast to non-null type com.bandyer.android_sdk.BandyerSDK");
        }
    }

    @Override
    public void setDisplayMode(@NotNull String object, @NotNull CallDisplayMode object2) {
        Intent intent;
        Serializable serializable = this.getOngoingCall();
        if (Intrinsics.areEqual(serializable != null && (serializable = ((CallImpl)serializable).getCallInfo()) != null ? serializable.getCallId() : null, (Object)object) ^ true) {
            return;
        }
        object = BandyerCallActivity.V0.a();
        if (object != null) {
            ((BandyerCallActivity)object).a((CallDisplayMode)((Object)object2));
            return;
        }
        Object object3 = object = intent;
        object3(this.getContext(), CallNotificationActionsReceiver.class);
        object3.setAction("com.bandyer.android_sdk.call.notification.ACTION_OPEN");
        intent.setPackage(this.getContext().getPackageName());
        object2 = this.getOngoingCall();
        if (object2 != null && (object2 = ((CallImpl)object2).getCallCapabilities()) != null && (object2 = ((CallCapabilities)object2).get_bundle()) != null) {
            object.putExtras((Bundle)object2);
        }
        if ((object2 = this.getOngoingCall()) != null && (object2 = ((CallImpl)object2).getCallOptions()) != null && (object2 = ((BaseCallOptions)object2).get_bundle$bandyer_android_sdk_release()) != null) {
            object.putExtras((Bundle)object2);
        }
        this.getContext().sendBroadcast((Intent)object, null);
    }

    public final boolean getCanBePaused() {
        return CallClient._.getInstance().getOngoingCall() == null || ((this = CallClient._.getInstance().getOngoingCall()) != null ? this.getStatus() : null) == Call.Status.ENDED || ((this = CallClient._.getInstance().getOngoingCall()) != null ? this.getStatus() : null) == Call.Status.FAILED;
    }

    @Override
    public boolean isInCall() {
        return this.getOngoingCall() != null;
    }

    @Override
    @Nullable
    public CallImpl getOngoingCall() {
        return this.ongoingCall;
    }

    public void setOngoingCall(@Nullable CallImpl callImpl) {
        this.ongoingCall = callImpl;
    }

    @Override
    public boolean isReady() {
        return this.getStatus() == BandyerModuleStatus.CONNECTED || this.getStatus() == BandyerModuleStatus.READY;
    }

    @Override
    public boolean getCanInit() {
        return CallClient._.getInstance().getStatus() == CallClientStatus.DESTROYED;
    }

    @Override
    public void reconnect() {
        if (this.getStatus() == BandyerModuleStatus.FAILED) {
            return;
        }
        CallModuleImpl callModuleImpl = this;
        callModuleImpl.setReconnectionAttempts(callModuleImpl.getReconnectionAttempts() + 1);
        CallClient._.getInstance().resume();
    }

    @Override
    public int getReconnectionAttempts() {
        return this.reconnectionAttempts;
    }

    public void setReconnectionAttempts(int n2) {
        this.reconnectionAttempts = n2;
    }

    public final void handleNotification(@NotNull Context object, @NotNull String string2, @NotNull Function0<Unit> function0, @NotNull Function0<Unit> function02) {
        OnNotificationObserver onNotificationObserver;
        if (CallClient._.getInstance().getStatus() != CallClientStatus.RUNNING) {
            if ((this = ((BaseBandyerModule)this).getBandyerSdk().getLogger$bandyer_android_sdk_release()) != null) {
                ((BandyerSDKLogger)((Object)this)).error(TAG, "handleNotification error: You must have the BandyerSDKClient running!");
            }
            function02.invoke();
            return;
        }
        if (ForegroundBackgroundOperationsDispatcher.b.a() && CallClient._.getInstance().getOngoingCall() != null) {
            if ((this = ((BaseBandyerModule)this).getBandyerSdk().getLogger$bandyer_android_sdk_release()) != null) {
                ((BandyerSDKLogger)((Object)this)).warn(TAG, "handleNotification error: You should not handle a notification while in foreground and running!");
            }
            function02.invoke();
            return;
        }
        object = onNotificationObserver;
        onNotificationObserver = new OnNotificationObserver((CallModuleImpl)this, function0, function02){
            final /* synthetic */ CallModuleImpl this$0;
            final /* synthetic */ Function0 $successCallback;
            final /* synthetic */ Function0 $errorCallback;
            {
                this.this$0 = callModuleImpl;
                this.$successCallback = function0;
                this.$errorCallback = function02;
            }

            public void onSuccess(@NotNull IncomingCall incomingCall) {
                BandyerSDKLogger bandyerSDKLogger = CallModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release();
                if (bandyerSDKLogger != null) {
                    bandyerSDKLogger.info("Call Module", "Handling notification payload...");
                }
                if ((bandyerSDKLogger = CallModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release()) != null) {
                    bandyerSDKLogger.debug("Call Module", "Notification handle payload success: " + incomingCall);
                }
                this.$successCallback.invoke();
            }

            public void onError(@NotNull String string2) {
                BandyerSDKLogger bandyerSDKLogger = CallModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release();
                if (bandyerSDKLogger != null) {
                    bandyerSDKLogger.error("Call Module", "Notification handle payload error: " + string2);
                }
                this.$errorCallback.invoke();
            }
        };
        CallClient._.getInstance().handleNotification(string2, (OnNotificationObserver)object);
    }

    public final void createCall(@NotNull List<String> list, @NotNull CallOptions callOptions, @NotNull OnCallCreationObserver object) {
        WeakReference<OnCallCreationObserver> weakReference;
        Object object2 = weakReference;
        weakReference = new WeakReference<OnCallCreationObserver>((OnCallCreationObserver)object);
        ((CallModuleImpl)((Object)string2)).creationObserver = (CallModuleImpl)((Object)string2).new CallModuleCreationObserver((WeakReference<OnCallCreationObserver>)object2);
        object = CallClient._.getInstance();
        object2 = ((CallModuleImpl)((Object)string2)).creationObserver;
        if (object2 == null) {
            Intrinsics.throwNpe();
        }
        object.call(list, callOptions, (OnCallCreationObserver)object2);
        object = ((CallModuleImpl)((Object)string2)).getOngoingCall();
        if (object == null) {
            CallInfoImpl callInfoImpl;
            CallImpl callImpl;
            object = callImpl;
            object2 = callInfoImpl;
            callInfoImpl = new CallInfoImpl();
            callImpl = new CallImpl(null, (CallInfo)object2);
        }
        CallModuleImpl callModuleImpl = string2;
        callModuleImpl.setOngoingCall((CallImpl)object);
        object = callModuleImpl.getOngoingCall();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        CallOptions callOptions2 = callOptions;
        callOptions = null;
        object2 = CallDirection.OUTGOING;
        Object object3 = callOptions2.getCallType();
        if (object3 == null) {
            Intrinsics.throwNpe();
        }
        if ((object3 = CallTypeKt.toSDK(object3)) == null) {
            Intrinsics.throwNpe();
        }
        CallModuleImpl callModuleImpl2 = string2;
        String string2 = callModuleImpl2.getUserAlias();
        callModuleImpl2.updateCallInfo((CallImpl)object, (String)callOptions, (CallDirection)((Object)object2), (CallType)((Object)object3), string2, list);
    }

    public final void joinCall(@NotNull String object, @NotNull OnCallCreationObserver object2) {
        WeakReference<OnCallCreationObserver> weakReference;
        Object object3 = weakReference;
        weakReference = new WeakReference<OnCallCreationObserver>((OnCallCreationObserver)object2);
        this.creationObserver = new CallModuleCreationObserver((WeakReference<OnCallCreationObserver>)object3);
        object2 = CallClient._.getInstance();
        object3 = this.creationObserver;
        if (object3 == null) {
            Intrinsics.throwNpe();
        }
        object2.join((String)object, (OnCallCreationObserver)object3);
        object = this.getOngoingCall();
        if (object == null) {
            CallInfoImpl callInfoImpl;
            CallImpl callImpl;
            object = callImpl;
            object2 = callInfoImpl;
            callInfoImpl = new CallInfoImpl();
            callImpl = new CallImpl(null, (CallInfo)object2);
        }
        CallModuleImpl callModuleImpl = this;
        callModuleImpl.setOngoingCall((CallImpl)object);
        callModuleImpl.notifyCallCreated();
    }

    @Override
    public void stop() {
        this.lifecyclePause = true;
        if (this.getCanBePaused()) {
            CallClient._.getInstance().stop();
        }
        this.removeAllObservers();
    }

    @Override
    public void resume() {
        this.statusChanged(BandyerModuleStatus.CONNECTING);
        CallClient._.getInstance().resume();
    }

    @Override
    public void destroy() {
        Object object = CallClient._.getInstance().getOngoingCall();
        if (object != null) {
            object.hangUp(Call.EndReason.HANGUP);
        }
        if ((object = BandyerCallActivity.V0.a()) != null) {
            object.finish();
        }
        CallClient._.getInstance().destroy();
        this.removeAllObservers();
    }

    @Override
    public void startListening() {
        CallClient._.getInstance().addIncomingCallObserver((OnIncomingCallObserver)this.incomingCallObserver);
    }

    @Override
    public void stopListening() {
        CallClient._.getInstance().removeIncomingCallObserver((OnIncomingCallObserver)this.incomingCallObserver);
        this.removeAllObservers();
    }

    public final void notifyCallUIStarted(@NotNull com.bandyer.android_sdk.intent.call.Call call, @NotNull AppCompatActivity appCompatActivity) {
        WeakReference<AppCompatActivity> weakReference;
        WeakReference<AppCompatActivity> weakReference2 = weakReference;
        weakReference = new WeakReference<AppCompatActivity>(appCompatActivity);
        ((CallModuleImpl)((Object)weakReference2)).callUIObservers.onActivityStarted(call, weakReference2);
    }

    public final void notifyCallUIDestroyed(@NotNull com.bandyer.android_sdk.intent.call.Call object, @NotNull AppCompatActivity appCompatActivity) {
        WeakReference<AppCompatActivity> weakReference;
        CallModuleImpl callModuleImpl = this;
        com.bandyer.android_sdk.intent.call.Call call = object;
        object = weakReference;
        weakReference = new WeakReference<AppCompatActivity>(appCompatActivity);
        callModuleImpl.callUIObservers.onActivityDestroyed(call, (WeakReference<AppCompatActivity>)object);
        if (callModuleImpl.getOngoingCall() != null) {
            this.clean();
        }
    }

    public final void notifyCallUIError(@NotNull com.bandyer.android_sdk.intent.call.Call object, @NotNull AppCompatActivity appCompatActivity, @NotNull CallException callException) {
        WeakReference<AppCompatActivity> weakReference;
        CallModuleImpl callModuleImpl = this;
        com.bandyer.android_sdk.intent.call.Call call = object;
        object = weakReference;
        weakReference = new WeakReference<AppCompatActivity>(appCompatActivity);
        callModuleImpl.callUIObservers.onActivityError(call, (WeakReference<AppCompatActivity>)object, callException);
        if (callModuleImpl.getOngoingCall() != null) {
            this.clean();
        }
    }

    @Override
    public void addCallObserver(@NonNull @NotNull CallObserver callObserver) {
        Function1<Boolean, Unit> function1;
        Function1<Boolean, Unit> function12 = function1;
        function1 = new Function1<Boolean, Unit>(this, callObserver){
            final /* synthetic */ CallModuleImpl this$0;
            final /* synthetic */ CallObserver $observer;
            {
                this.this$0 = callModuleImpl;
                this.$observer = callObserver;
                super(1);
            }

            public final void invoke(boolean bl) {
                if (!bl) {
                    CallModuleImpl.access$getCallObservers$p(this.this$0).add(this.$observer);
                }
            }
        };
        this.callObservers.contains(callObserver, (Function1)function12);
    }

    @Override
    public void removeCallObserver(@NotNull CallObserver callObserver) {
        this.callObservers.remove(callObserver);
    }

    @Override
    public void removeAllCallObservers() {
        this.callObservers.clear();
    }

    @Override
    public void addCallUIObserver(@NotNull CallUIObserver callUIObserver) {
        Function1<Boolean, Unit> function1;
        Function1<Boolean, Unit> function12 = function1;
        function1 = new Function1<Boolean, Unit>(this, callUIObserver){
            final /* synthetic */ CallModuleImpl this$0;
            final /* synthetic */ CallUIObserver $observer;
            {
                this.this$0 = callModuleImpl;
                this.$observer = callUIObserver;
                super(1);
            }

            public final void invoke(boolean bl) {
                if (!bl) {
                    CallModuleImpl.access$getCallUIObservers$p(this.this$0).add(this.$observer);
                }
            }
        };
        this.callUIObservers.contains(callUIObserver, (Function1)function12);
    }

    @Override
    public void removeCallUIObserver(@NotNull CallUIObserver callUIObserver) {
        this.callUIObservers.remove(callUIObserver);
    }

    @Override
    public void removeAllCallUIObservers() {
        this.callUIObservers.clear();
    }

    @Override
    public boolean hasFailedWithThrowable(@NotNull Throwable throwable) {
        return x.e(throwable);
    }

    @Override
    @NotNull
    public com.bandyer.android_sdk.b.c getFailureRecoveryStrategy(@NotNull Throwable throwable) {
        return com.bandyer.android_sdk.b.c.a;
    }

    @Override
    public void onPreRecovery(@NotNull com.bandyer.android_sdk.b.c c2, @NotNull Throwable throwable) {
        CallModuleImpl callModuleImpl = this;
        callModuleImpl.getBandyerModuleObserver().onModuleFailed(this, throwable);
        callModuleImpl.destroy();
    }

    @Override
    public void setVerified(@NotNull com.bandyer.android_sdk.intent.call.Call call, boolean bl) {
        CallModule.DefaultImpls.setVerified(this, call, bl);
    }

    @Override
    public void setDisplayMode(@NotNull com.bandyer.android_sdk.intent.call.Call call, @NotNull CallDisplayMode callDisplayMode) {
        CallModule.DefaultImpls.setDisplayMode(this, call, callDisplayMode);
    }

    @Override
    @Deprecated(message="This method is deprecated since v1.5.0 and it will be removed in upcoming releases.\nIf you are already using an AppCompatActivity the removal of this method will not change anything for you, because the AppCompatActivity is a FragmentActivity.", replaceWith=@ReplaceWith(imports={}, expression="addCallObserver(activity, observer)"))
    public void addCallObserver(@NotNull AppCompatActivity appCompatActivity, @NotNull CallObserver callObserver) {
        CallModule.DefaultImpls.addCallObserver((CallModule)this, appCompatActivity, callObserver);
    }

    @Override
    public void addCallObserver(@NotNull FragmentActivity fragmentActivity, @NotNull CallObserver callObserver) {
        CallModule.DefaultImpls.addCallObserver((CallModule)this, fragmentActivity, callObserver);
    }

    @Override
    public void addCallUIObserver(@NotNull FragmentActivity fragmentActivity, @NotNull CallUIObserver callUIObserver) {
        CallModule.DefaultImpls.addCallUIObserver(this, fragmentActivity, callUIObserver);
    }

    @Override
    @NotNull
    public String getName() {
        return CallModule.DefaultImpls.getName(this);
    }

    @Override
    public void removeAllObservers() {
        CallModule.DefaultImpls.removeAllObservers(this);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/bandyer/android_sdk/call/CallModuleImpl$CallModuleCreationObserver;", "Lcom/bandyer/communication_center/call/OnCallCreationObserver;", "onCallCreationObserver", "Ljava/lang/ref/WeakReference;", "(Lcom/bandyer/android_sdk/call/CallModuleImpl;Ljava/lang/ref/WeakReference;)V", "onCallCreationError", "", "reason", "Lcom/bandyer/communication_center/call/CallCreationException;", "onCallCreationSuccess", "call", "Lcom/bandyer/communication_center/call/Call;", "bandyer-android-sdk_release"})
    public final class CallModuleCreationObserver
    implements OnCallCreationObserver {
        private final WeakReference<OnCallCreationObserver> onCallCreationObserver;

        public CallModuleCreationObserver(WeakReference<OnCallCreationObserver> weakReference) {
            this.onCallCreationObserver = weakReference;
        }

        public void onCallCreationSuccess(@NotNull Call call) {
            CallModuleImpl callModuleImpl = CallModuleImpl.this;
            CallImpl callImpl = callModuleImpl.getOngoingCall();
            if (callImpl == null) {
                CallInfoImpl callInfoImpl;
                CallImpl callImpl2;
                callImpl = callImpl2;
                CallInfoImpl callInfoImpl2 = callInfoImpl;
                callInfoImpl = new CallInfoImpl();
                callImpl2 = new CallImpl(call, callInfoImpl2);
            }
            callModuleImpl.setOngoingCall(callImpl);
            callModuleImpl = CallModuleImpl.this;
            callImpl = callModuleImpl.getOngoingCall();
            if (callImpl == null) {
                Intrinsics.throwNpe();
            }
            callModuleImpl.updateCall(callImpl, call);
            callModuleImpl = (OnCallCreationObserver)this.onCallCreationObserver.get();
            if (callModuleImpl != null) {
                callModuleImpl.onCallCreationSuccess(call);
            }
            call.addEventObserver((OnCallEventObserver)CallModuleImpl.this.callEventObserver);
            CallModuleImpl.this.notifyCallCreated();
            if (BandyerCallActivity.V0.a() == null) {
                call.hangUp(Call.EndReason.HANGUP);
                return;
            }
        }

        public void onCallCreationError(@NotNull CallCreationException object) {
            Object object2 = (OnCallCreationObserver)((CallModuleCreationObserver)((Object)callModuleImpl)).onCallCreationObserver.get();
            if (object2 != null) {
                object2.onCallCreationError(object);
            }
            if (((CallModuleCreationObserver)((Object)callModuleImpl)).CallModuleImpl.this.getOngoingCall() != null) {
                CallModuleImpl callModuleImpl = ((CallModuleCreationObserver)((Object)callModuleImpl)).CallModuleImpl.this;
                object2 = callModuleImpl.getOngoingCall();
                if (object2 == null) {
                    Intrinsics.throwNpe();
                }
                CallCreationException callCreationException = object;
                String string2 = callCreationException.getMessage();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                object = new CallException(string2);
                callModuleImpl.notifyCallEnded((CallImpl)object2, (CallException)object);
                return;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/bandyer/android_sdk/call/CallModuleImpl$Companion;", "", "()V", "TAG", "", "USER_IDENTITY_VERIFICATION_EVENT", "bandyer-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

