/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.android_sdk.intent.call;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import com.bandyer.android_sdk.ForegroundBackgroundOperationsDispatcher;
import com.bandyer.android_sdk.call.model.CallInfo;
import com.bandyer.android_sdk.call.notification.CallNotificationListener;
import com.bandyer.android_sdk.call.notification.CallNotificationStyle;
import com.bandyer.android_sdk.call.notification.CallNotificationType;
import com.bandyer.android_sdk.call.notification.internal.c;
import com.bandyer.android_sdk.client.BandyerSDKClient;
import com.bandyer.android_sdk.d.a;
import com.bandyer.android_sdk.intent.BandyerBaseIntentOptions;
import com.bandyer.android_sdk.intent.BandyerIntent;
import com.bandyer.android_sdk.intent.call.CallCapabilities;
import com.bandyer.android_sdk.intent.call.CallImpl;
import com.bandyer.android_sdk.intent.call.CallOptions;
import com.bandyer.android_sdk.intent.call.IncomingCall;
import com.bandyer.android_sdk.intent.call.IncomingCallIntentOptions;
import com.bandyer.android_sdk.intent.call.IncomingCallOptions;
import com.bandyer.android_sdk.utils.provider.UserDetails;
import com.bandyer.communication_center.call.Call;
import com.bandyer.communication_center.call_client.CallClient;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B)\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/bandyer/android_sdk/intent/call/IncomingCallImpl;", "Lcom/bandyer/android_sdk/intent/call/CallImpl;", "Lcom/bandyer/android_sdk/intent/call/IncomingCall;", "callInfo", "Lcom/bandyer/android_sdk/call/model/CallInfo;", "bandyerIntent", "Lcom/bandyer/android_sdk/intent/BandyerIntent;", "title", "", "callNotificationListener", "Lcom/bandyer/android_sdk/call/notification/CallNotificationListener;", "(Lcom/bandyer/android_sdk/call/model/CallInfo;Lcom/bandyer/android_sdk/intent/BandyerIntent;Ljava/lang/String;Lcom/bandyer/android_sdk/call/notification/CallNotificationListener;)V", "asNotification", "", "getCallInfo", "()Lcom/bandyer/android_sdk/call/model/CallInfo;", "setCallInfo", "(Lcom/bandyer/android_sdk/call/model/CallInfo;)V", "show", "", "context", "Landroid/content/Context;", "withCapabilities", "capabilities", "Lcom/bandyer/android_sdk/intent/call/CallCapabilities;", "withOptions", "options", "Lcom/bandyer/android_sdk/intent/call/IncomingCallOptions;", "bandyer-android-sdk_release"})
public final class IncomingCallImpl
extends CallImpl
implements IncomingCall {
    private boolean asNotification;
    @NotNull
    private CallInfo callInfo;
    private final BandyerIntent bandyerIntent;
    private final String title;
    private final CallNotificationListener callNotificationListener;

    public IncomingCallImpl(@NotNull CallInfo callInfo, @NotNull BandyerIntent bandyerIntent, @Nullable String string, @NotNull CallNotificationListener callNotificationListener) {
        Call call = CallClient._.getInstance().getOngoingCall();
        if (call == null) {
            Intrinsics.throwNpe();
        }
        super(call, callInfo);
        this.callInfo = callInfo;
        this.bandyerIntent = bandyerIntent;
        this.title = string;
        this.callNotificationListener = callNotificationListener;
    }

    @Override
    @NotNull
    public IncomingCall withCapabilities(@NotNull CallCapabilities callCapabilities) {
        Object object = BandyerSDKClient.Companion.getInstance().getCallModule();
        object = object != null ? object.getOngoingCall() : null;
        if (!(object instanceof CallImpl)) {
            object = null;
        }
        if ((object = (CallImpl)object) != null) {
            CallCapabilities callCapabilities2;
            Object object2 = object;
            object = callCapabilities2;
            CallCapabilities callCapabilities3 = callCapabilities;
            boolean bl = callCapabilities3.getChat();
            boolean bl2 = callCapabilities3.getFileSharing();
            boolean bl3 = callCapabilities3.getScreenSharing();
            boolean bl4 = callCapabilities3.getWhiteboard();
            callCapabilities2 = new CallCapabilities(bl, bl2, bl3, bl4);
            ((CallImpl)object2).setCallCapabilities((CallCapabilities)object);
        }
        IncomingCallImpl incomingCallImpl = this;
        incomingCallImpl.bandyerIntent.putExtras(callCapabilities.get_bundle());
        return incomingCallImpl;
    }

    @Override
    @NotNull
    public IncomingCall withOptions(@NotNull IncomingCallOptions incomingCallOptions) {
        Call call = CallClient._.getInstance().getOngoingCall();
        boolean bl = call != null && (call = call.getOptions()) != null && call.getRecord();
        Object object = BandyerSDKClient.Companion.getInstance().getCallModule();
        if (!((object = object != null ? object.getOngoingCall() : null) instanceof CallImpl)) {
            object = null;
        }
        if ((object = (CallImpl)object) != null) {
            CallOptions callOptions;
            Object object2 = object;
            object = callOptions;
            IncomingCallOptions incomingCallOptions2 = incomingCallOptions;
            boolean bl2 = incomingCallOptions2.getBackCameraAsDefault();
            boolean bl3 = incomingCallOptions2.getDisableProximitySensor();
            callOptions = new CallOptions(bl, bl2, bl3);
            ((CallImpl)object2).setCallOptions((CallOptions)object);
        }
        IncomingCallImpl incomingCallImpl = this;
        incomingCallImpl.bandyerIntent.putExtras(incomingCallOptions.get_bundle$bandyer_android_sdk_release());
        return incomingCallImpl;
    }

    @Override
    public void show(@NotNull Context context) {
        c c2;
        Object object = this.bandyerIntent;
        Object object2 = object.getComponent();
        if (object2 == null) {
            Intrinsics.throwNpe();
        }
        ComponentName componentName = object2;
        Intrinsics.checkExpressionValueIsNotNull((Object)componentName, (String)"bandyerIntent.component!!");
        object.setClassName(context, componentName.getClassName());
        object2 = this.bandyerIntent.getExtras();
        if (object2 == null) {
            Intrinsics.throwNpe();
        }
        BandyerIntent bandyerIntent = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"bandyerIntent.extras!!");
        ((IncomingCallIntentOptions)((Object)bandyerIntent))(context, (Bundle)object2, this.bandyerIntent);
        object2 = ((BandyerBaseIntentOptions)((Object)bandyerIntent)).get_bundle();
        String string = "INITIATOR_USER_ALIAS_KEY";
        UserDetails userDetails = this.getCallInfo().getCallerDetails();
        if (userDetails == null) {
            Intrinsics.throwNpe();
        }
        IncomingCallImpl incomingCallImpl = this;
        object2.putString(string, userDetails.getUserAlias());
        object2 = c2;
        string = this.title;
        c2 = new c(context, string, ((BandyerBaseIntentOptions)object).get_bundle());
        incomingCallImpl.callNotificationListener.onCallActivityStartedFromNotificationAction(this.getCallInfo(), (IncomingCallIntentOptions)object);
        incomingCallImpl.callNotificationListener.onCreateNotification(this.getCallInfo(), CallNotificationType.INCOMING, (CallNotificationStyle)object2);
        boolean bl = a.z(context);
        if (this.asNotification) {
            ((c)object2).show();
        } else if (Build.VERSION.SDK_INT >= 29 && bl) {
            ((c)object2).g().show();
        } else if (Build.VERSION.SDK_INT >= 29 && !ForegroundBackgroundOperationsDispatcher.b.a()) {
            ((c)object2).show();
        } else {
            context.startActivity((Intent)((BandyerBaseIntentOptions)object).build());
            ((c)object2).h().show();
        }
    }

    @Override
    @NotNull
    public IncomingCall asNotification() {
        this.asNotification = true;
        return this;
    }

    @Override
    @NotNull
    public CallInfo getCallInfo() {
        return this.callInfo;
    }

    @Override
    public void setCallInfo(@NotNull CallInfo callInfo) {
        this.callInfo = callInfo;
    }
}

