/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.android_sdk.call;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentActivity;
import com.bandyer.android_common.LifecycleEvents;
import com.bandyer.android_common.LifecyleBinder;
import com.bandyer.android_sdk.BandyerSDK;
import com.bandyer.android_sdk.ForegroundBackgroundOperationsDispatcher;
import com.bandyer.android_sdk.call.BandyerCallActivity;
import com.bandyer.android_sdk.call.CallException;
import com.bandyer.android_sdk.call.CallModule;
import com.bandyer.android_sdk.call.CallModuleImpl;
import com.bandyer.android_sdk.call.CallObserver;
import com.bandyer.android_sdk.client.BandyerSDKClient;
import com.bandyer.android_sdk.module.AuthenticationException;
import com.bandyer.android_sdk.module.BandyerModuleObserver;
import com.bandyer.android_sdk.module.BandyerModuleStatus;
import com.bandyer.android_sdk.module.BaseBandyerModule;
import com.bandyer.android_sdk.module.ModuleException;
import com.bandyer.android_sdk.notification.BandyerNotificator;
import com.bandyer.android_sdk.utils.BandyerSDKLogger;
import com.bandyer.communication_center.call.Call;
import com.bandyer.communication_center.call.CallCreationException;
import com.bandyer.communication_center.call.CallOptions;
import com.bandyer.communication_center.call.IncomingCall;
import com.bandyer.communication_center.call.OnCallCreationObserver;
import com.bandyer.communication_center.call_client.CallClient;
import com.bandyer.communication_center.call_client.CallClientEndOfSupportException;
import com.bandyer.communication_center.call_client.CallClientException;
import com.bandyer.communication_center.call_client.CallClientStatus;
import com.bandyer.communication_center.call_client.OnCallClientObserver;
import com.bandyer.communication_center.call_client.OnIncomingCallObserver;
import com.bandyer.communication_center.call_client.OnNotificationObserver;
import com.bandyer.communication_center.call_client.User;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0083\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b*\u0001\u001a\b\u0000\u0018\u0000 D2\u00020\u00012\u00020\u0002:\u0002CDB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010$\u001a\u00020%2\b\b\u0001\u0010&\u001a\u00020'2\b\b\u0001\u0010(\u001a\u00020\u000eH\u0016J$\u0010)\u001a\u00020%2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\b\u00100\u001a\u00020%H\u0016J2\u00101\u001a\u00020%2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00062\f\u00103\u001a\b\u0012\u0004\u0012\u00020%042\f\u00105\u001a\b\u0012\u0004\u0012\u00020%04J\u0016\u00106\u001a\u00020%2\u0006\u00107\u001a\u00020\u00062\u0006\u0010.\u001a\u00020/J\u0012\u00108\u001a\u00020%2\n\b\u0002\u00109\u001a\u0004\u0018\u00010:J\u0006\u0010;\u001a\u00020%J\b\u0010<\u001a\u00020%H\u0016J\b\u0010=\u001a\u00020%H\u0016J\u0010\u0010>\u001a\u00020%2\u0006\u0010(\u001a\u00020\u000eH\u0016J\b\u0010?\u001a\u00020%H\u0016J\b\u0010@\u001a\u00020%H\u0016J\b\u0010A\u001a\u00020%H\u0016J\b\u0010B\u001a\u00020%H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\b\u0018\u00010\u0018R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014R\u000e\u0010\u001d\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006E"}, d2={"Lcom/bandyer/android_sdk/call/CallModuleImpl;", "Lcom/bandyer/android_sdk/module/BaseBandyerModule;", "Lcom/bandyer/android_sdk/call/CallModule;", "context", "Landroid/content/Context;", "userAlias", "", "bandyerModuleObserver", "Lcom/bandyer/android_sdk/module/BandyerModuleObserver;", "(Landroid/content/Context;Ljava/lang/String;Lcom/bandyer/android_sdk/module/BandyerModuleObserver;)V", "callClientObserver", "Lcom/bandyer/communication_center/call_client/OnCallClientObserver;", "callObservers", "", "Lcom/bandyer/android_sdk/call/CallObserver;", "getCallObservers", "()Ljava/util/List;", "canBePaused", "", "getCanBePaused", "()Z", "canInit", "getCanInit", "creationObserver", "Lcom/bandyer/android_sdk/call/CallModuleImpl$CallModuleCreationObserver;", "incomingCallObserver", "com/bandyer/android_sdk/call/CallModuleImpl$incomingCallObserver$1", "Lcom/bandyer/android_sdk/call/CallModuleImpl$incomingCallObserver$1;", "isReady", "lifecyclePause", "reconnectionAttempts", "", "getReconnectionAttempts", "()I", "setReconnectionAttempts", "(I)V", "addCallObserver", "", "appCompatActivity", "Landroidx/appcompat/app/AppCompatActivity;", "observer", "createCall", "users", "", "options", "Lcom/bandyer/communication_center/call/CallOptions;", "onCallCreationObserver", "Lcom/bandyer/communication_center/call/OnCallCreationObserver;", "destroy", "handleNotification", "payload", "successCallback", "Lkotlin/Function0;", "errorCallback", "joinCall", "joinUrl", "notifyCallEnded", "callException", "Lcom/bandyer/android_sdk/call/CallException;", "notifyCallStarted", "reconnect", "removeAllCallObservers", "removeCallObserver", "resume", "startListening", "stop", "stopListening", "CallModuleCreationObserver", "Companion", "bandyer-android-sdk_release"})
public final class CallModuleImpl
extends BaseBandyerModule
implements CallModule {
    @NotNull
    public static final String TAG = "Call Module";
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<CallObserver> callObservers;
    private boolean lifecyclePause;
    private final OnCallClientObserver callClientObserver;
    private CallModuleCreationObserver creationObserver;
    private final incomingCallObserver.1 incomingCallObserver;
    private int reconnectionAttempts;

    public static /* synthetic */ void notifyCallEnded$default(CallModuleImpl callModuleImpl, CallException callException, int n2, Object object) {
        if ((n2 & 1) != 0) {
            callException = null;
        }
        callModuleImpl.notifyCallEnded(callException);
    }

    public CallModuleImpl(@NotNull Context context, @NotNull String string2, @NotNull BandyerModuleObserver bandyerModuleObserver) {
        CallModuleImpl callModuleImpl = this;
        BandyerModuleObserver bandyerModuleObserver2 = bandyerModuleObserver;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"userAlias");
        Intrinsics.checkParameterIsNotNull((Object)bandyerModuleObserver2, (String)"bandyerModuleObserver");
        super(context, string2, bandyerModuleObserver2);
        callModuleImpl.callObservers = new ArrayList<CallObserver>();
        callModuleImpl.callClientObserver = new OnCallClientObserver(this){
            final /* synthetic */ CallModuleImpl this$0;
            {
                this.this$0 = callModuleImpl;
            }

            public void onCallClientDestroyed() {
                CallModuleImpl.access$statusChanged(this.this$0, BandyerModuleStatus.DESTROYED);
            }

            public void onCallClientFailed(@NotNull CallClientException object) {
                CallClientException callClientException = object;
                Intrinsics.checkParameterIsNotNull((Object)callClientException, (String)"reason");
                if (callClientException instanceof CallClientEndOfSupportException) {
                    CallClientException callClientException2 = object;
                    CallModuleImpl callModuleImpl = callModuleImpl.this$0;
                    String string2 = callClientException2.getMessage();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Object object2 = object;
                    object2(string2);
                    CallModuleImpl.access$failed(callModuleImpl, (Throwable)object2);
                } else {
                    String string3 = object.getMessage();
                    if (string3 != null && StringsKt.contains$default((CharSequence)string3, (CharSequence)" Authentication Error", (boolean)false, (int)2, null)) {
                        CallModuleImpl.access$failed(callModuleImpl.this$0, new AuthenticationException("Authentication failed!"));
                    } else {
                        CallModuleImpl.access$failed(callModuleImpl.this$0, new ModuleException(object.getLocalizedMessage()));
                    }
                }
            }

            public void onCallClientInitialized(@NotNull User user) {
                callClientObserver.1 v0 = this;
                Intrinsics.checkParameterIsNotNull((Object)user, (String)"sessionUser");
                CallModuleImpl.access$statusChanged(v0.this$0, BandyerModuleStatus.CONNECTED);
                CallModuleImpl.access$moduleReady(v0.this$0);
            }

            public void onCallClientReconnecting() {
                CallModuleImpl.access$statusChanged(this.this$0, BandyerModuleStatus.RECONNECTING);
            }

            public void onCallClientResumed() {
                callClientObserver.1 v0 = this;
                CallModuleImpl.access$statusChanged(v0.this$0, BandyerModuleStatus.CONNECTED);
                CallModuleImpl.access$moduleReady(v0.this$0);
            }

            public void onCallClientStopped() {
                CallModuleImpl.access$paused(this.this$0);
            }
        };
        callModuleImpl.incomingCallObserver = new OnIncomingCallObserver(this, context, string2){
            final /* synthetic */ CallModuleImpl this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ String $userAlias;
            {
                this.this$0 = callModuleImpl;
                this.$context = context;
                this.$userAlias = string2;
            }

            public void onIncomingCall(@NotNull IncomingCall incomingCall) {
                Intrinsics.checkParameterIsNotNull((Object)incomingCall, (String)"call");
                BandyerSDKLogger bandyerSDKLogger = CallModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release();
                if (bandyerSDKLogger != null) {
                    bandyerSDKLogger.info("Call Module", "Incoming call...");
                }
                if ((bandyerSDKLogger = CallModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release()) != null) {
                    bandyerSDKLogger.debug("Call Module", "Incoming call = " + incomingCall);
                }
                BandyerNotificator.INSTANCE.notificateCallListeners(this.$context, CallModuleImpl.access$getBandyerSdk$p(this.this$0), this.$userAlias, (Call)incomingCall);
            }
        };
        CallClient._.getInstance().addStatusObserver(this.callClientObserver);
        CallClient._.getInstance().init(string2);
        callModuleImpl.statusChanged(BandyerModuleStatus.CONNECTING);
    }

    public static final /* synthetic */ BandyerSDK access$getBandyerSdk$p(CallModuleImpl callModuleImpl) {
        return callModuleImpl.getBandyerSdk();
    }

    public static final /* synthetic */ void access$statusChanged(CallModuleImpl callModuleImpl, BandyerModuleStatus bandyerModuleStatus) {
        callModuleImpl.statusChanged(bandyerModuleStatus);
    }

    public static final /* synthetic */ void access$failed(CallModuleImpl callModuleImpl, Throwable throwable) {
        callModuleImpl.failed(throwable);
    }

    public static final /* synthetic */ void access$moduleReady(CallModuleImpl callModuleImpl) {
        callModuleImpl.moduleReady();
    }

    public static final /* synthetic */ void access$paused(CallModuleImpl callModuleImpl) {
        callModuleImpl.paused();
    }

    @Override
    @NotNull
    public List<CallObserver> getCallObservers() {
        return this.callObservers;
    }

    public final boolean getCanBePaused() {
        return CallClient._.getInstance().getOngoingCall() == null || ((this = CallClient._.getInstance().getOngoingCall()) != null ? this.getStatus() : null) == Call.Status.ENDED || ((this = CallClient._.getInstance().getOngoingCall()) != null ? this.getStatus() : null) == Call.Status.FAILED;
    }

    @Override
    public boolean isReady() {
        return this.getStatus() == BandyerModuleStatus.CONNECTED || this.getStatus() == BandyerModuleStatus.READY;
    }

    @Override
    public boolean getCanInit() {
        return CallClient._.getInstance().getStatus() == CallClientStatus.DESTROYED;
    }

    @Override
    public void reconnect() {
        if (this.getStatus() == BandyerModuleStatus.FAILED) {
            return;
        }
        CallModuleImpl callModuleImpl = this;
        callModuleImpl.setReconnectionAttempts(callModuleImpl.getReconnectionAttempts() + 1);
        CallClient._.getInstance().resume();
    }

    @Override
    public int getReconnectionAttempts() {
        return this.reconnectionAttempts;
    }

    public void setReconnectionAttempts(int n2) {
        this.reconnectionAttempts = n2;
    }

    public final void handleNotification(@NotNull Context context, @NotNull String string2, @NotNull Function0<Unit> function0, @NotNull Function0<Unit> function02) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"payload");
        Intrinsics.checkParameterIsNotNull(function0, (String)"successCallback");
        Intrinsics.checkParameterIsNotNull(function02, (String)"errorCallback");
        if (CallClient._.getInstance().getStatus() != CallClientStatus.RUNNING) {
            if ((this = ((BaseBandyerModule)this).getBandyerSdk().getLogger$bandyer_android_sdk_release()) != null) {
                ((BandyerSDKLogger)((Object)this)).error(TAG, "handleNotification error: You must have the BandyerSDKClient running!");
            }
            function02.invoke();
            return;
        }
        if (ForegroundBackgroundOperationsDispatcher.b.a()) {
            if ((this = ((BaseBandyerModule)this).getBandyerSdk().getLogger$bandyer_android_sdk_release()) != null) {
                ((BandyerSDKLogger)((Object)this)).warn(TAG, "handleNotification error: You should not handle a notification while in foreground and running!");
            }
            function02.invoke();
            return;
        }
        CallClient._.getInstance().handleNotification(string2, new OnNotificationObserver((CallModuleImpl)this, context, function0, function02){
            final /* synthetic */ CallModuleImpl this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ Function0 $successCallback;
            final /* synthetic */ Function0 $errorCallback;
            {
                this.this$0 = callModuleImpl;
                this.$context = context;
                this.$successCallback = function0;
                this.$errorCallback = function02;
            }

            public void onSuccess(@NotNull IncomingCall incomingCall) {
                Intrinsics.checkParameterIsNotNull((Object)incomingCall, (String)"call");
                BandyerSDKLogger bandyerSDKLogger = CallModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release();
                if (bandyerSDKLogger != null) {
                    bandyerSDKLogger.info("Call Module", "Handling notification payload...");
                }
                if ((bandyerSDKLogger = CallModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release()) != null) {
                    bandyerSDKLogger.debug("Call Module", "Notification handle payload success: " + incomingCall);
                }
                BandyerNotificator.INSTANCE.notificateCallListeners(this.$context, CallModuleImpl.access$getBandyerSdk$p(this.this$0), this.this$0.getUserAlias(), (Call)incomingCall);
                this.$successCallback.invoke();
            }

            public void onError(@NotNull String string2) {
                Intrinsics.checkParameterIsNotNull((Object)string2, (String)"error");
                BandyerSDKLogger bandyerSDKLogger = CallModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release();
                if (bandyerSDKLogger != null) {
                    bandyerSDKLogger.error("Call Module", "Notification handle payload error: " + string2);
                }
                this.$errorCallback.invoke();
            }
        });
    }

    public final void createCall(@NotNull List<String> list, @NotNull CallOptions callOptions, @NotNull OnCallCreationObserver onCallCreationObserver) {
        CallModuleImpl callModuleImpl;
        Intrinsics.checkParameterIsNotNull(list, (String)"users");
        Intrinsics.checkParameterIsNotNull((Object)callOptions, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)onCallCreationObserver, (String)"onCallCreationObserver");
        callModuleImpl2.creationObserver = callModuleImpl2.new CallModuleCreationObserver(new WeakReference<OnCallCreationObserver>(onCallCreationObserver));
        CallModuleImpl callModuleImpl2 = CallClient._.getInstance();
        onCallCreationObserver = callModuleImpl.creationObserver;
        if (onCallCreationObserver == null) {
            Intrinsics.throwNpe();
        }
        callModuleImpl2.call(list, callOptions, onCallCreationObserver);
    }

    public final void joinCall(@NotNull String string2, @NotNull OnCallCreationObserver onCallCreationObserver) {
        CallModuleImpl callModuleImpl;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"joinUrl");
        Intrinsics.checkParameterIsNotNull((Object)onCallCreationObserver, (String)"onCallCreationObserver");
        callModuleImpl2.creationObserver = callModuleImpl2.new CallModuleCreationObserver(new WeakReference<OnCallCreationObserver>(onCallCreationObserver));
        CallModuleImpl callModuleImpl2 = CallClient._.getInstance();
        onCallCreationObserver = callModuleImpl.creationObserver;
        if (onCallCreationObserver == null) {
            Intrinsics.throwNpe();
        }
        callModuleImpl2.join(string2, onCallCreationObserver);
    }

    @Override
    public void stop() {
        this.lifecyclePause = true;
        if (this.getCanBePaused()) {
            CallClient._.getInstance().stop();
        }
    }

    @Override
    public void resume() {
        this.statusChanged(BandyerModuleStatus.CONNECTING);
        CallClient._.getInstance().resume();
    }

    @Override
    public void destroy() {
        CallModuleImpl callModuleImpl = CallClient._.getInstance().getOngoingCall();
        if (callModuleImpl != null) {
            callModuleImpl.hangUp(Call.EndReason.HANGUP);
        }
        CallClient._.getInstance().destroy();
    }

    @Override
    public void startListening() {
        CallClient._.getInstance().addIncomingCallObserver((OnIncomingCallObserver)this.incomingCallObserver);
    }

    @Override
    public void stopListening() {
        CallClient._.getInstance().removeIncomingCallObserver((OnIncomingCallObserver)this.incomingCallObserver);
    }

    public final void notifyCallStarted() {
        Iterator iterator = ((CallModuleImpl)((Object)iterator)).getCallObservers().iterator();
        while (iterator.hasNext()) {
            ((CallObserver)iterator.next()).onCallStarted();
        }
    }

    public final void notifyCallEnded(@Nullable CallException callException) {
        Object object = BandyerSDKClient.Companion.getInstance();
        if (object != null) {
            if ((object = ((BandyerSDKClient)object).getCallModuleImpl$bandyer_android_sdk_release()) != null && (object = ((CallModuleImpl)object).getCallObservers()) != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    CallObserver callObserver2 = (CallObserver)object.next();
                    if (callException != null) {
                        callObserver2.onCallEndedWithError(callException);
                        continue;
                    }
                    callObserver2.onCallEnded();
                }
            }
            return;
        }
        throw new TypeCastException("null cannot be cast to non-null type com.bandyer.android_sdk.client.BandyerSDKClient");
    }

    @Override
    public void addCallObserver(@NonNull @NotNull AppCompatActivity appCompatActivity, @NonNull @NotNull CallObserver callObserver2) {
        Intrinsics.checkParameterIsNotNull((Object)appCompatActivity, (String)"appCompatActivity");
        Intrinsics.checkParameterIsNotNull((Object)callObserver2, (String)"observer");
        if (this.getCallObservers().contains(callObserver2)) {
            return;
        }
        this.getCallObservers().add(callObserver2);
        if (CallClient._.getInstance().getOngoingCall() != null) {
            callObserver2.onCallStarted();
        }
        LifecyleBinder.INSTANCE.bind((FragmentActivity)appCompatActivity, new LifecycleEvents(this, callObserver2){
            final /* synthetic */ CallModuleImpl this$0;
            final /* synthetic */ CallObserver $observer;
            {
                this.this$0 = callModuleImpl;
                this.$observer = callObserver2;
            }

            public void create() {
            }

            public void destroy() {
                this.this$0.getCallObservers().remove(this.$observer);
            }

            public void pause() {
            }

            public void resume() {
            }

            public void start() {
            }

            public void stop() {
            }
        });
    }

    @Override
    public void removeCallObserver(@NotNull CallObserver callObserver2) {
        Intrinsics.checkParameterIsNotNull((Object)callObserver2, (String)"observer");
        this.getCallObservers().remove(callObserver2);
    }

    @Override
    public void removeAllCallObservers() {
        this.getCallObservers().clear();
    }

    @Override
    @NotNull
    public String getName() {
        return CallModule.DefaultImpls.getName(this);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/bandyer/android_sdk/call/CallModuleImpl$CallModuleCreationObserver;", "Lcom/bandyer/communication_center/call/OnCallCreationObserver;", "onCallCreationObserver", "Ljava/lang/ref/WeakReference;", "(Lcom/bandyer/android_sdk/call/CallModuleImpl;Ljava/lang/ref/WeakReference;)V", "onCallCreationError", "", "reason", "Lcom/bandyer/communication_center/call/CallCreationException;", "onCallCreationSuccess", "call", "Lcom/bandyer/communication_center/call/Call;", "bandyer-android-sdk_release"})
    public final class CallModuleCreationObserver
    implements OnCallCreationObserver {
        private final WeakReference<OnCallCreationObserver> onCallCreationObserver;

        public CallModuleCreationObserver(WeakReference<OnCallCreationObserver> weakReference) {
            Intrinsics.checkParameterIsNotNull(weakReference, (String)"onCallCreationObserver");
            this.onCallCreationObserver = weakReference;
        }

        public void onCallCreationSuccess(@NotNull Call call) {
            Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
            if (BandyerCallActivity.j.a() == null) {
                call.hangUp(Call.EndReason.HANGUP);
                return;
            }
            CallModuleCreationObserver callModuleCreationObserver = (OnCallCreationObserver)callModuleCreationObserver.onCallCreationObserver.get();
            if (callModuleCreationObserver != null) {
                callModuleCreationObserver.onCallCreationSuccess(call);
            }
        }

        public void onCallCreationError(@NotNull CallCreationException callCreationException) {
            Intrinsics.checkParameterIsNotNull((Object)callCreationException, (String)"reason");
            CallModuleCreationObserver callModuleCreationObserver = (OnCallCreationObserver)callModuleCreationObserver.onCallCreationObserver.get();
            if (callModuleCreationObserver != null) {
                callModuleCreationObserver.onCallCreationError(callCreationException);
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/bandyer/android_sdk/call/CallModuleImpl$Companion;", "", "()V", "TAG", "", "bandyer-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

