/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.android_sdk.chat;

import android.content.Context;
import android.support.annotation.RequiresApi;
import com.bandyer.android_chat_sdk.ChatAuthenticationException;
import com.bandyer.android_chat_sdk.ChatClient;
import com.bandyer.android_chat_sdk.ChatClientObserver;
import com.bandyer.android_chat_sdk.ChatClientState;
import com.bandyer.android_chat_sdk.IncomingChatMessage;
import com.bandyer.android_chat_sdk.OnIncomingChatMessageObserver;
import com.bandyer.android_chat_sdk.OnNotificationObserver;
import com.bandyer.android_sdk.BandyerSDK;
import com.bandyer.android_sdk.ForegroundBackgroundOperationsDispatcher;
import com.bandyer.android_sdk.chat.ChatModule;
import com.bandyer.android_sdk.chat.ChatModuleImpl;
import com.bandyer.android_sdk.chat.ChatModuleImpl$WhenMappings;
import com.bandyer.android_sdk.chat.notification.internal.b;
import com.bandyer.android_sdk.module.BandyerModuleObserver;
import com.bandyer.android_sdk.module.BandyerModuleStatus;
import com.bandyer.android_sdk.module.BaseBandyerModule;
import com.bandyer.android_sdk.notification.BandyerNotificator;
import com.bandyer.android_sdk.utils.BandyerSDKLogger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000W\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b*\u0001\u0011\b\u0001\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\"\u001a\u00020#H\u0016J2\u0010$\u001a\u00020#2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00062\f\u0010&\u001a\b\u0012\u0004\u0012\u00020#0'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020#0'J\b\u0010)\u001a\u00020#H\u0016J\b\u0010*\u001a\u00020#H\u0016J\b\u0010+\u001a\u00020#H\u0016J\b\u0010,\u001a\u00020#H\u0016J\b\u0010-\u001a\u00020#H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u001c\u0010\u0013\u001a\u00020\u000b8VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\r\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006/"}, d2={"Lcom/bandyer/android_sdk/chat/ChatModuleImpl;", "Lcom/bandyer/android_sdk/module/BaseBandyerModule;", "Lcom/bandyer/android_sdk/chat/ChatModule;", "context", "Landroid/content/Context;", "userAlias", "", "bandyerModuleObserver", "Lcom/bandyer/android_sdk/module/BandyerModuleObserver;", "(Landroid/content/Context;Ljava/lang/String;Lcom/bandyer/android_sdk/module/BandyerModuleObserver;)V", "canInit", "", "getCanInit", "()Z", "chatClientObserver", "Lcom/bandyer/android_chat_sdk/ChatClientObserver;", "incomingChatObserver", "com/bandyer/android_sdk/chat/ChatModuleImpl$incomingChatObserver$1", "Lcom/bandyer/android_sdk/chat/ChatModuleImpl$incomingChatObserver$1;", "isReady", "setReady", "(Z)V", "reconnectionAttempts", "", "getReconnectionAttempts", "()I", "setReconnectionAttempts", "(I)V", "status", "Lcom/bandyer/android_sdk/module/BandyerModuleStatus;", "getStatus", "()Lcom/bandyer/android_sdk/module/BandyerModuleStatus;", "setStatus", "(Lcom/bandyer/android_sdk/module/BandyerModuleStatus;)V", "destroy", "", "handleNotification", "payload", "successCallback", "Lkotlin/Function0;", "errorCallback", "reconnect", "resume", "startListening", "stop", "stopListening", "Companion", "bandyer-android-sdk_release"})
@RequiresApi(value=19)
public final class ChatModuleImpl
extends BaseBandyerModule
implements ChatModule {
    private final boolean canInit;
    @NotNull
    private BandyerModuleStatus status;
    private boolean isReady;
    private final incomingChatObserver.1 incomingChatObserver;
    private final ChatClientObserver chatClientObserver;
    private int reconnectionAttempts;
    @NotNull
    public static final String TAG = "Chat Module";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean getCanInit() {
        return this.canInit;
    }

    @Override
    @NotNull
    public BandyerModuleStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(@NotNull BandyerModuleStatus bandyerModuleStatus) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)bandyerModuleStatus), (String)"<set-?>");
        this.status = bandyerModuleStatus;
    }

    @Override
    public boolean isReady() {
        return this.getStatus() == BandyerModuleStatus.CONNECTED || this.getStatus() == BandyerModuleStatus.READY;
    }

    public void setReady(boolean bl) {
        this.isReady = bl;
    }

    public final void handleNotification(@NotNull Context context, @NotNull String string2, @NotNull Function0<Unit> function0, @NotNull Function0<Unit> function02) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"payload");
        Intrinsics.checkParameterIsNotNull(function0, (String)"successCallback");
        Intrinsics.checkParameterIsNotNull(function02, (String)"errorCallback");
        if (ChatClient.Companion.getInstance().getState() == ChatClientState.UNINITIALIZED) {
            BandyerSDKLogger bandyerSDKLogger = this.getBandyerSdk().getLogger$bandyer_android_sdk_release();
            if (bandyerSDKLogger != null) {
                bandyerSDKLogger.error(TAG, "handleNotification error: You must have the BandyerSDKClient running!");
            }
            function02.invoke();
            return;
        }
        if (ForegroundBackgroundOperationsDispatcher.a.a()) {
            BandyerSDKLogger bandyerSDKLogger = this.getBandyerSdk().getLogger$bandyer_android_sdk_release();
            if (bandyerSDKLogger != null) {
                bandyerSDKLogger.warn(TAG, "handleNotification error: You should not handle a notification while in foreground and running!");
            }
            function02.invoke();
            return;
        }
        ChatClient.Companion.getInstance().handleNotification(string2, new OnNotificationObserver(this, context, function0, function02){
            final /* synthetic */ ChatModuleImpl this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ Function0 $successCallback;
            final /* synthetic */ Function0 $errorCallback;

            public void onSuccess(@NotNull IncomingChatMessage incomingChatMessage) {
                Intrinsics.checkParameterIsNotNull((Object)incomingChatMessage, (String)"chatMessage");
                BandyerSDKLogger bandyerSDKLogger = ChatModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release();
                if (bandyerSDKLogger != null) {
                    bandyerSDKLogger.info("Chat Module", "Handling notification payload...");
                }
                BandyerSDKLogger bandyerSDKLogger2 = ChatModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release();
                if (bandyerSDKLogger2 != null) {
                    bandyerSDKLogger2.debug("Chat Module", "Notification handle payload success: " + incomingChatMessage);
                }
                BandyerNotificator.INSTANCE.notificateChatListeners(this.$context, ChatModuleImpl.access$getBandyerSdk$p(this.this$0), incomingChatMessage);
                this.$successCallback.invoke();
            }

            public void onError(@NotNull String string2) {
                Intrinsics.checkParameterIsNotNull((Object)string2, (String)"error");
                BandyerSDKLogger bandyerSDKLogger = ChatModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release();
                if (bandyerSDKLogger != null) {
                    bandyerSDKLogger.error("Chat Module", "Notification handle payload error: " + string2);
                }
                this.$errorCallback.invoke();
            }
            {
                this.this$0 = chatModuleImpl;
                this.$context = context;
                this.$successCallback = function0;
                this.$errorCallback = function02;
            }
        });
    }

    @Override
    public void reconnect() {
        if (this.getStatus() == BandyerModuleStatus.FAILED) {
            return;
        }
        ChatModuleImpl chatModuleImpl = this;
        int n2 = chatModuleImpl.getReconnectionAttempts();
        chatModuleImpl.setReconnectionAttempts(n2 + 1);
        this.statusChanged(BandyerModuleStatus.RECONNECTING);
        ChatClient.Companion.getInstance().connect();
    }

    @Override
    public int getReconnectionAttempts() {
        return this.reconnectionAttempts;
    }

    public void setReconnectionAttempts(int n2) {
        this.reconnectionAttempts = n2;
    }

    @Override
    public void stop() {
        this.setReconnectionAttempts(0);
        ChatClient.Companion.getInstance().stop();
    }

    @Override
    public void resume() {
        ChatClient.Companion.getInstance().resume();
    }

    @Override
    public void destroy() {
        this.setReconnectionAttempts(0);
        ChatClient.Companion.getInstance().dispose();
    }

    @Override
    public void startListening() {
        ChatClient.Companion.getInstance().addIncomingChatMessageObserver((OnIncomingChatMessageObserver)this.incomingChatObserver);
    }

    @Override
    public void stopListening() {
        ChatClient.Companion.getInstance().removeIncomingChatMessageObserver((OnIncomingChatMessageObserver)this.incomingChatObserver);
    }

    public ChatModuleImpl(@NotNull Context context, @NotNull String string2, @NotNull BandyerModuleObserver bandyerModuleObserver) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"userAlias");
        Intrinsics.checkParameterIsNotNull((Object)bandyerModuleObserver, (String)"bandyerModuleObserver");
        super(context, string2, bandyerModuleObserver);
        this.canInit = ChatClient.Companion.getInstance().getState() == ChatClientState.UNINITIALIZED;
        this.status = BandyerModuleStatus.DISCONNECTED;
        this.incomingChatObserver = new OnIncomingChatMessageObserver(this, context){
            final /* synthetic */ ChatModuleImpl this$0;
            final /* synthetic */ Context $context;

            public void onIncomingChatMessage(@NotNull IncomingChatMessage incomingChatMessage) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)incomingChatMessage, (String)"incomingChatMessage");
                    b.a.a(this.$context, incomingChatMessage);
                    BandyerNotificator.INSTANCE.notificateChatListeners(this.$context, ChatModuleImpl.access$getBandyerSdk$p(this.this$0), incomingChatMessage);
                    BandyerSDKLogger bandyerSDKLogger = ChatModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release();
                    if (bandyerSDKLogger == null) break block0;
                    bandyerSDKLogger.info("Chat Module", "on incoming chat message...");
                }
            }
            {
                this.this$0 = chatModuleImpl;
                this.$context = context;
            }
        };
        this.chatClientObserver = new ChatClientObserver(this){
            final /* synthetic */ ChatModuleImpl this$0;

            public void onChatClientConnectionError(@NotNull Throwable throwable) {
                Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ChatAuthenticationException) {
                    ChatModuleImpl.access$failed(this.this$0, new Throwable("Authorization failed!"));
                } else {
                    ChatModuleImpl.access$statusChanged(this.this$0, BandyerModuleStatus.DISCONNECTED);
                }
            }

            public void onStatusChange(@NotNull ChatClientState chatClientState) {
                Intrinsics.checkParameterIsNotNull((Object)chatClientState, (String)"status");
                switch (ChatModuleImpl$WhenMappings.$EnumSwitchMapping$0[chatClientState.ordinal()]) {
                    case 1: {
                        ChatModuleImpl.access$statusChanged(this.this$0, BandyerModuleStatus.INITIALIZING);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        ChatModuleImpl.access$statusChanged(this.this$0, BandyerModuleStatus.CONNECTING);
                        if (chatClientState != ChatClientState.OFFLINE) break;
                        ChatModuleImpl.access$moduleReady(this.this$0);
                        break;
                    }
                    case 5: {
                        ChatModuleImpl.access$paused(this.this$0);
                        break;
                    }
                    case 6: {
                        this.this$0.setReconnectionAttempts(0);
                        ChatModuleImpl.access$statusChanged(this.this$0, BandyerModuleStatus.CONNECTED);
                    }
                }
            }
            {
                this.this$0 = chatModuleImpl;
            }
        };
        ChatClient.Companion.getInstance().addChatClientStateObserver(this.chatClientObserver);
        ChatClient.Companion.getInstance().init(this.getBandyerSdk().getApplicationContext$bandyer_android_sdk_release(), string2);
    }

    @Override
    @NotNull
    public String getName() {
        return ChatModule.DefaultImpls.getName(this);
    }

    public static final /* synthetic */ BandyerSDK access$getBandyerSdk$p(ChatModuleImpl chatModuleImpl) {
        return chatModuleImpl.getBandyerSdk();
    }

    public static final /* synthetic */ void access$failed(ChatModuleImpl chatModuleImpl, Throwable throwable) {
        chatModuleImpl.failed(throwable);
    }

    public static final /* synthetic */ void access$statusChanged(ChatModuleImpl chatModuleImpl, BandyerModuleStatus bandyerModuleStatus) {
        chatModuleImpl.statusChanged(bandyerModuleStatus);
    }

    public static final /* synthetic */ void access$moduleReady(ChatModuleImpl chatModuleImpl) {
        chatModuleImpl.moduleReady();
    }

    public static final /* synthetic */ void access$paused(ChatModuleImpl chatModuleImpl) {
        chatModuleImpl.paused();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/bandyer/android_sdk/chat/ChatModuleImpl$Companion;", "", "()V", "TAG", "", "bandyer-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

