/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.android_sdk.call;

import android.content.Context;
import com.bandyer.android_sdk.BandyerSDK;
import com.bandyer.android_sdk.ForegroundBackgroundOperationsDispatcher;
import com.bandyer.android_sdk.call.BandyerCallActivity;
import com.bandyer.android_sdk.call.CallModule;
import com.bandyer.android_sdk.call.CallModuleEndOfSupportException;
import com.bandyer.android_sdk.call.CallModuleImpl;
import com.bandyer.android_sdk.module.BandyerModuleObserver;
import com.bandyer.android_sdk.module.BandyerModuleStatus;
import com.bandyer.android_sdk.module.BaseBandyerModule;
import com.bandyer.android_sdk.notification.BandyerNotificator;
import com.bandyer.android_sdk.utils.BandyerSDKLogger;
import com.bandyer.communication_center.call.Call;
import com.bandyer.communication_center.call.CallCreationException;
import com.bandyer.communication_center.call.CallOptions;
import com.bandyer.communication_center.call.IncomingCall;
import com.bandyer.communication_center.call.OnCallCreationObserver;
import com.bandyer.communication_center.call_client.CallClient;
import com.bandyer.communication_center.call_client.CallClientEndOfSupportException;
import com.bandyer.communication_center.call_client.CallClientException;
import com.bandyer.communication_center.call_client.CallClientInstance;
import com.bandyer.communication_center.call_client.CallClientStatus;
import com.bandyer.communication_center.call_client.OnCallClientObserver;
import com.bandyer.communication_center.call_client.OnIncomingCallObserver;
import com.bandyer.communication_center.call_client.OnNotificationObserver;
import com.bandyer.communication_center.call_client.User;
import java.lang.ref.WeakReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000g\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b*\u0001\u0015\b\u0000\u0018\u0000 52\u00020\u00012\u00020\u0002:\u000245B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ$\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\b\u0010'\u001a\u00020 H\u0016J2\u0010(\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00062\f\u0010*\u001a\b\u0012\u0004\u0012\u00020 0+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020 0+J\u0016\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&J\b\u0010/\u001a\u00020 H\u0016J\b\u00100\u001a\u00020 H\u0016J\b\u00101\u001a\u00020 H\u0016J\b\u00102\u001a\u00020 H\u0016J\b\u00103\u001a\u00020 H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\b\u0018\u00010\u0013R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u000e\u0010\u0018\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u00066"}, d2={"Lcom/bandyer/android_sdk/call/CallModuleImpl;", "Lcom/bandyer/android_sdk/module/BaseBandyerModule;", "Lcom/bandyer/android_sdk/call/CallModule;", "context", "Landroid/content/Context;", "userAlias", "", "bandyerModuleObserver", "Lcom/bandyer/android_sdk/module/BandyerModuleObserver;", "(Landroid/content/Context;Ljava/lang/String;Lcom/bandyer/android_sdk/module/BandyerModuleObserver;)V", "callClientObserver", "Lcom/bandyer/communication_center/call_client/OnCallClientObserver;", "canBePaused", "", "getCanBePaused", "()Z", "canInit", "getCanInit", "creationObserver", "Lcom/bandyer/android_sdk/call/CallModuleImpl$CallModuleCreationObserver;", "incomingCallObserver", "com/bandyer/android_sdk/call/CallModuleImpl$incomingCallObserver$1", "Lcom/bandyer/android_sdk/call/CallModuleImpl$incomingCallObserver$1;", "isReady", "lifecyclePause", "reconnectionAttempts", "", "getReconnectionAttempts", "()I", "setReconnectionAttempts", "(I)V", "createCall", "", "users", "", "options", "Lcom/bandyer/communication_center/call/CallOptions;", "onCallCreationObserver", "Lcom/bandyer/communication_center/call/OnCallCreationObserver;", "destroy", "handleNotification", "payload", "successCallback", "Lkotlin/Function0;", "errorCallback", "joinCall", "joinUrl", "reconnect", "resume", "startListening", "stop", "stopListening", "CallModuleCreationObserver", "Companion", "bandyer-android-sdk_release"})
public final class CallModuleImpl
extends BaseBandyerModule
implements CallModule {
    private boolean lifecyclePause;
    private final OnCallClientObserver callClientObserver;
    private CallModuleCreationObserver creationObserver;
    private final incomingCallObserver.1 incomingCallObserver;
    private int reconnectionAttempts;
    @NotNull
    public static final String TAG = "Call Module";
    public static final Companion Companion = new Companion(null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getCanBePaused() {
        if (CallClient._.getInstance().getOngoingCall() == null) return true;
        Call call = CallClient._.getInstance().getOngoingCall();
        if ((call != null ? call.getStatus() : null) == Call.Status.ENDED) return true;
        Call call2 = CallClient._.getInstance().getOngoingCall();
        if ((call2 != null ? call2.getStatus() : null) != Call.Status.FAILED) return false;
        return true;
    }

    @Override
    public boolean isReady() {
        return this.getStatus() == BandyerModuleStatus.CONNECTED || this.getStatus() == BandyerModuleStatus.READY;
    }

    @Override
    public boolean getCanInit() {
        return CallClient._.getInstance().getStatus() == CallClientStatus.DESTROYED;
    }

    @Override
    public void reconnect() {
        if (this.getStatus() == BandyerModuleStatus.FAILED) {
            return;
        }
        CallModuleImpl callModuleImpl = this;
        int n2 = callModuleImpl.getReconnectionAttempts();
        callModuleImpl.setReconnectionAttempts(n2 + 1);
        CallClient._.getInstance().resume();
    }

    @Override
    public int getReconnectionAttempts() {
        return this.reconnectionAttempts;
    }

    public void setReconnectionAttempts(int n2) {
        this.reconnectionAttempts = n2;
    }

    public final void handleNotification(@NotNull Context context, @NotNull String string2, @NotNull Function0<Unit> function0, @NotNull Function0<Unit> function02) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"payload");
        Intrinsics.checkParameterIsNotNull(function0, (String)"successCallback");
        Intrinsics.checkParameterIsNotNull(function02, (String)"errorCallback");
        if (CallClient._.getInstance().getStatus() != CallClientStatus.RUNNING) {
            BandyerSDKLogger bandyerSDKLogger = this.getBandyerSdk().getLogger$bandyer_android_sdk_release();
            if (bandyerSDKLogger != null) {
                bandyerSDKLogger.error(TAG, "handleNotification error: You must have the BandyerSDKClient running!");
            }
            function02.invoke();
            return;
        }
        if (ForegroundBackgroundOperationsDispatcher.a.a()) {
            BandyerSDKLogger bandyerSDKLogger = this.getBandyerSdk().getLogger$bandyer_android_sdk_release();
            if (bandyerSDKLogger != null) {
                bandyerSDKLogger.warn(TAG, "handleNotification error: You should not handle a notification while in foreground and running!");
            }
            function02.invoke();
            return;
        }
        CallClient._.getInstance().handleNotification(string2, new OnNotificationObserver(this, context, function0, function02){
            final /* synthetic */ CallModuleImpl this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ Function0 $successCallback;
            final /* synthetic */ Function0 $errorCallback;

            public void onSuccess(@NotNull IncomingCall incomingCall) {
                Intrinsics.checkParameterIsNotNull((Object)incomingCall, (String)"call");
                BandyerSDKLogger bandyerSDKLogger = CallModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release();
                if (bandyerSDKLogger != null) {
                    bandyerSDKLogger.info("Call Module", "Handling notification payload...");
                }
                BandyerSDKLogger bandyerSDKLogger2 = CallModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release();
                if (bandyerSDKLogger2 != null) {
                    bandyerSDKLogger2.debug("Call Module", "Notification handle payload success: " + incomingCall);
                }
                BandyerNotificator.INSTANCE.notificateCallListeners(this.$context, CallModuleImpl.access$getBandyerSdk$p(this.this$0), this.this$0.getUserAlias(), (Call)incomingCall);
                this.$successCallback.invoke();
            }

            public void onError(@NotNull String string2) {
                Intrinsics.checkParameterIsNotNull((Object)string2, (String)"error");
                BandyerSDKLogger bandyerSDKLogger = CallModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release();
                if (bandyerSDKLogger != null) {
                    bandyerSDKLogger.error("Call Module", "Notification handle payload error: " + string2);
                }
                this.$errorCallback.invoke();
            }
            {
                this.this$0 = callModuleImpl;
                this.$context = context;
                this.$successCallback = function0;
                this.$errorCallback = function02;
            }
        });
    }

    public final void createCall(@NotNull List<String> list, @NotNull CallOptions callOptions, @NotNull OnCallCreationObserver onCallCreationObserver) {
        Intrinsics.checkParameterIsNotNull(list, (String)"users");
        Intrinsics.checkParameterIsNotNull((Object)callOptions, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)onCallCreationObserver, (String)"onCallCreationObserver");
        this.creationObserver = new CallModuleCreationObserver(new WeakReference<OnCallCreationObserver>(onCallCreationObserver));
        CallClientInstance callClientInstance = CallClient._.getInstance();
        CallModuleCreationObserver callModuleCreationObserver = this.creationObserver;
        if (callModuleCreationObserver == null) {
            Intrinsics.throwNpe();
        }
        callClientInstance.call(list, callOptions, (OnCallCreationObserver)callModuleCreationObserver);
    }

    public final void joinCall(@NotNull String string2, @NotNull OnCallCreationObserver onCallCreationObserver) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"joinUrl");
        Intrinsics.checkParameterIsNotNull((Object)onCallCreationObserver, (String)"onCallCreationObserver");
        this.creationObserver = new CallModuleCreationObserver(new WeakReference<OnCallCreationObserver>(onCallCreationObserver));
        CallClientInstance callClientInstance = CallClient._.getInstance();
        CallModuleCreationObserver callModuleCreationObserver = this.creationObserver;
        if (callModuleCreationObserver == null) {
            Intrinsics.throwNpe();
        }
        callClientInstance.join(string2, (OnCallCreationObserver)callModuleCreationObserver);
    }

    @Override
    public void stop() {
        this.lifecyclePause = true;
        if (this.getCanBePaused()) {
            CallClient._.getInstance().stop();
        }
    }

    @Override
    public void resume() {
        this.statusChanged(BandyerModuleStatus.CONNECTING);
        CallClient._.getInstance().resume();
    }

    @Override
    public void destroy() {
        CallClient._.getInstance().destroy();
    }

    @Override
    public void startListening() {
        CallClient._.getInstance().addIncomingCallObserver((OnIncomingCallObserver)this.incomingCallObserver);
    }

    @Override
    public void stopListening() {
        CallClient._.getInstance().removeIncomingCallObserver((OnIncomingCallObserver)this.incomingCallObserver);
    }

    public CallModuleImpl(@NotNull Context context, @NotNull String string2, @NotNull BandyerModuleObserver bandyerModuleObserver) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"userAlias");
        Intrinsics.checkParameterIsNotNull((Object)bandyerModuleObserver, (String)"bandyerModuleObserver");
        super(context, string2, bandyerModuleObserver);
        this.callClientObserver = new OnCallClientObserver(this){
            final /* synthetic */ CallModuleImpl this$0;

            public void onCallClientDestroyed() {
                CallModuleImpl.access$statusChanged(this.this$0, BandyerModuleStatus.DESTROYED);
            }

            public void onCallClientFailed(@NotNull CallClientException callClientException) {
                Intrinsics.checkParameterIsNotNull((Object)callClientException, (String)"reason");
                if (callClientException instanceof CallClientEndOfSupportException) {
                    String string2 = callClientException.getMessage();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    CallModuleImpl.access$failed(this.this$0, new CallModuleEndOfSupportException(string2));
                } else {
                    CallModuleImpl.access$failed(this.this$0, new Throwable("CallModule failed."));
                }
            }

            public void onCallClientInitialized(@NotNull User user) {
                Intrinsics.checkParameterIsNotNull((Object)user, (String)"sessionUser");
                CallModuleImpl.access$statusChanged(this.this$0, BandyerModuleStatus.CONNECTED);
                CallModuleImpl.access$moduleReady(this.this$0);
            }

            public void onCallClientReconnecting() {
                CallModuleImpl.access$statusChanged(this.this$0, BandyerModuleStatus.RECONNECTING);
            }

            public void onCallClientResumed() {
                CallModuleImpl.access$statusChanged(this.this$0, BandyerModuleStatus.CONNECTED);
                CallModuleImpl.access$moduleReady(this.this$0);
            }

            public void onCallClientStopped() {
                CallModuleImpl.access$paused(this.this$0);
            }
            {
                this.this$0 = callModuleImpl;
            }
        };
        this.incomingCallObserver = new OnIncomingCallObserver(this, context, string2){
            final /* synthetic */ CallModuleImpl this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ String $userAlias;

            public void onIncomingCall(@NotNull IncomingCall incomingCall) {
                Intrinsics.checkParameterIsNotNull((Object)incomingCall, (String)"call");
                BandyerSDKLogger bandyerSDKLogger = CallModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release();
                if (bandyerSDKLogger != null) {
                    bandyerSDKLogger.info("Call Module", "Incoming call...");
                }
                BandyerSDKLogger bandyerSDKLogger2 = CallModuleImpl.access$getBandyerSdk$p(this.this$0).getLogger$bandyer_android_sdk_release();
                if (bandyerSDKLogger2 != null) {
                    bandyerSDKLogger2.debug("Call Module", "Incoming call = " + incomingCall);
                }
                BandyerNotificator.INSTANCE.notificateCallListeners(this.$context, CallModuleImpl.access$getBandyerSdk$p(this.this$0), this.$userAlias, (Call)incomingCall);
            }
            {
                this.this$0 = callModuleImpl;
                this.$context = context;
                this.$userAlias = string2;
            }
        };
        CallClient._.getInstance().addStatusObserver(this.callClientObserver);
        CallClient._.getInstance().init(string2);
        this.statusChanged(BandyerModuleStatus.CONNECTING);
    }

    @Override
    @NotNull
    public String getName() {
        return CallModule.DefaultImpls.getName(this);
    }

    public static final /* synthetic */ BandyerSDK access$getBandyerSdk$p(CallModuleImpl callModuleImpl) {
        return callModuleImpl.getBandyerSdk();
    }

    public static final /* synthetic */ void access$statusChanged(CallModuleImpl callModuleImpl, BandyerModuleStatus bandyerModuleStatus) {
        callModuleImpl.statusChanged(bandyerModuleStatus);
    }

    public static final /* synthetic */ void access$failed(CallModuleImpl callModuleImpl, Throwable throwable) {
        callModuleImpl.failed(throwable);
    }

    public static final /* synthetic */ void access$moduleReady(CallModuleImpl callModuleImpl) {
        callModuleImpl.moduleReady();
    }

    public static final /* synthetic */ void access$paused(CallModuleImpl callModuleImpl) {
        callModuleImpl.paused();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/bandyer/android_sdk/call/CallModuleImpl$CallModuleCreationObserver;", "Lcom/bandyer/communication_center/call/OnCallCreationObserver;", "onCallCreationObserver", "Ljava/lang/ref/WeakReference;", "(Lcom/bandyer/android_sdk/call/CallModuleImpl;Ljava/lang/ref/WeakReference;)V", "getOnCallCreationObserver", "()Ljava/lang/ref/WeakReference;", "onCallCreationError", "", "reason", "Lcom/bandyer/communication_center/call/CallCreationException;", "onCallCreationSuccess", "call", "Lcom/bandyer/communication_center/call/Call;", "bandyer-android-sdk_release"})
    public final class CallModuleCreationObserver
    implements OnCallCreationObserver {
        @NotNull
        private final WeakReference<OnCallCreationObserver> onCallCreationObserver;

        public void onCallCreationSuccess(@NotNull Call call) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                if (BandyerCallActivity.b.a() == null) {
                    call.hangUp(Call.EndReason.HANGUP);
                    return;
                }
                OnCallCreationObserver onCallCreationObserver = (OnCallCreationObserver)this.onCallCreationObserver.get();
                if (onCallCreationObserver == null) break block1;
                onCallCreationObserver.onCallCreationSuccess(call);
            }
        }

        public void onCallCreationError(@NotNull CallCreationException callCreationException) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)callCreationException, (String)"reason");
                OnCallCreationObserver onCallCreationObserver = (OnCallCreationObserver)this.onCallCreationObserver.get();
                if (onCallCreationObserver == null) break block0;
                onCallCreationObserver.onCallCreationError(callCreationException);
            }
        }

        @NotNull
        public final WeakReference<OnCallCreationObserver> getOnCallCreationObserver() {
            return this.onCallCreationObserver;
        }

        public CallModuleCreationObserver(@NotNull WeakReference<OnCallCreationObserver> weakReference) {
            Intrinsics.checkParameterIsNotNull(weakReference, (String)"onCallCreationObserver");
            this.onCallCreationObserver = weakReference;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/bandyer/android_sdk/call/CallModuleImpl$Companion;", "", "()V", "TAG", "", "bandyer-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

