/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.android_sdk;

import android.content.Context;
import android.os.Build;
import android.support.annotation.RequiresApi;
import com.bandyer.android_chat_sdk.ChatModule;
import com.bandyer.android_chat_sdk.utils.ChatLogger;
import com.bandyer.android_sdk.BandyerSDK$Builder$WhenMappings;
import com.bandyer.android_sdk.networking.Environment;
import com.bandyer.android_sdk.utils.BandyerSDKLogger;
import com.bandyer.communication_center.CommunicationCenter;
import com.bandyer.communication_center.utils.logging.CommCenterLogger;
import com.google.gson.GsonBuilder;
import java.security.InvalidParameterException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B-\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/bandyer/android_sdk/BandyerSDK;", "", "applicationContext", "Landroid/content/Context;", "callSdk", "Lcom/bandyer/communication_center/CommunicationCenter;", "chatSdk", "Lcom/bandyer/android_chat_sdk/ChatModule;", "logger", "Lcom/bandyer/android_sdk/utils/BandyerSDKLogger;", "(Landroid/content/Context;Lcom/bandyer/communication_center/CommunicationCenter;Lcom/bandyer/android_chat_sdk/ChatModule;Lcom/bandyer/android_sdk/utils/BandyerSDKLogger;)V", "getApplicationContext", "()Landroid/content/Context;", "getCallSdk", "()Lcom/bandyer/communication_center/CommunicationCenter;", "getChatSdk", "()Lcom/bandyer/android_chat_sdk/ChatModule;", "getLogger", "()Lcom/bandyer/android_sdk/utils/BandyerSDKLogger;", "Builder", "Companion", "bandyer-android-sdk_release"})
public class BandyerSDK {
    @NotNull
    private final Context applicationContext;
    @Nullable
    private final CommunicationCenter callSdk;
    @Nullable
    private final ChatModule chatSdk;
    @Nullable
    private final BandyerSDKLogger logger;
    private static boolean initialized;
    @Nullable
    private static volatile BandyerSDK instance;
    public static final Companion Companion;

    @NotNull
    public final Context getApplicationContext() {
        return this.applicationContext;
    }

    @Nullable
    public final CommunicationCenter getCallSdk() {
        return this.callSdk;
    }

    @Nullable
    public final ChatModule getChatSdk() {
        return this.chatSdk;
    }

    @Nullable
    public final BandyerSDKLogger getLogger() {
        return this.logger;
    }

    private BandyerSDK(Context context, CommunicationCenter communicationCenter, ChatModule chatModule, BandyerSDKLogger bandyerSDKLogger) {
        this.applicationContext = context;
        this.callSdk = communicationCenter;
        this.chatSdk = chatModule;
        this.logger = bandyerSDKLogger;
    }

    static {
        Companion = new Companion(null);
    }

    public /* synthetic */ BandyerSDK(@NotNull Context context, @Nullable CommunicationCenter communicationCenter, @Nullable ChatModule chatModule, @Nullable BandyerSDKLogger bandyerSDKLogger, DefaultConstructorMarker defaultConstructorMarker) {
        this(context, communicationCenter, chatModule, bandyerSDKLogger);
    }

    @JvmStatic
    @NotNull
    public static final BandyerSDK initWithDefaults(@NotNull Context context, @NotNull String string, @NotNull String string2) {
        return Companion.initWithDefaults(context, string, string2);
    }

    @JvmStatic
    @NotNull
    public static final BandyerSDK init(@NotNull Builder builder) {
        return Companion.init(builder);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0002J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0018J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u001aJ\u000e\u0010'\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u001cJ\u000e\u0010(\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u001eJ\u0006\u0010)\u001a\u00020\u0000J\b\u0010*\u001a\u00020\u0000H\u0007R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/bandyer/android_sdk/BandyerSDK$Builder;", "", "applicationContext", "Landroid/content/Context;", "appId", "", "apiKey", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;)V", "getApiKey", "()Ljava/lang/String;", "getAppId", "callModule", "Lcom/bandyer/communication_center/CommunicationCenter;", "chatLogger", "Lcom/bandyer/android_chat_sdk/utils/ChatLogger;", "chatModule", "Lcom/bandyer/android_chat_sdk/ChatModule;", "commCenterLogger", "Lcom/bandyer/communication_center/utils/logging/CommCenterLogger;", "context", "enableChatModule", "", "enableCommunicationCenterModule", "environment", "Lcom/bandyer/android_sdk/networking/Environment;", "gsonBuilder", "Lcom/google/gson/GsonBuilder;", "httpStack", "Lokhttp3/OkHttpClient$Builder;", "logger", "Lcom/bandyer/android_sdk/utils/BandyerSDKLogger;", "build", "Lcom/bandyer/android_sdk/BandyerSDK;", "initializeCallModule", "", "initializeChatModule", "setEnvironment", "value", "setGsonBuilder", "setHttpStackBuilder", "setLogger", "withCallEnabled", "withChatEnabled", "bandyer-android-sdk_release"})
    public static class Builder {
        private Context context;
        private ChatModule chatModule;
        private CommunicationCenter callModule;
        private Environment environment;
        private boolean enableChatModule;
        private boolean enableCommunicationCenterModule;
        private OkHttpClient.Builder httpStack;
        private GsonBuilder gsonBuilder;
        private BandyerSDKLogger logger;
        private ChatLogger chatLogger;
        private CommCenterLogger commCenterLogger;
        @NotNull
        private final String appId;
        @NotNull
        private final String apiKey;

        @NotNull
        public final BandyerSDK build() {
            if (StringsKt.isBlank((CharSequence)this.appId)) {
                throw (Throwable)new InvalidParameterException("Invalid appId!!");
            }
            if (StringsKt.isBlank((CharSequence)this.apiKey)) {
                throw (Throwable)new InvalidParameterException("Invalid apiKey!!");
            }
            if (this.enableChatModule) {
                this.initializeChatModule();
            }
            if (this.enableCommunicationCenterModule) {
                this.initializeCallModule();
            }
            Context context = this.context;
            if (context == null) {
                Intrinsics.throwNpe();
            }
            return new BandyerSDK(context, this.callModule, this.chatModule, this.logger, null);
        }

        @NotNull
        public final Builder setEnvironment(@NotNull Environment environment) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"value");
            this.environment = environment;
            return this;
        }

        @RequiresApi(value=19)
        @NotNull
        public final Builder withChatEnabled() {
            this.enableChatModule = true;
            return this;
        }

        @NotNull
        public final Builder withCallEnabled() {
            this.enableCommunicationCenterModule = true;
            return this;
        }

        @NotNull
        public final Builder setHttpStackBuilder(@NotNull OkHttpClient.Builder builder) {
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"value");
            this.httpStack = builder;
            return this;
        }

        @NotNull
        public final Builder setGsonBuilder(@NotNull GsonBuilder gsonBuilder) {
            Intrinsics.checkParameterIsNotNull((Object)gsonBuilder, (String)"value");
            this.gsonBuilder = gsonBuilder;
            return this;
        }

        @NotNull
        public final Builder setLogger(@NotNull BandyerSDKLogger bandyerSDKLogger) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)bandyerSDKLogger), (String)"value");
            this.logger = bandyerSDKLogger;
            return this;
        }

        private final void initializeChatModule() {
            if (this.context == null) {
                throw (Throwable)new InvalidParameterException("Please init Bandyer SDK module with a valid application context!");
            }
            if (this.environment == null) {
                throw (Throwable)new InvalidParameterException("Please add a valid environment for Chat Module!");
            }
            Context context = this.context;
            if (context == null) {
                Intrinsics.throwNpe();
            }
            ChatModule.Builder builder = new ChatModule.Builder(context, this.appId, this.apiKey);
            Environment environment = this.environment;
            if (environment != null) {
                switch (BandyerSDK$Builder$WhenMappings.$EnumSwitchMapping$0[environment.ordinal()]) {
                    case 1: {
                        builder.setEnvironment(com.bandyer.android_chat_sdk.networking.Environment.Configuration.production());
                        break;
                    }
                    case 2: {
                        builder.setEnvironment(com.bandyer.android_chat_sdk.networking.Environment.Configuration.sandbox());
                    }
                }
            }
            if (this.logger != null) {
                builder.setLogger(this.chatLogger);
            }
            this.chatModule = ChatModule.Companion.init(builder);
        }

        private final void initializeCallModule() {
            if (this.context == null) {
                throw (Throwable)new RuntimeException("Please init Bandyer SDK module with a valid application context!");
            }
            if (this.environment == null) {
                throw (Throwable)new RuntimeException("Please add a valid environment for Chat Module!");
            }
            Context context = this.context;
            if (context == null) {
                Intrinsics.throwNpe();
            }
            CommunicationCenter.Builder builder = new CommunicationCenter.Builder(context, this.appId);
            if (this.httpStack != null) {
                OkHttpClient.Builder builder2 = this.httpStack;
                if (builder2 == null) {
                    Intrinsics.throwNpe();
                }
                builder.setHttpStackBuilder(builder2);
            }
            if (this.logger != null && this.logger != null) {
                builder.setLogger(this.commCenterLogger);
            }
            if (this.gsonBuilder != null) {
                GsonBuilder gsonBuilder = this.gsonBuilder;
                if (gsonBuilder == null) {
                    Intrinsics.throwNpe();
                }
                builder.setGsonBuilder(gsonBuilder);
            }
            Environment environment = this.environment;
            if (environment != null) {
                switch (BandyerSDK$Builder$WhenMappings.$EnumSwitchMapping$1[environment.ordinal()]) {
                    case 1: {
                        builder.setEnvironment(com.bandyer.communication_center.Environment.Configuration.production());
                        break;
                    }
                    case 2: {
                        builder.setEnvironment(com.bandyer.communication_center.Environment.Configuration.sandbox());
                    }
                }
            }
            this.callModule = CommunicationCenter.Companion.init(builder);
        }

        @NotNull
        public final String getAppId() {
            return this.appId;
        }

        @NotNull
        public final String getApiKey() {
            return this.apiKey;
        }

        public Builder(@NotNull Context context, @NotNull String string, @NotNull String string2) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"applicationContext");
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"appId");
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"apiKey");
            this.appId = string;
            this.apiKey = string2;
            this.chatLogger = new ChatLogger(this){
                final /* synthetic */ Builder this$0;

                public void debug(@NotNull String string, @NotNull String string2) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)string, (String)"tag");
                        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"message");
                        BandyerSDKLogger bandyerSDKLogger = Builder.access$getLogger$p(this.this$0);
                        if (bandyerSDKLogger == null) break block0;
                        bandyerSDKLogger.debug(string, string2);
                    }
                }

                public void info(@NotNull String string, @NotNull String string2) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)string, (String)"tag");
                        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"message");
                        BandyerSDKLogger bandyerSDKLogger = Builder.access$getLogger$p(this.this$0);
                        if (bandyerSDKLogger == null) break block0;
                        bandyerSDKLogger.info(string, string2);
                    }
                }

                public void verbose(@NotNull String string, @NotNull String string2) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)string, (String)"tag");
                        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"message");
                        BandyerSDKLogger bandyerSDKLogger = Builder.access$getLogger$p(this.this$0);
                        if (bandyerSDKLogger == null) break block0;
                        bandyerSDKLogger.verbose(string, string2);
                    }
                }

                public void warn(@NotNull String string, @NotNull String string2) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)string, (String)"tag");
                        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"message");
                        BandyerSDKLogger bandyerSDKLogger = Builder.access$getLogger$p(this.this$0);
                        if (bandyerSDKLogger == null) break block0;
                        bandyerSDKLogger.warn(string, string2);
                    }
                }

                public void error(@NotNull String string, @NotNull String string2) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)string, (String)"tag");
                        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"message");
                        BandyerSDKLogger bandyerSDKLogger = Builder.access$getLogger$p(this.this$0);
                        if (bandyerSDKLogger == null) break block0;
                        bandyerSDKLogger.error(string, string2);
                    }
                }
                {
                    this.this$0 = builder;
                    super(0, 1, null);
                }
            };
            this.commCenterLogger = new CommCenterLogger(this){
                final /* synthetic */ Builder this$0;

                public void debug(@NotNull String string, @NotNull String string2) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)string, (String)"tag");
                        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"message");
                        BandyerSDKLogger bandyerSDKLogger = Builder.access$getLogger$p(this.this$0);
                        if (bandyerSDKLogger == null) break block0;
                        bandyerSDKLogger.debug(string, string2);
                    }
                }

                public void info(@NotNull String string, @NotNull String string2) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)string, (String)"tag");
                        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"message");
                        BandyerSDKLogger bandyerSDKLogger = Builder.access$getLogger$p(this.this$0);
                        if (bandyerSDKLogger == null) break block0;
                        bandyerSDKLogger.info(string, string2);
                    }
                }

                public void verbose(@NotNull String string, @NotNull String string2) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)string, (String)"tag");
                        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"message");
                        BandyerSDKLogger bandyerSDKLogger = Builder.access$getLogger$p(this.this$0);
                        if (bandyerSDKLogger == null) break block0;
                        bandyerSDKLogger.verbose(string, string2);
                    }
                }

                public void warn(@NotNull String string, @NotNull String string2) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)string, (String)"tag");
                        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"message");
                        BandyerSDKLogger bandyerSDKLogger = Builder.access$getLogger$p(this.this$0);
                        if (bandyerSDKLogger == null) break block0;
                        bandyerSDKLogger.warn(string, string2);
                    }
                }

                public void error(@NotNull String string, @NotNull String string2) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)string, (String)"tag");
                        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"message");
                        BandyerSDKLogger bandyerSDKLogger = Builder.access$getLogger$p(this.this$0);
                        if (bandyerSDKLogger == null) break block0;
                        bandyerSDKLogger.error(string, string2);
                    }
                }
                {
                    this.this$0 = builder;
                    super(0, 1, null);
                }
            };
            this.context = context.getApplicationContext();
        }

        @Nullable
        public static final /* synthetic */ BandyerSDKLogger access$getLogger$p(Builder builder) {
            return builder.logger;
        }

        public static final /* synthetic */ void access$setLogger$p(Builder builder, @Nullable BandyerSDKLogger bandyerSDKLogger) {
            builder.logger = bandyerSDKLogger;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0007J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0004\u0018\u00010\u00068F@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/bandyer/android_sdk/BandyerSDK$Companion;", "", "()V", "initialized", "", "instance", "Lcom/bandyer/android_sdk/BandyerSDK;", "getInstance", "()Lcom/bandyer/android_sdk/BandyerSDK;", "setInstance", "(Lcom/bandyer/android_sdk/BandyerSDK;)V", "init", "builder", "Lcom/bandyer/android_sdk/BandyerSDK$Builder;", "initWithDefaults", "context", "Landroid/content/Context;", "appId", "", "apiKey", "setSingletonInstance", "", "sdk", "setSingletonInstance$bandyer_android_sdk_release", "bandyer-android-sdk_release"})
    public static final class Companion {
        @Nullable
        public final BandyerSDK getInstance() {
            if (!initialized) {
                throw (Throwable)new RuntimeException("Please initialize the BandyerSdkModule singleton!!");
            }
            return instance;
        }

        public final void setInstance(@Nullable BandyerSDK bandyerSDK) {
            instance = bandyerSDK;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final BandyerSDK initWithDefaults(@NotNull Context context, @NotNull String string, @NotNull String string2) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"appId");
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"apiKey");
            if (StringsKt.isBlank((CharSequence)string)) {
                throw (Throwable)new InvalidParameterException("Invalid appId!!");
            }
            if (StringsKt.isBlank((CharSequence)string2)) {
                throw (Throwable)new InvalidParameterException("Invalid apiKey!!");
            }
            initialized = true;
            if (this.getInstance() == null) {
                Class<CommunicationCenter> clazz = CommunicationCenter.class;
                synchronized (clazz) {
                    block10: {
                        if (Companion.getInstance() == null) break block10;
                        BandyerSDK bandyerSDK = Companion.getInstance();
                        if (bandyerSDK == null) {
                            Intrinsics.throwNpe();
                        }
                        BandyerSDK bandyerSDK2 = bandyerSDK;
                        return bandyerSDK2;
                    }
                    Builder builder = new Builder(context, string, string2).withCallEnabled();
                    if (Build.VERSION.SDK_INT >= 19) {
                        builder.withChatEnabled();
                    }
                    Companion.setInstance(builder.build());
                    Unit unit = Unit.INSTANCE;
                }
            }
            BandyerSDK bandyerSDK = this.getInstance();
            if (bandyerSDK == null) {
                Intrinsics.throwNpe();
            }
            return bandyerSDK;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final BandyerSDK init(@NotNull Builder builder) {
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            initialized = true;
            if (this.getInstance() == null) {
                Class<CommunicationCenter> clazz = CommunicationCenter.class;
                synchronized (clazz) {
                    if (Companion.getInstance() == null) {
                        Companion.setInstance(builder.build());
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            BandyerSDK bandyerSDK = this.getInstance();
            if (bandyerSDK == null) {
                Intrinsics.throwNpe();
            }
            return bandyerSDK;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setSingletonInstance$bandyer_android_sdk_release(@NotNull BandyerSDK bandyerSDK) {
            Intrinsics.checkParameterIsNotNull((Object)bandyerSDK, (String)"sdk");
            initialized = true;
            Class<BandyerSDK> clazz = BandyerSDK.class;
            synchronized (clazz) {
                Companion.setInstance(bandyerSDK);
                Unit unit = Unit.INSTANCE;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

