/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.sdk_design.views;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.bandyer.sdk_design.views.ViewOverlayAttacher$WhenMappings;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u0011\u001a\u00020\u000eJ\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002JR\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/bandyer/sdk_design/views/ViewOverlayAttacher;", "Landroid/view/View$OnLayoutChangeListener;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "attachId", "", "type", "Lcom/bandyer/sdk_design/views/ViewOverlayAttacher$OverlayType;", "getView", "()Landroid/view/View;", "windowManager", "Landroid/view/WindowManager;", "attach", "", "context", "Landroid/content/Context;", "detach", "getContextIdentifier", "getSystemOverlayLayoutParams", "Landroid/view/WindowManager$LayoutParams;", "onLayoutChange", "v", "left", "top", "right", "bottom", "oldLeft", "oldTop", "oldRight", "oldBottom", "OverlayType", "bandyer-android-design_release"})
public final class ViewOverlayAttacher
implements View.OnLayoutChangeListener {
    private OverlayType type;
    private final WindowManager windowManager;
    private int attachId;
    @NotNull
    private final View view;

    public final void attach(@NotNull Context context, @NotNull OverlayType type) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                this.view.requestLayout();
                int contextIdentifier = this.getContextIdentifier(context, type);
                if (this.attachId == contextIdentifier) {
                    return;
                }
                this.detach();
                if (!(context instanceof Activity) && type == OverlayType.CURRENT_APPLICATION) {
                    return;
                }
                this.attachId = contextIdentifier;
                this.type = type;
                if (this.type != OverlayType.GLOBAL) break block5;
                this.view.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                ViewOverlayAttacher viewOverlayAttacher = this;
                boolean bl = false;
                try {
                    Object object = Result.Companion;
                    ViewOverlayAttacher $this$runCatching = viewOverlayAttacher;
                    boolean bl2 = false;
                    $this$runCatching.windowManager.addView($this$runCatching.view, (ViewGroup.LayoutParams)$this$runCatching.getSystemOverlayLayoutParams());
                    Unit unit = Unit.INSTANCE;
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)unit);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean bl4 = false;
                    Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                break block6;
            }
            if (!(context instanceof Activity)) break block6;
            Window window = ((Activity)context).getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"context.window");
            View view = window.getDecorView();
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
            }
            ((ViewGroup)view).addView(this.view, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        }
    }

    public final void detach() {
        if (this.attachId == 0) {
            return;
        }
        if (this.type == OverlayType.GLOBAL) {
            boolean bl = false;
            try {
                Object object = Result.Companion;
                boolean bl2 = false;
                this.windowManager.removeViewImmediate(this.view);
                Unit unit = Unit.INSTANCE;
                boolean bl3 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl4 = false;
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        } else {
            ViewParent viewParent = this.view.getParent();
            if (!(viewParent instanceof ViewGroup)) {
                viewParent = null;
            }
            ViewGroup viewGroup = (ViewGroup)viewParent;
            if (viewGroup != null) {
                viewGroup.removeView(this.view);
            }
        }
        this.view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        this.type = null;
        this.attachId = 0;
    }

    private final WindowManager.LayoutParams getSystemOverlayLayoutParams() {
        int type = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
        WindowManager.LayoutParams windowManagerLayoutParams = new WindowManager.LayoutParams(-1, -2, type, 920, -3);
        windowManagerLayoutParams.gravity = 0x800033;
        windowManagerLayoutParams.setTitle((CharSequence)"ViewOverlayAttacher");
        return windowManagerLayoutParams;
    }

    private final int getContextIdentifier(Context context, OverlayType type) {
        int n;
        switch (ViewOverlayAttacher$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                n = context.getApplicationContext().hashCode();
                break;
            }
            case 2: {
                n = context.hashCode();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public void onLayoutChange(@Nullable View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        View view = v;
        Intrinsics.checkNotNull((Object)view);
        this.windowManager.updateViewLayout(v, view.getLayoutParams());
    }

    @NotNull
    public final View getView() {
        return this.view;
    }

    public ViewOverlayAttacher(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
        Object object = this.view.getContext().getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        this.windowManager = (WindowManager)object;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/bandyer/sdk_design/views/ViewOverlayAttacher$OverlayType;", "", "(Ljava/lang/String;I)V", "GLOBAL", "CURRENT_APPLICATION", "bandyer-android-design_release"})
    public static final class OverlayType
    extends Enum<OverlayType> {
        public static final /* enum */ OverlayType GLOBAL;
        public static final /* enum */ OverlayType CURRENT_APPLICATION;
        private static final /* synthetic */ OverlayType[] $VALUES;

        static {
            OverlayType[] overlayTypeArray = new OverlayType[2];
            OverlayType[] overlayTypeArray2 = overlayTypeArray;
            overlayTypeArray[0] = GLOBAL = new OverlayType();
            overlayTypeArray[1] = CURRENT_APPLICATION = new OverlayType();
            $VALUES = overlayTypeArray;
        }

        public static OverlayType[] values() {
            return (OverlayType[])$VALUES.clone();
        }

        public static OverlayType valueOf(String string2) {
            return Enum.valueOf(OverlayType.class, string2);
        }
    }
}

