/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.sdk_design.textviews;

import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.content.ContextCompat;
import com.airbnb.paris.annotations.Attr;
import com.airbnb.paris.annotations.LayoutDimension;
import com.airbnb.paris.annotations.Style;
import com.airbnb.paris.annotations.Styleable;
import com.bandyer.sdk_design.Paris;
import com.bandyer.sdk_design.R;
import com.bandyer.sdk_design.textviews.BandyerTextView$WhenMappings;
import com.bandyer.sdk_design.textviews.BandyerTextViewStyleApplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Styleable(value="BandyerSDKDesign_TextView")
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\b\u0017\u0018\u0000 32\u00020\u0001:\u000234B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0014J\u0012\u0010\u001a\u001a\u00020\u00182\b\b\u0001\u0010\u001b\u001a\u00020\u0007H\u0007J\u0012\u0010\u001c\u001a\u00020\u00182\b\b\u0001\u0010\u001d\u001a\u00020\u0007H\u0007J\u0012\u0010\u001e\u001a\u00020\u00182\b\b\u0001\u0010\u001f\u001a\u00020\u0007H\u0007J\b\u0010 \u001a\u00020\u0018H\u0002J\u0012\u0010!\u001a\u00020\u00182\b\b\u0001\u0010\"\u001a\u00020\u0007H\u0007J\u000e\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u0007H\u0007J\u0012\u0010'\u001a\u00020\u00182\b\b\u0001\u0010\u001d\u001a\u00020\u0007H\u0007J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u0007H\u0007J\u0010\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+H\u0016J\u0012\u0010,\u001a\u00020\u00182\b\b\u0001\u0010\u001d\u001a\u00020\u0007H\u0007J\u0012\u0010-\u001a\u00020\u00182\b\b\u0001\u0010\"\u001a\u00020\u0007H\u0007J\u0012\u0010.\u001a\u00020\u00182\b\b\u0001\u0010\"\u001a\u00020\u0007H\u0007J\u0012\u0010/\u001a\u00020\u00182\b\b\u0001\u0010\"\u001a\u00020\u0007H\u0007J\u001a\u00100\u001a\u00020\u00182\b\u00101\u001a\u0004\u0018\u00010\n2\u0006\u00102\u001a\u00020\u0007H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u00065"}, d2={"Lcom/bandyer/sdk_design/textviews/BandyerTextView;", "Landroidx/appcompat/widget/AppCompatTextView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "fontFamily", "Landroid/graphics/Typeface;", "mCompoundDrawableColorTint", "Ljava/lang/Integer;", "mCompoundDrawableHeight", "mCompoundDrawableWidth", "mShadowColor", "mShadowDx", "", "Ljava/lang/Float;", "mShadowDy", "mShadowRadius", "builderStyle", "Lcom/bandyer/sdk_design/textviews/BandyerTextViewStyleApplier$StyleBuilder;", "initCompoundDrawableSize", "", "onAttachedToWindow", "setCompoundDrawableHeight", "height", "setCompoundDrawableTint", "color", "setCompoundDrawableWidth", "width", "setDrawableColorTint", "setFadingEdgeLengthValue", "dimension", "setFadingEdgeValue", "edge", "Lcom/bandyer/sdk_design/textviews/BandyerTextView$FadingEdge;", "value", "setLinkColor", "setMarqueeRepeatLimitValue", "setSelected", "selected", "", "setShadowColor", "setShadowDx", "setShadowDy", "setShadowRadius", "setTypeface", "tf", "style", "Companion", "FadingEdge", "bandyer-android-design_release"})
public class BandyerTextView
extends AppCompatTextView {
    private Float mShadowDx;
    private Float mShadowDy;
    private Float mShadowRadius;
    private Integer mShadowColor;
    private Integer mCompoundDrawableHeight;
    private Integer mCompoundDrawableWidth;
    private Integer mCompoundDrawableColorTint;
    private Typeface fontFamily;
    @Style
    private static final int TITLE;
    @Style
    private static final int SUBTITLE;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    @NotNull
    public BandyerTextViewStyleApplier.StyleBuilder builderStyle() {
        BandyerTextViewStyleApplier.StyleBuilder styleBuilder = Paris.style(this).builder();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)styleBuilder), (String)"StyleCompat.style(this).builder()");
        return styleBuilder;
    }

    @Attr(value=2)
    public final void setCompoundDrawableTint(@ColorRes int color2) {
        this.mCompoundDrawableColorTint = color2;
    }

    @Attr(value=1)
    public final void setCompoundDrawableHeight(@LayoutDimension int height) {
        this.mCompoundDrawableHeight = height;
    }

    @Attr(value=3)
    public final void setCompoundDrawableWidth(@LayoutDimension int width) {
        this.mCompoundDrawableWidth = width;
    }

    private final void initCompoundDrawableSize() {
        if (this.mCompoundDrawableHeight == null && this.mCompoundDrawableWidth == null) {
            return;
        }
        Object[] objectArray = this.getCompoundDrawables();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"compoundDrawables");
        Object[] compatDrawables = objectArray;
        Object[] relativeDrawables = Build.VERSION.SDK_INT >= 17 ? this.getCompoundDrawablesRelative() : null;
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$apply = list;
        boolean bl4 = false;
        $this$apply.addAll(0, ArraysKt.toList((Object[])compatDrawables));
        Object[] objectArray2 = relativeDrawables;
        if (relativeDrawables == null) {
        } else {
            $this$apply.addAll(0, ArraysKt.toList((Object[])relativeDrawables));
        }
        List drawablesList = list;
        for (Drawable drawable2 : drawablesList) {
            Rect realBounds;
            if (drawable2 == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)drawable2.getBounds(), (String)"drawable.bounds");
            float scaleFactor = (float)realBounds.height() / (float)realBounds.width();
            float drawableWidth = realBounds.width();
            float drawableHeight = realBounds.height();
            Integer n = this.mCompoundDrawableWidth;
            Intrinsics.checkNotNull((Object)n);
            if (n > 0) {
                Integer n2 = this.mCompoundDrawableWidth;
                Intrinsics.checkNotNull((Object)n2);
                if (drawableWidth > (float)n2.intValue()) {
                    Integer n3 = this.mCompoundDrawableWidth;
                    Intrinsics.checkNotNull((Object)n3);
                    drawableWidth = n3.intValue();
                    drawableHeight = drawableWidth * scaleFactor;
                }
            }
            Integer n4 = this.mCompoundDrawableHeight;
            Intrinsics.checkNotNull((Object)n4);
            if (n4 > 0) {
                Integer n5 = this.mCompoundDrawableWidth;
                Intrinsics.checkNotNull((Object)n5);
                if (drawableHeight > (float)n5.intValue()) {
                    Integer n6 = this.mCompoundDrawableWidth;
                    Intrinsics.checkNotNull((Object)n6);
                    drawableHeight = n6.intValue();
                    drawableWidth = drawableHeight / scaleFactor;
                }
            }
            realBounds.right = realBounds.left + Math.round(drawableWidth);
            realBounds.bottom = realBounds.top + Math.round(drawableHeight);
            drawable2.setBounds(realBounds);
        }
        this.setCompoundDrawables((Drawable)compatDrawables[0], (Drawable)compatDrawables[1], (Drawable)compatDrawables[2], (Drawable)compatDrawables[3]);
        if (relativeDrawables == null || Build.VERSION.SDK_INT < 17) {
            return;
        }
        this.setCompoundDrawablesRelative((Drawable)relativeDrawables[0], (Drawable)relativeDrawables[1], (Drawable)relativeDrawables[2], (Drawable)relativeDrawables[3]);
    }

    private final void setDrawableColorTint() {
        Integer n = this.mCompoundDrawableColorTint;
        if (n == null) {
            return;
        }
        n.intValue();
        Object[] objectArray = this.getCompoundDrawables();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"compoundDrawables");
        Iterable $this$forEach$iv = ArraysKt.filterNotNull((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            Drawable drawable2 = it.mutate();
            Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"it.mutate()");
            Context context = this.getContext();
            Integer n2 = this.mCompoundDrawableColorTint;
            Intrinsics.checkNotNull((Object)n2);
            drawable2.setColorFilter((ColorFilter)new PorterDuffColorFilter(ContextCompat.getColor((Context)context, (int)n2), PorterDuff.Mode.SRC_IN));
        }
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.post(new Runnable(this){
            final /* synthetic */ BandyerTextView this$0;

            public final void run() {
                Drawable[] drawableArray = this.this$0.getCompoundDrawables();
                Intrinsics.checkNotNullExpressionValue((Object)drawableArray, (String)"compoundDrawables");
                Drawable[] $this$forEach$iv = drawableArray;
                boolean $i$f$forEach = false;
                Drawable[] drawableArray2 = $this$forEach$iv;
                int n = drawableArray2.length;
                for (int i = 0; i < n; ++i) {
                    Drawable element$iv;
                    Drawable icon = element$iv = drawableArray2[i];
                    boolean bl = false;
                    Drawable drawable2 = icon;
                    if (drawable2 == null || (drawable2 = drawable2.mutate()) == null) continue;
                    drawable2.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.this$0.getCurrentTextColor(), PorterDuff.Mode.MULTIPLY));
                }
            }
            {
                this.this$0 = bandyerTextView;
            }
        });
        this.setTypeface(this.fontFamily, selected ? 1 : 0);
    }

    public void setTypeface(@Nullable Typeface tf, int style2) {
        super.setTypeface(tf, style2);
        if (this.fontFamily != null) {
            return;
        }
        this.fontFamily = tf;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mShadowColor != null) {
            Float f = this.mShadowRadius;
            Float f2 = this.mShadowDx;
            Float f3 = this.mShadowDy;
            Integer n = this.mShadowColor;
            this.setShadowLayer(f != null ? f.floatValue() : 0.0f, f2 != null ? f2.floatValue() : 0.0f, f3 != null ? f3.floatValue() : 0.0f, n != null ? n : 0);
        }
        this.initCompoundDrawableSize();
        this.setDrawableColorTint();
    }

    @Attr(value=7)
    public final void setShadowDx(@LayoutDimension int dimension) {
        this.mShadowDx = Float.valueOf(dimension);
    }

    @Attr(value=0)
    public final void setLinkColor(@ColorInt int color2) {
        this.setLinkTextColor(color2);
    }

    @Attr(value=8)
    public final void setShadowDy(@LayoutDimension int dimension) {
        this.mShadowDy = Float.valueOf(dimension);
    }

    @Attr(value=9)
    public final void setShadowRadius(@LayoutDimension int dimension) {
        this.mShadowRadius = Float.valueOf(dimension);
    }

    @Attr(value=10)
    public final void setShadowColor(@ColorInt int color2) {
        this.mShadowColor = color2;
    }

    @Attr(value=4)
    public final void setFadingEdgeValue(int value) {
        FadingEdge fadingEdge;
        FadingEdge fadingEdge2;
        block2: {
            FadingEdge[] $this$firstOrNull$iv = FadingEdge.values();
            boolean $i$f$firstOrNull = false;
            FadingEdge[] fadingEdgeArray = $this$firstOrNull$iv;
            int n = fadingEdgeArray.length;
            for (int i = 0; i < n; ++i) {
                FadingEdge element$iv;
                FadingEdge it = element$iv = fadingEdgeArray[i];
                boolean bl = false;
                if (!(it.getValue() == value)) continue;
                fadingEdge2 = element$iv;
                break block2;
            }
            fadingEdge2 = fadingEdge = null;
        }
        if (fadingEdge2 == null) {
            fadingEdge = FadingEdge.NONE;
        }
        FadingEdge edge = fadingEdge;
        this.setFadingEdgeValue(edge);
    }

    public final void setFadingEdgeValue(@NotNull FadingEdge edge) {
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        switch (BandyerTextView$WhenMappings.$EnumSwitchMapping$0[edge.ordinal()]) {
            case 1: {
                this.setHorizontalFadingEdgeEnabled(false);
                this.setVerticalFadingEdgeEnabled(false);
                break;
            }
            case 2: {
                this.setHorizontalFadingEdgeEnabled(true);
                break;
            }
            case 3: {
                this.setVerticalFadingEdgeEnabled(true);
                break;
            }
        }
    }

    @Attr(value=5)
    public final void setFadingEdgeLengthValue(@LayoutDimension int dimension) {
        this.setFadingEdgeLength(dimension);
    }

    @Attr(value=6)
    public final void setMarqueeRepeatLimitValue(int value) {
        this.setMarqueeRepeatLimit(value);
    }

    @JvmOverloads
    public BandyerTextView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        ((BandyerTextViewStyleApplier.StyleBuilder)this.builderStyle().add(attrs)).apply();
    }

    public /* synthetic */ BandyerTextView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public BandyerTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public BandyerTextView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        Companion = new Companion(null);
        TITLE = R.style.BandyerSDKDesign_TextView_Title;
        SUBTITLE = R.style.BandyerSDKDesign_TextView_Subtitle;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/bandyer/sdk_design/textviews/BandyerTextView$FadingEdge;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "NONE", "HORIZONTAL", "VERTICAL", "bandyer-android-design_release"})
    public static final class FadingEdge
    extends Enum<FadingEdge> {
        public static final /* enum */ FadingEdge NONE;
        public static final /* enum */ FadingEdge HORIZONTAL;
        public static final /* enum */ FadingEdge VERTICAL;
        private static final /* synthetic */ FadingEdge[] $VALUES;
        private final int value;

        static {
            FadingEdge[] fadingEdgeArray = new FadingEdge[3];
            FadingEdge[] fadingEdgeArray2 = fadingEdgeArray;
            fadingEdgeArray[0] = NONE = new FadingEdge(0);
            fadingEdgeArray[1] = HORIZONTAL = new FadingEdge(4096);
            fadingEdgeArray[2] = VERTICAL = new FadingEdge(8192);
            $VALUES = fadingEdgeArray;
        }

        public final int getValue() {
            return this.value;
        }

        private FadingEdge(int value) {
            this.value = value;
        }

        /* synthetic */ FadingEdge(String string2, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n2 = 0;
            }
            this(n2);
        }

        public static FadingEdge[] values() {
            return (FadingEdge[])$VALUES.clone();
        }

        public static FadingEdge valueOf(String string2) {
            return Enum.valueOf(FadingEdge.class, string2);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/bandyer/sdk_design/textviews/BandyerTextView$Companion;", "", "()V", "SUBTITLE", "", "getSUBTITLE", "()I", "TITLE", "getTITLE", "bandyer-android-design_release"})
    public static final class Companion {
        public final int getTITLE() {
            return TITLE;
        }

        public final int getSUBTITLE() {
            return SUBTITLE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

