/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.sdk_design.imageviews;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Shader;
import com.squareup.picasso.Transformation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/bandyer/sdk_design/imageviews/PicassoCircularTransform;", "Lcom/squareup/picasso/Transformation;", "()V", "key", "", "transform", "Landroid/graphics/Bitmap;", "source", "bandyer-android-design_release"})
public final class PicassoCircularTransform
implements Transformation {
    @NotNull
    public Bitmap transform(@NotNull Bitmap source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int size = Math.min(source.getWidth(), source.getHeight());
        int x = (source.getWidth() - size) / 2;
        int y = (source.getHeight() - size) / 2;
        Bitmap squaredBitmap = Bitmap.createBitmap((Bitmap)source, (int)x, (int)y, (int)size, (int)size);
        if (Intrinsics.areEqual((Object)squaredBitmap, (Object)source) ^ true) {
            source.recycle();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)source.getConfig());
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        BitmapShader shader = new BitmapShader(squaredBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        paint.setShader((Shader)shader);
        paint.setDither(true);
        paint.setAntiAlias(true);
        float r = (float)size / 2.0f;
        canvas.drawCircle(r, r, r, paint);
        squaredBitmap.recycle();
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    @NotNull
    public String key() {
        return this + " circle";
    }
}

