/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.sdk_design.imageviews;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.appcompat.widget.AppCompatImageView;
import com.bandyer.android_common.RoundedView;
import com.bandyer.sdk_design.R;
import com.bandyer.sdk_design.imageviews.PicassoCircularTransform;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.RequestCreator;
import com.squareup.picasso.Transformation;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J!\u0010\u0016\u001a\u00020\u00132\b\b\u0001\u0010\u0017\u001a\u00020\b2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\r2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u000f2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\bH\u0016R\u0012\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/bandyer/sdk_design/imageviews/BandyerRoundedImageView;", "Landroidx/appcompat/widget/AppCompatImageView;", "Lcom/bandyer/android_common/RoundedView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "currentDrawableRes", "Ljava/lang/Integer;", "currentUri", "Landroid/net/Uri;", "currentUrl", "", "mRounded", "", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "setImageResId", "resId", "preventReload", "(ILjava/lang/Boolean;)V", "setImageUri", "uri", "(Landroid/net/Uri;Ljava/lang/Boolean;)V", "setImageUrl", "url", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "setVisibility", "visibility", "bandyer-android-design_release"})
public class BandyerRoundedImageView
extends AppCompatImageView
implements RoundedView {
    private boolean mRounded;
    private String currentUrl;
    private Uri currentUri;
    private Integer currentDrawableRes;
    private HashMap _$_findViewCache;

    protected void onDraw(@Nullable Canvas canvas) {
        this.setRoundClip(this, canvas);
        super.onDraw(canvas);
    }

    public void setVisibility(int visibility) {
        float oldAlpha = this.getAlpha();
        if (visibility == 0) {
            this.setAlpha(0.0f);
        }
        super.setVisibility(visibility);
        if (this.rounded()) {
            this.round(true);
        }
        if (this.radius() > 0.0f) {
            this.setCornerRadius(this.radius());
        }
        this.setAlpha(oldAlpha);
        this.requestLayout();
    }

    public final void setImageUrl(@NotNull String url, @Nullable Boolean preventReload) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Boolean bl = preventReload;
        Intrinsics.checkNotNull((Object)bl);
        if (bl.booleanValue() && Intrinsics.areEqual((Object)this.currentUrl, (Object)url)) {
            return;
        }
        this.currentUrl = url;
        RequestCreator requestCreator = Picasso.get().load(url);
        boolean bl2 = false;
        boolean bl3 = false;
        RequestCreator it = requestCreator;
        boolean bl4 = false;
        if (this.mRounded) {
            it.transform((Transformation)new PicassoCircularTransform());
        }
        requestCreator.noFade().into((ImageView)this);
    }

    public static /* synthetic */ void setImageUrl$default(BandyerRoundedImageView bandyerRoundedImageView, String string2, Boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setImageUrl");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        bandyerRoundedImageView.setImageUrl(string2, bl);
    }

    public final void setImageResId(@DrawableRes int resId, @Nullable Boolean preventReload) {
        Boolean bl = preventReload;
        Intrinsics.checkNotNull((Object)bl);
        if (bl.booleanValue()) {
            Integer n = this.currentDrawableRes;
            if (n != null && n == resId) {
                return;
            }
        }
        this.currentDrawableRes = resId;
        if (resId == 0) {
            return;
        }
        RequestCreator requestCreator = Picasso.get().load(resId);
        boolean bl2 = false;
        boolean bl3 = false;
        RequestCreator it = requestCreator;
        boolean bl4 = false;
        if (this.mRounded) {
            it.transform((Transformation)new PicassoCircularTransform());
        }
        requestCreator.noFade().into((ImageView)this);
    }

    public static /* synthetic */ void setImageResId$default(BandyerRoundedImageView bandyerRoundedImageView, int n, Boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setImageResId");
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        bandyerRoundedImageView.setImageResId(n, bl);
    }

    public final void setImageUri(@NotNull Uri uri, @Nullable Boolean preventReload) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Boolean bl = preventReload;
        Intrinsics.checkNotNull((Object)bl);
        if (bl.booleanValue() && Intrinsics.areEqual((Object)this.currentUri, (Object)uri)) {
            return;
        }
        this.currentUri = uri;
        RequestCreator requestCreator = Picasso.get().load(uri);
        boolean bl2 = false;
        boolean bl3 = false;
        RequestCreator it = requestCreator;
        boolean bl4 = false;
        if (this.mRounded) {
            it.transform((Transformation)new PicassoCircularTransform());
        }
        requestCreator.noFade().into((ImageView)this);
    }

    public static /* synthetic */ void setImageUri$default(BandyerRoundedImageView bandyerRoundedImageView, Uri uri, Boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setImageUri");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        bandyerRoundedImageView.setImageUri(uri, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public BandyerRoundedImageView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RoundableStyle, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026leStyle, defStyleAttr, 0)");
            TypedArray typedArray2 = typedArray;
            try {
                if (typedArray2.getBoolean(R.styleable.RoundableStyle_bandyer_round, true)) {
                    this.mRounded = true;
                } else {
                    Integer n = typedArray2.getDimensionPixelSize(R.styleable.RoundableStyle_bandyer_corner_radius, 0);
                    boolean bl = false;
                    boolean bl2 = false;
                    int it = ((Number)n).intValue();
                    boolean bl3 = false;
                    Integer n2 = it > 0 ? n : null;
                    if (n2 != null) {
                        n = n2;
                        bl = false;
                        bl2 = false;
                        it = ((Number)n).intValue();
                        boolean bl4 = false;
                        this.setCornerRadius(it);
                    }
                }
            }
            finally {
                typedArray2.recycle();
            }
        }
    }

    public /* synthetic */ BandyerRoundedImageView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public BandyerRoundedImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public BandyerRoundedImageView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public <T extends View> float radius() {
        return RoundedView.DefaultImpls.radius((RoundedView)this);
    }

    public <T extends View> float radius(@NotNull T $this$radius) {
        Intrinsics.checkNotNullParameter($this$radius, (String)"$this$radius");
        return RoundedView.DefaultImpls.radius((RoundedView)this, $this$radius);
    }

    public <T extends View> void round(boolean rounded) {
        RoundedView.DefaultImpls.round((RoundedView)this, (boolean)rounded);
    }

    public <T extends View> void round(@NotNull T $this$round, boolean rounded) {
        Intrinsics.checkNotNullParameter($this$round, (String)"$this$round");
        RoundedView.DefaultImpls.round((RoundedView)this, $this$round, (boolean)rounded);
    }

    public <T extends View> boolean rounded() {
        return RoundedView.DefaultImpls.rounded((RoundedView)this);
    }

    public <T extends View> boolean rounded(@NotNull T $this$rounded) {
        Intrinsics.checkNotNullParameter($this$rounded, (String)"$this$rounded");
        return RoundedView.DefaultImpls.rounded((RoundedView)this, $this$rounded);
    }

    public <T extends View> void setCornerRadius(float radius) {
        RoundedView.DefaultImpls.setCornerRadius((RoundedView)this, (float)radius);
    }

    public <T extends View> void setCornerRadius(@NotNull T $this$setCornerRadius, float radius) {
        Intrinsics.checkNotNullParameter($this$setCornerRadius, (String)"$this$setCornerRadius");
        RoundedView.DefaultImpls.setCornerRadius((RoundedView)this, $this$setCornerRadius, (float)radius);
    }

    public <T extends View> void setRoundClip(@NotNull T $this$setRoundClip, @Nullable Canvas canvas) {
        Intrinsics.checkNotNullParameter($this$setRoundClip, (String)"$this$setRoundClip");
        RoundedView.DefaultImpls.setRoundClip((RoundedView)this, $this$setRoundClip, (Canvas)canvas);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

