/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.sdk_design.extensions;

import android.app.Activity;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import com.bandyer.sdk_design.extensions.ContextExtensionsKt$sam$android_app_AppOpsManager_OnOpChangedListener$0;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\u0003*\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002\u001a\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00072\u0006\u0010\f\u001a\u00020\u0003H\u0000\u001a\n\u0010\r\u001a\u00020\u0002*\u00020\u0007\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0007\u001a\n\u0010\u0010\u001a\u00020\u0006*\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u0006*\u00020\u0007\u001a\u0012\u0010\u0013\u001a\u00020\u0003*\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0002\u001a\f\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0007\u001a,\u0010\u0017\u001a\u00020\u0018*\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00180\u001c\u001a$\u0010\u001d\u001a\u00020\u0018*\u00020\u00072\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00180\u001c\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"dipsMap", "Ljava/util/HashMap;", "", "", "pixelsMap", "canDrawOverlays", "", "Landroid/content/Context;", "dp2px", "dp", "getDrawableFromAttrRes", "Landroid/graphics/drawable/Drawable;", "attrRes", "getScreenRatio", "getScreenSize", "Landroid/graphics/Point;", "isInPictureInPictureModeCompat", "Landroid/app/Activity;", "isTablet", "px2dp", "px", "scanForFragmentActivity", "Landroidx/fragment/app/FragmentActivity;", "startAppOpsWatch", "", "operation", "", "callback", "Lkotlin/Function2;", "stopAppOpsWatch", "bandyer-android-design_release"})
public final class ContextExtensionsKt {
    private static final HashMap<Float, Integer> dipsMap = new HashMap();
    private static final HashMap<Float, Integer> pixelsMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final Drawable getDrawableFromAttrRes(@NotNull Context $this$getDrawableFromAttrRes, int attrRes) {
        Intrinsics.checkNotNullParameter((Object)$this$getDrawableFromAttrRes, (String)"$this$getDrawableFromAttrRes");
        TypedArray typedArray = $this$getDrawableFromAttrRes.obtainStyledAttributes(new int[]{attrRes});
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(intArrayOf(attrRes))");
        TypedArray a = typedArray;
        Drawable drawable2 = null;
        try {
            drawable2 = ContextCompat.getDrawable((Context)$this$getDrawableFromAttrRes, (int)a.getResourceId(0, 0));
        }
        finally {
            a.recycle();
        }
        return drawable2;
    }

    public static final boolean isTablet(@NotNull Context $this$isTablet) {
        Intrinsics.checkNotNullParameter((Object)$this$isTablet, (String)"$this$isTablet");
        Resources resources = $this$isTablet.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return (resources.getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static final int dp2px(@NotNull Context $this$dp2px, float dp) {
        Intrinsics.checkNotNullParameter((Object)$this$dp2px, (String)"$this$dp2px");
        Integer n = dipsMap.get(Float.valueOf(dp));
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            Integer it = n2;
            boolean bl3 = false;
            Integer n3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"it");
            return n3;
        }
        Resources resources = $this$dp2px.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        DisplayMetrics metrics = resources.getDisplayMetrics();
        int value = (int)(dp * ((float)metrics.densityDpi / (float)160));
        ((Map)dipsMap).put(Float.valueOf(dp), value);
        return value;
    }

    public static final int px2dp(@NotNull Context $this$px2dp, float px) {
        Intrinsics.checkNotNullParameter((Object)$this$px2dp, (String)"$this$px2dp");
        Integer n = pixelsMap.get(Float.valueOf(px));
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            Integer it = n2;
            boolean bl3 = false;
            Integer n3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"it");
            return n3;
        }
        Resources resources = $this$px2dp.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        DisplayMetrics metrics = resources.getDisplayMetrics();
        int value = (int)(px / ((float)metrics.densityDpi / (float)160));
        ((Map)pixelsMap).put(Float.valueOf(px), value);
        return value;
    }

    public static final float getScreenRatio(@NotNull Context $this$getScreenRatio) {
        Intrinsics.checkNotNullParameter((Object)$this$getScreenRatio, (String)"$this$getScreenRatio");
        Resources resources = $this$getScreenRatio.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return (float)metrics.heightPixels / (float)metrics.widthPixels;
    }

    public static final boolean canDrawOverlays(@NotNull Context $this$canDrawOverlays) {
        Intrinsics.checkNotNullParameter((Object)$this$canDrawOverlays, (String)"$this$canDrawOverlays");
        return Build.VERSION.SDK_INT >= 23 ? Settings.canDrawOverlays((Context)$this$canDrawOverlays.getApplicationContext()) : true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInPictureInPictureModeCompat(@NotNull Activity $this$isInPictureInPictureModeCompat) {
        Intrinsics.checkNotNullParameter((Object)$this$isInPictureInPictureModeCompat, (String)"$this$isInPictureInPictureModeCompat");
        if (Build.VERSION.SDK_INT < 26) return false;
        if (Build.VERSION.SDK_INT < 26) return false;
        if (!$this$isInPictureInPictureModeCompat.getPackageManager().hasSystemFeature("android.software.picture_in_picture")) return false;
        boolean bl = true;
        boolean canGoInPip = bl;
        if (!canGoInPip) return false;
        Activity activity = $this$isInPictureInPictureModeCompat;
        if (!(activity instanceof AppCompatActivity)) {
            activity = null;
        }
        AppCompatActivity appCompatActivity = (AppCompatActivity)activity;
        if (appCompatActivity == null) return false;
        if (!appCompatActivity.isInPictureInPictureMode()) return false;
        return true;
    }

    public static final void stopAppOpsWatch(@NotNull Context $this$stopAppOpsWatch, @NotNull Function2<? super String, ? super String, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)$this$stopAppOpsWatch, (String)"$this$stopAppOpsWatch");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        Object object = $this$stopAppOpsWatch.getSystemService("appops");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.AppOpsManager");
        }
        AppOpsManager appOpsManager = (AppOpsManager)object;
        Function2<? super String, ? super String, Unit> function2 = callback;
        appOpsManager.stopWatchingMode((AppOpsManager.OnOpChangedListener)new ContextExtensionsKt$sam$android_app_AppOpsManager_OnOpChangedListener$0(function2));
    }

    public static final void startAppOpsWatch(@NotNull Context $this$startAppOpsWatch, @NotNull String operation, @NotNull Function2<? super String, ? super String, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)$this$startAppOpsWatch, (String)"$this$startAppOpsWatch");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        Context context = $this$startAppOpsWatch.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
        String pckName = context.getPackageName();
        Object object = $this$startAppOpsWatch.getSystemService("appops");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.AppOpsManager");
        }
        AppOpsManager appOpsManager = (AppOpsManager)object;
        Function2<? super String, ? super String, Unit> function2 = callback;
        appOpsManager.startWatchingMode(operation, pckName, (AppOpsManager.OnOpChangedListener)new ContextExtensionsKt$sam$android_app_AppOpsManager_OnOpChangedListener$0(function2));
    }

    @NotNull
    public static final Point getScreenSize(@NotNull Context $this$getScreenSize) {
        Intrinsics.checkNotNullParameter((Object)$this$getScreenSize, (String)"$this$getScreenSize");
        Object object = $this$getScreenSize.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealSize(size);
        } else {
            display.getSize(size);
        }
        return size;
    }

    @Nullable
    public static final FragmentActivity scanForFragmentActivity(@NotNull Context $this$scanForFragmentActivity) {
        FragmentActivity fragmentActivity;
        Intrinsics.checkNotNullParameter((Object)$this$scanForFragmentActivity, (String)"$this$scanForFragmentActivity");
        Context context = $this$scanForFragmentActivity;
        if (context instanceof AppCompatActivity) {
            fragmentActivity = (FragmentActivity)$this$scanForFragmentActivity;
        } else if (context instanceof FragmentActivity) {
            fragmentActivity = (FragmentActivity)$this$scanForFragmentActivity;
        } else if (context instanceof ContextWrapper) {
            Context context2 = ((ContextWrapper)$this$scanForFragmentActivity).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"this.baseContext");
            fragmentActivity = ContextExtensionsKt.scanForFragmentActivity(context2);
        } else {
            fragmentActivity = null;
        }
        return fragmentActivity;
    }
}

