/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.sdk_design.extensions;

import android.app.Activity;
import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Build;
import android.view.Display;
import android.view.FocusFinder;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import com.bandyer.sdk_design.extensions.ContextExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\u0006*\u00020\u0002\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00022\b\b\u0002\u0010\u000f\u001a\u00020\u0001\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0011"}, d2={"checkIsInMultiWindowMode", "", "Landroid/app/Activity;", "findNextDPADFocus", "Landroid/view/View;", "keyCode", "", "rootView", "Landroid/view/ViewGroup;", "getNavigationBarHeight", "getScreenCenter", "Landroid/graphics/PointF;", "getStatusBarHeight", "hideKeyboard", "", "forced", "isLandscape", "bandyer-android-design_release"})
public final class ActivityExtensionsKt {
    public static final boolean isLandscape(@NotNull Activity $this$isLandscape) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isLandscape, (String)"$this$isLandscape");
        Object object = $this$isLandscape.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        Display display = ((WindowManager)object).getDefaultDisplay();
        Intrinsics.checkNotNullExpressionValue((Object)display, (String)"(getSystemService(Contex\u2026owManager).defaultDisplay");
        int rotation = display.getRotation();
        switch (rotation) {
            case 0: {
                bl = false;
                break;
            }
            case 2: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    public static final void hideKeyboard(@NotNull Activity $this$hideKeyboard, boolean forced) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$hideKeyboard, (String)"$this$hideKeyboard");
            Object object = $this$hideKeyboard.getSystemService("input_method");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
            }
            InputMethodManager inputManager = (InputMethodManager)object;
            int hideMethod = forced ? 0 : 2;
            View view = $this$hideKeyboard.getCurrentFocus();
            if (view == null) break block1;
            View view2 = view;
            boolean bl = false;
            boolean bl2 = false;
            View it = view2;
            boolean bl3 = false;
            View view3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"it");
            inputManager.hideSoftInputFromWindow(view3.getWindowToken(), hideMethod);
        }
    }

    public static /* synthetic */ void hideKeyboard$default(Activity activity, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        ActivityExtensionsKt.hideKeyboard(activity, bl);
    }

    @NotNull
    public static final PointF getScreenCenter(@NotNull Activity $this$getScreenCenter) {
        Intrinsics.checkNotNullParameter((Object)$this$getScreenCenter, (String)"$this$getScreenCenter");
        return new PointF((float)ContextExtensionsKt.getScreenSize((Context)((Context)$this$getScreenCenter)).x / 2.0f, (float)ContextExtensionsKt.getScreenSize((Context)((Context)$this$getScreenCenter)).y / 2.0f);
    }

    public static final int getStatusBarHeight(@NotNull Activity $this$getStatusBarHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$getStatusBarHeight, (String)"$this$getStatusBarHeight");
        Rect rect = new Rect();
        Window window = $this$getStatusBarHeight.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"window");
        window.getDecorView().getWindowVisibleDisplayFrame(rect);
        int statusBarHeight = rect.top;
        return statusBarHeight != ContextExtensionsKt.getScreenSize((Context)((Context)$this$getStatusBarHeight)).y ? statusBarHeight : 0;
    }

    public static final int getNavigationBarHeight(@NotNull Activity $this$getNavigationBarHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$getNavigationBarHeight, (String)"$this$getNavigationBarHeight");
        Rect rect = new Rect();
        Window window = $this$getNavigationBarHeight.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"window");
        window.getDecorView().getWindowVisibleDisplayFrame(rect);
        Window window2 = $this$getNavigationBarHeight.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window2, (String)"window");
        View view = window2.getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
        return view.getHeight() - rect.bottom;
    }

    @Nullable
    public static final View findNextDPADFocus(@NotNull Activity $this$findNextDPADFocus, int keyCode, @NotNull ViewGroup rootView) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$findNextDPADFocus, (String)"$this$findNextDPADFocus");
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        FocusFinder focusFinder = FocusFinder.getInstance();
        View view = rootView.findFocus();
        switch (keyCode) {
            case 21: {
                n = 17;
                break;
            }
            case 19: {
                n = 33;
                break;
            }
            case 22: {
                n = 66;
                break;
            }
            case 20: {
                n = 130;
                break;
            }
            case 61: {
                n = 2;
                break;
            }
            default: {
                n = 2;
            }
        }
        return focusFinder.findNextFocus(rootView, view, n);
    }

    public static final boolean checkIsInMultiWindowMode(@NotNull Activity $this$checkIsInMultiWindowMode) {
        Intrinsics.checkNotNullParameter((Object)$this$checkIsInMultiWindowMode, (String)"$this$checkIsInMultiWindowMode");
        return Build.VERSION.SDK_INT >= 24 ? $this$checkIsInMultiWindowMode.isInMultiWindowMode() : false;
    }
}

