/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.sdk_design.bottom_sheet.behaviours;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.FloatRange;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.ViewCompat;
import androidx.customview.widget.ViewDragHelper;
import com.bandyer.sdk_design.R;
import com.bandyer.sdk_design.bottom_sheet.behaviours.BandyerBottomSheetBehaviour;
import com.bandyer.sdk_design.bottom_sheet.view.BottomSheetLayoutContent;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.Vector;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0093\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017*\u0001$\b\u0007\u0018\u0000 \u0084\u0001*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\f\u0083\u0001\u0084\u0001\u0085\u0001\u0086\u0001\u0087\u0001\u0088\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\"J\u0010\u0010O\u001a\u00020M2\u0006\u0010P\u001a\u00020\nH\u0002J\u0012\u0010Q\u001a\u0004\u0018\u00010\u00022\u0006\u0010R\u001a\u00020\u0002H\u0002J\u000e\u0010S\u001a\u00020*2\u0006\u0010H\u001a\u00020\nJ\u0012\u0010T\u001a\u00020\u00122\b\u0010R\u001a\u0004\u0018\u00010\u0002H\u0002J\u0010\u0010U\u001a\u00020M2\u0006\u0010V\u001a\u00020\u0002H\u0002J\u0018\u0010W\u001a\u00020M2\u0006\u0010X\u001a\u00020\u00022\u0006\u0010G\u001a\u00020*H\u0002J\u0018\u0010Y\u001a\u00020M2\u0006\u0010X\u001a\u00020\u00022\u0006\u0010Z\u001a\u00020\nH\u0002J%\u0010[\u001a\u00020\u00122\u0006\u0010\\\u001a\u00020]2\u0006\u0010V\u001a\u00028\u00002\u0006\u0010^\u001a\u00020_H\u0016\u00a2\u0006\u0002\u0010`J%\u0010a\u001a\u00020\u00122\u0006\u0010\\\u001a\u00020]2\u0006\u0010V\u001a\u00028\u00002\u0006\u0010b\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010cJ5\u0010d\u001a\u00020\u00122\u0006\u0010e\u001a\u00020]2\u0006\u0010V\u001a\u00028\u00002\u0006\u0010f\u001a\u00020\u00022\u0006\u0010g\u001a\u00020*2\u0006\u0010h\u001a\u00020*H\u0016\u00a2\u0006\u0002\u0010iJE\u0010j\u001a\u00020M2\u0006\u0010e\u001a\u00020]2\u0006\u0010V\u001a\u00028\u00002\u0006\u0010f\u001a\u00020\u00022\u0006\u0010k\u001a\u00020\n2\u0006\u0010l\u001a\u00020\n2\u0006\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010pJ%\u0010q\u001a\u00020M2\u0006\u0010\\\u001a\u00020]2\u0006\u0010V\u001a\u00028\u00002\u0006\u0010H\u001a\u00020rH\u0016\u00a2\u0006\u0002\u0010sJ\u001f\u0010t\u001a\u0004\u0018\u00010r2\u0006\u0010\\\u001a\u00020]2\u0006\u0010V\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010uJ=\u0010v\u001a\u00020\u00122\u0006\u0010e\u001a\u00020]2\u0006\u0010V\u001a\u00028\u00002\u0006\u0010w\u001a\u00020\u00022\u0006\u0010f\u001a\u00020\u00022\u0006\u0010x\u001a\u00020\n2\u0006\u0010o\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010yJ-\u0010z\u001a\u00020M2\u0006\u0010e\u001a\u00020]2\u0006\u0010V\u001a\u00028\u00002\u0006\u0010f\u001a\u00020\u00022\u0006\u0010o\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010{J%\u0010|\u001a\u00020\u00122\u0006\u0010\\\u001a\u00020]2\u0006\u0010V\u001a\u00028\u00002\u0006\u0010^\u001a\u00020_H\u0016\u00a2\u0006\u0002\u0010`J\u000e\u0010}\u001a\u00020M2\u0006\u0010N\u001a\u00020\"J\u0006\u0010~\u001a\u00020MJ\b\u0010\u007f\u001a\u00020MH\u0002J\u0011\u0010\u0080\u0001\u001a\u00020M2\u0006\u0010H\u001a\u00020\nH\u0002J\u001a\u0010\u0081\u0001\u001a\u00020\u00122\u0006\u0010V\u001a\u00020\u00022\u0007\u0010\u0082\u0001\u001a\u00020*H\u0002R$\u0010\t\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R \u0010\u0019\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000eR\u000e\u0010\u001e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010%R\u000e\u0010&\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00100\u001a\u00020\n8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\fR\u0018\u00102\u001a\f03R\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u00020\nX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b5\u0010\u001bR\u000e\u00106\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010<\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010>\u001a\u00020\n2\u0006\u0010>\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\f\"\u0004\b@\u0010\u000eR\u001a\u0010A\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u0014\"\u0004\bC\u0010\u0016R\u001a\u0010D\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\u0014\"\u0004\bF\u0010\u0016R\u000e\u0010G\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010H\u001a\u00020\n2\u0006\u0010H\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\u0012\u0012\u0004\bI\u0010\u001b\u001a\u0004\bJ\u0010\f\"\u0004\bK\u0010\u000e\u00a8\u0006\u0089\u0001"}, d2={"Lcom/bandyer/sdk_design/bottom_sheet/behaviours/BandyerBottomSheetBehaviour;", "V", "Landroid/view/View;", "Landroidx/coordinatorlayout/widget/CoordinatorLayout$Behavior;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "anchorOffset", "", "getAnchorOffset", "()I", "setAnchorOffset", "(I)V", "clickGestureDetector", "Landroid/view/GestureDetector;", "disableDragging", "", "getDisableDragging", "()Z", "setDisableDragging", "(Z)V", "isHideable", "setHideable", "lastStableState", "getLastStableState$annotations", "()V", "getLastStableState", "setLastStableState", "mActivePointerId", "mAnchorPoint", "mCallback", "Ljava/util/Vector;", "Lcom/bandyer/sdk_design/bottom_sheet/behaviours/BandyerBottomSheetBehaviour$BottomSheetCallback;", "mDragCallback", "com/bandyer/sdk_design/bottom_sheet/behaviours/BandyerBottomSheetBehaviour$mDragCallback$1", "Lcom/bandyer/sdk_design/bottom_sheet/behaviours/BandyerBottomSheetBehaviour$mDragCallback$1;", "mIgnoreEvents", "mInitialY", "mMaxOffset", "mMaximumVelocity", "", "mMinOffset", "mMinimumVelocity", "mNestedScrolled", "mNestedScrollingChildRef", "Ljava/lang/ref/WeakReference;", "mParentHeight", "getMParentHeight", "mScrollVelocityTracker", "Lcom/bandyer/sdk_design/bottom_sheet/behaviours/BandyerBottomSheetBehaviour$ScrollVelocityTracker;", "mState", "getMState$annotations", "mTouchingScrollingChild", "mVelocityTracker", "Landroid/view/VelocityTracker;", "mViewClickedTop", "mViewDragHelper", "Landroidx/customview/widget/ViewDragHelper;", "mViewRef", "orientation", "peekHeight", "getPeekHeight", "setPeekHeight", "skipAnchor", "getSkipAnchor", "setSkipAnchor", "skipCollapsed", "getSkipCollapsed", "setSkipCollapsed", "slideOffset", "state", "getState$annotations", "getState", "setState", "addBottomSheetCallback", "", "callback", "dispatchOnSlide", "top", "findScrollingChild", "view", "getStableStateSlideOffset", "isVisible", "notifyOnDrawn", "child", "notifyOnSlideToListeners", "bottomSheet", "notifyStateChangedToListeners", "newState", "onInterceptTouchEvent", "parent", "Landroidx/coordinatorlayout/widget/CoordinatorLayout;", "event", "Landroid/view/MotionEvent;", "(Landroidx/coordinatorlayout/widget/CoordinatorLayout;Landroid/view/View;Landroid/view/MotionEvent;)Z", "onLayoutChild", "layoutDirection", "(Landroidx/coordinatorlayout/widget/CoordinatorLayout;Landroid/view/View;I)Z", "onNestedPreFling", "coordinatorLayout", "target", "velocityX", "velocityY", "(Landroidx/coordinatorlayout/widget/CoordinatorLayout;Landroid/view/View;Landroid/view/View;FF)Z", "onNestedPreScroll", "dx", "dy", "consumed", "", "type", "(Landroidx/coordinatorlayout/widget/CoordinatorLayout;Landroid/view/View;Landroid/view/View;II[II)V", "onRestoreInstanceState", "Landroid/os/Parcelable;", "(Landroidx/coordinatorlayout/widget/CoordinatorLayout;Landroid/view/View;Landroid/os/Parcelable;)V", "onSaveInstanceState", "(Landroidx/coordinatorlayout/widget/CoordinatorLayout;Landroid/view/View;)Landroid/os/Parcelable;", "onStartNestedScroll", "directTargetChild", "nestedScrollAxes", "(Landroidx/coordinatorlayout/widget/CoordinatorLayout;Landroid/view/View;Landroid/view/View;Landroid/view/View;II)Z", "onStopNestedScroll", "(Landroidx/coordinatorlayout/widget/CoordinatorLayout;Landroid/view/View;Landroid/view/View;I)V", "onTouchEvent", "removeBottomSheetCallback", "removeBottomSheetCallbacks", "reset", "setStateInternal", "shouldHide", "yvel", "BottomSheetCallback", "Companion", "SavedState", "ScrollVelocityTracker", "SettleRunnable", "State", "bandyer-android-design_release"})
@SuppressLint(value={"PrivateResource"})
public final class BandyerBottomSheetBehaviour<V extends View>
extends CoordinatorLayout.Behavior<V> {
    private int peekHeight;
    private int anchorOffset;
    private boolean isHideable;
    private boolean skipCollapsed;
    private boolean skipAnchor;
    private int mState;
    private int lastStableState;
    private ViewDragHelper mViewDragHelper;
    private boolean mIgnoreEvents;
    private boolean mNestedScrolled;
    private int mParentHeight;
    private WeakReference<V> mViewRef;
    private WeakReference<View> mNestedScrollingChildRef;
    private Vector<BottomSheetCallback> mCallback;
    private int mActivePointerId;
    private int mInitialY;
    private boolean mTouchingScrollingChild;
    private VelocityTracker mVelocityTracker;
    private final ScrollVelocityTracker mScrollVelocityTracker;
    private final float mMinimumVelocity;
    private final float mMaximumVelocity;
    private int mMinOffset;
    private int mMaxOffset;
    private int mAnchorPoint;
    private int mViewClickedTop;
    private float slideOffset;
    private int orientation;
    private boolean disableDragging;
    private final mDragCallback.1 mDragCallback;
    private final GestureDetector clickGestureDetector;
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_SETTLING = 2;
    public static final int STATE_ANCHOR_POINT = 3;
    public static final int STATE_EXPANDED = 4;
    public static final int STATE_COLLAPSED = 5;
    public static final int STATE_HIDDEN = 6;
    private static final float HIDE_THRESHOLD = 0.5f;
    private static final float HIDE_FRICTION = 0.1f;
    private static final int MIN_VELOCITY_SKIP_ANCHOR_STATE = 4000;
    private static final int MAX_VELOCITY_SKIP_ANCHOR_STATE = 10000;
    private static final int MIN_VELOCITY = 300;
    public static final Companion Companion = new Companion(null);

    public final int getPeekHeight() {
        return this.peekHeight;
    }

    public final void setPeekHeight(int peekHeight) {
        this.peekHeight = Math.max(0, peekHeight);
        this.mMaxOffset = this.getMParentHeight() - peekHeight;
    }

    public final int getAnchorOffset() {
        return this.anchorOffset;
    }

    public final void setAnchorOffset(int anchorOffset) {
        this.anchorOffset = anchorOffset;
        this.skipAnchor = anchorOffset < 0;
        this.mAnchorPoint = anchorOffset < 0 ? 0 : this.getMParentHeight() - anchorOffset;
    }

    public final boolean isHideable() {
        return this.isHideable;
    }

    public final void setHideable(boolean bl) {
        this.isHideable = bl;
    }

    public final boolean getSkipCollapsed() {
        return this.skipCollapsed;
    }

    public final void setSkipCollapsed(boolean bl) {
        this.skipCollapsed = bl;
    }

    public final boolean getSkipAnchor() {
        return this.skipAnchor;
    }

    public final void setSkipAnchor(boolean bl) {
        this.skipAnchor = bl;
    }

    private static /* synthetic */ void getMState$annotations() {
    }

    public static /* synthetic */ void getLastStableState$annotations() {
    }

    public final int getLastStableState() {
        return this.lastStableState;
    }

    public final void setLastStableState(int n) {
        this.lastStableState = n;
    }

    private final int getMParentHeight() {
        return this.mParentHeight == 0 ? 5000 : this.mParentHeight;
    }

    public final boolean getDisableDragging() {
        return this.disableDragging;
    }

    public final void setDisableDragging(boolean bl) {
        this.disableDragging = bl;
    }

    public static /* synthetic */ void getState$annotations() {
    }

    public final int getState() {
        return this.mState;
    }

    public final void setState(int state) {
        int n;
        if (this.mViewRef == null) {
            if (state == 5 || state == 4 || state == 3 || this.isHideable && state == 6) {
                this.mState = state;
                this.lastStableState = state;
            }
            return;
        }
        WeakReference<V> weakReference = this.mViewRef;
        Intrinsics.checkNotNull(weakReference);
        View view = (View)weakReference.get();
        if (view == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"mViewRef!!.get() ?: return");
        View child = view;
        if (!this.skipAnchor && state == 3) {
            n = this.mAnchorPoint;
        } else if (state == 5) {
            n = this.mMaxOffset;
        } else if (state == 4) {
            n = this.mMinOffset;
        } else if (this.isHideable && state == 6) {
            n = this.getMParentHeight();
        } else {
            throw (Throwable)new IllegalArgumentException("Illegal state argument: " + state);
        }
        int top = n;
        if (state != this.mState) {
            this.setStateInternal(2);
        }
        ViewDragHelper viewDragHelper = this.mViewDragHelper;
        Intrinsics.checkNotNull((Object)viewDragHelper);
        if (viewDragHelper.smoothSlideViewTo(child, child.getLeft(), top)) {
            ViewCompat.postOnAnimation((View)child, (Runnable)new SettleRunnable(child, state));
        } else {
            this.setStateInternal(state);
        }
    }

    @Nullable
    public Parcelable onSaveInstanceState(@NotNull CoordinatorLayout parent, @NotNull V child) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(child, (String)"child");
        Parcelable parcelable = super.onSaveInstanceState(parent, child);
        if (parcelable == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)parcelable, (String)"super.onSaveInstanceStat\u2026nt, child) ?: return null");
        Parcelable state = parcelable;
        return (Parcelable)new SavedState(state, this.mState);
    }

    public void onRestoreInstanceState(@NotNull CoordinatorLayout parent, @NotNull V child, @NotNull Parcelable state) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(parent, child, ss.getSuperState());
        this.lastStableState = this.mState = ss.getState$bandyer_android_design_release() == 1 || ss.getState$bandyer_android_design_release() == 2 ? 5 : ss.getState$bandyer_android_design_release();
    }

    public boolean onLayoutChild(@NotNull CoordinatorLayout parent, @NotNull V child, int layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(child, (String)"child");
        if (ViewCompat.getFitsSystemWindows((View)((View)parent)) && !ViewCompat.getFitsSystemWindows(child)) {
            child.setFitsSystemWindows(true);
        }
        if (!(child instanceof BottomSheetLayoutContent)) {
            return false;
        }
        int savedTop = ((BottomSheetLayoutContent)((Object)child)).getTop();
        parent.onLayoutChild(child, layoutDirection);
        this.mParentHeight = parent.getHeight();
        this.mMinOffset = Math.max(0, this.getMParentHeight() - ((BottomSheetLayoutContent)((Object)child)).getHeight());
        this.mMaxOffset = Math.max(this.getMParentHeight() - this.peekHeight, this.mMinOffset);
        this.mAnchorPoint = this.getMParentHeight() - this.anchorOffset;
        switch (this.mState) {
            case 3: {
                ViewCompat.offsetTopAndBottom(child, (int)this.mAnchorPoint);
                break;
            }
            case 4: {
                ViewCompat.offsetTopAndBottom(child, (int)this.mMinOffset);
                break;
            }
            case 6: {
                ViewCompat.offsetTopAndBottom(child, (int)this.getMParentHeight());
                break;
            }
            case 5: {
                ViewCompat.offsetTopAndBottom(child, (int)this.mMaxOffset);
                break;
            }
            case 1: 
            case 2: {
                ViewCompat.offsetTopAndBottom(child, (int)(savedTop - ((BottomSheetLayoutContent)((Object)child)).getTop()));
                break;
            }
        }
        this.notifyOnDrawn((View)child);
        if (this.mViewDragHelper == null) {
            this.mViewDragHelper = ViewDragHelper.create((ViewGroup)((ViewGroup)parent), (ViewDragHelper.Callback)this.mDragCallback);
        }
        this.mViewRef = new WeakReference<V>(child);
        this.mNestedScrollingChildRef = new WeakReference<View>(this.findScrollingChild((View)child));
        return true;
    }

    private final boolean isVisible(View view) {
        return view != null && view.isShown() && this.getMParentHeight() > view.getTop();
    }

    private final void notifyOnDrawn(View child) {
        float slideOffset = child.getTop() > this.mMaxOffset ? (float)(this.mMaxOffset - child.getTop()) / (float)this.peekHeight : (float)(this.mMaxOffset - child.getTop()) / (float)(this.mMaxOffset - this.mMinOffset);
        Context context = child.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"child.context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"child.context.resources");
        int currentOrientation = resources.getConfiguration().orientation;
        if (this.slideOffset != slideOffset || this.orientation != currentOrientation) {
            this.slideOffset = slideOffset;
            this.orientation = currentOrientation;
            Vector<BottomSheetCallback> vector = this.mCallback;
            if (vector != null) {
                Iterable $this$forEach$iv = vector;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BottomSheetCallback it = (BottomSheetCallback)element$iv;
                    boolean bl = false;
                    View view = child;
                    if (!(view instanceof View)) {
                        view = null;
                    }
                    if (view == null) {
                        continue;
                    }
                    View bottomSheet = view;
                    it.onDrawn(bottomSheet, this.mState, slideOffset);
                }
            }
        }
    }

    public final float getStableStateSlideOffset(int state) {
        float f;
        switch (state) {
            case 3: {
                f = (float)(this.mMaxOffset - this.mAnchorPoint) / (float)(this.mMaxOffset - this.mMinOffset);
                break;
            }
            case 4: {
                f = 1.0f;
                break;
            }
            default: {
                f = 0.0f;
            }
        }
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onInterceptTouchEvent(@NotNull CoordinatorLayout parent, @NotNull V child, @NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BandyerBottomSheetBehaviour bandyerBottomSheetBehaviour = this;
        boolean bl = false;
        try {
            View scroll;
            Result.Companion companion = Result.Companion;
            BandyerBottomSheetBehaviour $this$runCatching = bandyerBottomSheetBehaviour;
            boolean bl2 = false;
            if ($this$runCatching.disableDragging) return false;
            if (event.getPointerCount() > 1) {
                return false;
            }
            int action = event.getActionMasked();
            if (!$this$runCatching.isVisible((View)child)) {
                $this$runCatching.mIgnoreEvents = true;
                return false;
            }
            if (action == 0) {
                $this$runCatching.reset();
            }
            if (child instanceof BottomSheetLayoutContent) {
                $this$runCatching.mViewClickedTop = ((BottomSheetLayoutContent)((Object)child)).getTop();
            }
            if ($this$runCatching.mVelocityTracker == null) {
                $this$runCatching.mVelocityTracker = VelocityTracker.obtain();
            }
            VelocityTracker velocityTracker = $this$runCatching.mVelocityTracker;
            Intrinsics.checkNotNull((Object)velocityTracker);
            velocityTracker.addMovement(event);
            switch (action) {
                case 1: 
                case 3: {
                    $this$runCatching.mTouchingScrollingChild = false;
                    $this$runCatching.mActivePointerId = -1;
                    if (!$this$runCatching.mIgnoreEvents) break;
                    $this$runCatching.mIgnoreEvents = false;
                    return false;
                }
                case 0: {
                    View view;
                    $this$runCatching.mInitialY = (int)event.getY();
                    if ($this$runCatching.mNestedScrollingChildRef != null) {
                        WeakReference<View> weakReference = $this$runCatching.mNestedScrollingChildRef;
                        Intrinsics.checkNotNull(weakReference);
                        view = (View)weakReference.get();
                    } else {
                        view = scroll = null;
                    }
                    if (scroll != null && $this$runCatching.isVisible((View)child)) {
                        $this$runCatching.mActivePointerId = event.getPointerId(event.getActionIndex());
                        $this$runCatching.mTouchingScrollingChild = true;
                    }
                    $this$runCatching.mIgnoreEvents = $this$runCatching.mActivePointerId == -1 && !$this$runCatching.isVisible((View)child);
                }
            }
            ViewDragHelper viewDragHelper = $this$runCatching.mViewDragHelper;
            Intrinsics.checkNotNull((Object)viewDragHelper);
            if (viewDragHelper.getCapturedView() != null) {
                ViewDragHelper viewDragHelper2 = $this$runCatching.mViewDragHelper;
                Intrinsics.checkNotNull((Object)viewDragHelper2);
                if (!(viewDragHelper2.getCapturedView() instanceof BottomSheetLayoutContent)) {
                    return false;
                }
            }
            if (!$this$runCatching.mIgnoreEvents && $this$runCatching.mViewDragHelper != null) {
                ViewDragHelper viewDragHelper3 = $this$runCatching.mViewDragHelper;
                Intrinsics.checkNotNull((Object)viewDragHelper3);
                if (viewDragHelper3.shouldInterceptTouchEvent(event)) {
                    return true;
                }
            }
            WeakReference<View> weakReference = $this$runCatching.mNestedScrollingChildRef;
            scroll = weakReference != null ? (View)weakReference.get() : null;
            if (action != 2) return false;
            if (scroll == null) return false;
            if ($this$runCatching.mIgnoreEvents) return false;
            if ($this$runCatching.mState == 1) return false;
            if ($this$runCatching.isVisible((View)child)) return false;
            if ($this$runCatching.mViewDragHelper == null) return false;
            float f = (float)$this$runCatching.mInitialY - event.getY();
            boolean bl3 = false;
            float f2 = Math.abs(f);
            ViewDragHelper viewDragHelper4 = $this$runCatching.mViewDragHelper;
            Intrinsics.checkNotNull((Object)viewDragHelper4);
            if (!(f2 > (float)viewDragHelper4.getTouchSlop())) return false;
            return true;
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return false;
        }
    }

    public boolean onTouchEvent(@NotNull CoordinatorLayout parent, @NotNull V child, @NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BandyerBottomSheetBehaviour bandyerBottomSheetBehaviour = this;
        boolean bl = false;
        try {
            Result.Companion companion = Result.Companion;
            BandyerBottomSheetBehaviour $this$runCatching = bandyerBottomSheetBehaviour;
            boolean bl2 = false;
            $this$runCatching.clickGestureDetector.onTouchEvent(event);
            if ($this$runCatching.disableDragging || event.getPointerCount() > 1) {
                return false;
            }
            int action = event.getActionMasked();
            ViewDragHelper viewDragHelper = $this$runCatching.mViewDragHelper;
            if ((viewDragHelper != null ? viewDragHelper.getCapturedView() : null) instanceof BottomSheetLayoutContent) {
                ViewDragHelper viewDragHelper2 = $this$runCatching.mViewDragHelper;
                Intrinsics.checkNotNull((Object)viewDragHelper2);
                viewDragHelper2.processTouchEvent(event);
            }
            if (!$this$runCatching.isVisible((View)child)) {
                return false;
            }
            if ($this$runCatching.mState == 1 && action == 0) {
                return true;
            }
            if (child instanceof BottomSheetLayoutContent) {
                $this$runCatching.mViewClickedTop = ((BottomSheetLayoutContent)((Object)child)).getTop();
            }
            if (action == 0) {
                $this$runCatching.reset();
            }
            if ($this$runCatching.mVelocityTracker == null) {
                $this$runCatching.mVelocityTracker = VelocityTracker.obtain();
            }
            VelocityTracker velocityTracker = $this$runCatching.mVelocityTracker;
            Intrinsics.checkNotNull((Object)velocityTracker);
            velocityTracker.addMovement(event);
            if (action == 2 && !$this$runCatching.mIgnoreEvents) {
                float f = Math.abs((float)$this$runCatching.mInitialY - event.getY());
                ViewDragHelper viewDragHelper3 = $this$runCatching.mViewDragHelper;
                Intrinsics.checkNotNull((Object)viewDragHelper3);
                if (f > (float)viewDragHelper3.getTouchSlop() && child instanceof BottomSheetLayoutContent) {
                    ViewDragHelper viewDragHelper4 = $this$runCatching.mViewDragHelper;
                    Intrinsics.checkNotNull((Object)viewDragHelper4);
                    viewDragHelper4.captureChildView(child, event.getPointerId(event.getActionIndex()));
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl3 = false;
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return false;
        }
    }

    public boolean onStartNestedScroll(@NotNull CoordinatorLayout coordinatorLayout, @NotNull V child, @NotNull View directTargetChild, @NotNull View target, int nestedScrollAxes, int type) {
        Intrinsics.checkNotNullParameter((Object)coordinatorLayout, (String)"coordinatorLayout");
        Intrinsics.checkNotNullParameter(child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)directTargetChild, (String)"directTargetChild");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (this.disableDragging) {
            return false;
        }
        this.mNestedScrolled = false;
        return (nestedScrollAxes & 2) != 0;
    }

    public void onNestedPreScroll(@NotNull CoordinatorLayout coordinatorLayout, @NotNull V child, @NotNull View target, int dx, int dy, @NotNull int[] consumed, int type) {
        View scrollingChild;
        Intrinsics.checkNotNullParameter((Object)coordinatorLayout, (String)"coordinatorLayout");
        Intrinsics.checkNotNullParameter(child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)consumed, (String)"consumed");
        WeakReference<View> weakReference = this.mNestedScrollingChildRef;
        Object object = scrollingChild = weakReference != null ? (View)weakReference.get() : null;
        if (Intrinsics.areEqual((Object)target, (Object)scrollingChild) ^ true) {
            return;
        }
        this.mScrollVelocityTracker.recordScroll(dy);
        int currentTop = child.getTop();
        int newTop = currentTop - dy;
        if (!this.skipAnchor && this.lastStableState == 5 && newTop < this.mAnchorPoint || this.lastStableState == 4 && newTop > this.mAnchorPoint) {
            consumed[1] = dy;
            ViewCompat.offsetTopAndBottom(child, (int)(this.mAnchorPoint - currentTop));
            this.dispatchOnSlide(child.getTop());
            this.mNestedScrolled = true;
            return;
        }
        if (dy > 0) {
            if (newTop <= this.mMinOffset) {
                consumed[1] = currentTop - this.mMinOffset;
                ViewCompat.offsetTopAndBottom(child, (int)(-consumed[1]));
                this.setStateInternal(4);
            } else {
                consumed[1] = dy;
                ViewCompat.offsetTopAndBottom(child, (int)(-dy));
                this.setStateInternal(1);
            }
        } else if (dy < 0 && !target.canScrollVertically(-1)) {
            if (newTop <= this.mMaxOffset || this.isHideable) {
                consumed[1] = dy;
                ViewCompat.offsetTopAndBottom(child, (int)(-dy));
                this.setStateInternal(1);
            } else {
                consumed[1] = currentTop - this.mMaxOffset;
                ViewCompat.offsetTopAndBottom(child, (int)(-consumed[1]));
                if (!this.skipCollapsed) {
                    this.setStateInternal(5);
                } else if (!this.skipAnchor) {
                    this.setStateInternal(3);
                } else {
                    this.setStateInternal(this.lastStableState);
                }
            }
        }
        this.dispatchOnSlide(child.getTop());
        this.mNestedScrolled = true;
    }

    public void onStopNestedScroll(@NotNull CoordinatorLayout coordinatorLayout, @NotNull V child, @NotNull View target, int type) {
        block25: {
            block24: {
                Intrinsics.checkNotNullParameter((Object)coordinatorLayout, (String)"coordinatorLayout");
                Intrinsics.checkNotNullParameter(child, (String)"child");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                if (child.getTop() == this.mMinOffset) {
                    return;
                }
                if (this.mNestedScrollingChildRef == null) break block24;
                WeakReference<View> weakReference = this.mNestedScrollingChildRef;
                if (!(Intrinsics.areEqual((Object)target, (Object)(weakReference != null ? (View)weakReference.get() : null)) ^ true) && this.mNestedScrolled) break block25;
            }
            return;
        }
        int top = child.getTop();
        int targetState = this.lastStableState;
        float scrollVelocity = this.mScrollVelocityTracker.getScrollVelocity();
        this.mScrollVelocityTracker.clear();
        if (scrollVelocity > this.mMinimumVelocity) {
            if (!this.skipAnchor && this.lastStableState == 5) {
                top = this.mAnchorPoint;
                targetState = 3;
            } else {
                top = this.mMinOffset;
                targetState = 4;
            }
        } else if (scrollVelocity < -this.mMinimumVelocity) {
            if (!this.skipAnchor && this.lastStableState == 4) {
                top = this.mAnchorPoint;
                targetState = 3;
            } else if (!this.skipCollapsed) {
                top = this.mMaxOffset;
                targetState = 5;
            }
        } else if (this.skipAnchor) {
            if (!this.skipCollapsed && top < this.mMinOffset) {
                top = this.mMaxOffset;
                targetState = 5;
            } else {
                top = this.mMinOffset;
                targetState = 4;
            }
        } else if ((double)top > (double)this.mAnchorPoint * 1.25) {
            top = this.mMaxOffset;
            targetState = 5;
        } else if ((double)top < (double)this.mAnchorPoint * 0.5) {
            top = this.mMinOffset;
            targetState = 4;
        } else {
            top = this.mAnchorPoint;
            targetState = 3;
        }
        ViewDragHelper viewDragHelper = this.mViewDragHelper;
        Intrinsics.checkNotNull((Object)viewDragHelper);
        if (viewDragHelper.smoothSlideViewTo(child, child.getLeft(), top)) {
            this.setStateInternal(2);
            ViewCompat.postOnAnimation(child, (Runnable)new SettleRunnable((View)child, targetState));
        } else {
            this.setStateInternal(targetState);
        }
        this.mNestedScrolled = false;
    }

    public boolean onNestedPreFling(@NotNull CoordinatorLayout coordinatorLayout, @NotNull V child, @NotNull View target, float velocityX, float velocityY) {
        Intrinsics.checkNotNullParameter((Object)coordinatorLayout, (String)"coordinatorLayout");
        Intrinsics.checkNotNullParameter(child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (this.disableDragging) {
            return false;
        }
        WeakReference<View> weakReference = this.mNestedScrollingChildRef;
        return target == (weakReference != null ? (View)weakReference.get() : null) && (this.mState != 4 || super.onNestedPreFling(coordinatorLayout, child, target, velocityX, velocityY));
    }

    public final void addBottomSheetCallback(@NotNull BottomSheetCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (this.mCallback == null) {
            this.mCallback = new Vector();
        }
        Vector<BottomSheetCallback> vector = this.mCallback;
        Intrinsics.checkNotNull(vector);
        vector.add(callback);
    }

    public final void removeBottomSheetCallbacks() {
        block0: {
            Vector<BottomSheetCallback> vector = this.mCallback;
            if (vector == null) break block0;
            vector.removeAllElements();
        }
    }

    public final void removeBottomSheetCallback(@NotNull BottomSheetCallback callback) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            Vector<BottomSheetCallback> vector = this.mCallback;
            if (vector == null) break block0;
            vector.remove(callback);
        }
    }

    private final void setStateInternal(int state) {
        block2: {
            if (this.mState == state) {
                return;
            }
            if (state == 5 || state == 4 || state == 3 || this.isHideable && state == 6) {
                this.lastStableState = state;
            }
            this.mState = state;
            View view = this.mViewRef;
            if (view == null || (view = (View)view.get()) == null) break block2;
            View view2 = view;
            boolean bl = false;
            boolean bl2 = false;
            View it = view2;
            boolean bl3 = false;
            View view3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"it");
            this.notifyStateChangedToListeners(view3, state);
        }
    }

    private final void notifyStateChangedToListeners(View bottomSheet, int newState) {
        Vector<BottomSheetCallback> vector = this.mCallback;
        if (vector != null) {
            Iterable $this$forEach$iv = vector;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BottomSheetCallback bottomSheetCallback = (BottomSheetCallback)element$iv;
                boolean bl = false;
                bottomSheetCallback.onStateChanged(bottomSheet, newState);
            }
        }
    }

    private final void notifyOnSlideToListeners(View bottomSheet, float slideOffset) {
        Vector<BottomSheetCallback> vector = this.mCallback;
        if (vector != null) {
            Iterable $this$forEach$iv = vector;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BottomSheetCallback bottomSheetCallback = (BottomSheetCallback)element$iv;
                boolean bl = false;
                bottomSheetCallback.onSlide(bottomSheet, slideOffset);
            }
        }
    }

    private final void reset() {
        block0: {
            this.mActivePointerId = -1;
            VelocityTracker velocityTracker = this.mVelocityTracker;
            if (velocityTracker == null) break block0;
            VelocityTracker velocityTracker2 = velocityTracker;
            boolean bl = false;
            boolean bl2 = false;
            VelocityTracker it = velocityTracker2;
            boolean bl3 = false;
            it.recycle();
            this.mVelocityTracker = null;
        }
    }

    private final boolean shouldHide(View child, float yvel) {
        if (this.skipCollapsed) {
            return true;
        }
        if (child.getTop() < this.mMaxOffset) {
            return false;
        }
        float newTop = (float)child.getTop() + yvel * 0.1f;
        return Math.abs(newTop - (float)this.mMaxOffset) / (float)this.peekHeight > 0.5f;
    }

    private final View findScrollingChild(View view) {
        if (view instanceof NestedScrollingChild) {
            return view;
        }
        if (view instanceof ViewGroup) {
            int count = ((ViewGroup)view).getChildCount();
            for (int i = 0; i < count; ++i) {
                View view2 = ((ViewGroup)view).getChildAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view.getChildAt(i)");
                View scrollingChild = this.findScrollingChild(view2);
                if (scrollingChild == null) continue;
                return scrollingChild;
            }
        }
        return null;
    }

    private final void dispatchOnSlide(int top) {
        block2: {
            View view = this.mViewRef;
            if (view == null || (view = (View)view.get()) == null) break block2;
            View view2 = view;
            boolean bl = false;
            boolean bl2 = false;
            View it = view2;
            boolean bl3 = false;
            if (top > this.mMaxOffset) {
                View view3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"it");
                this.notifyOnSlideToListeners(view3, (float)(this.mMaxOffset - top) / (float)this.peekHeight);
            } else {
                View view4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"it");
                this.notifyOnSlideToListeners(view4, (float)(this.mMaxOffset - top) / (float)(this.mMaxOffset - this.mMinOffset));
            }
        }
    }

    public BandyerBottomSheetBehaviour(@NotNull Context context, @Nullable AttributeSet attrs) {
        ViewConfiguration configuration;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.anchorOffset = -1;
        this.skipAnchor = true;
        this.mState = 6;
        this.lastStableState = 6;
        this.mScrollVelocityTracker = new ScrollVelocityTracker();
        this.mViewClickedTop = -1;
        this.orientation = 1;
        this.mDragCallback = new ViewDragHelper.Callback(this){
            final /* synthetic */ BandyerBottomSheetBehaviour this$0;

            public boolean tryCaptureView(@NotNull View child, int pointerId) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                if (BandyerBottomSheetBehaviour.access$getMState$p(this.this$0) == 1 || BandyerBottomSheetBehaviour.access$getMTouchingScrollingChild$p(this.this$0)) {
                    return true;
                }
                if (BandyerBottomSheetBehaviour.access$getMState$p(this.this$0) == 4 && BandyerBottomSheetBehaviour.access$getMActivePointerId$p(this.this$0) == pointerId) {
                    WeakReference weakReference = BandyerBottomSheetBehaviour.access$getMNestedScrollingChildRef$p(this.this$0);
                    if (weakReference != null && (weakReference = (View)weakReference.get()) != null) {
                        if (weakReference.canScrollVertically(-1)) {
                            return true;
                        }
                    }
                }
                WeakReference weakReference = BandyerBottomSheetBehaviour.access$getMViewRef$p(this.this$0);
                return Intrinsics.areEqual((Object)(weakReference != null ? (View)weakReference.get() : null), (Object)child);
            }

            public void onViewPositionChanged(@NotNull View changedView, int left, int top, int dx, int dy) {
                Intrinsics.checkNotNullParameter((Object)changedView, (String)"changedView");
                BandyerBottomSheetBehaviour.access$dispatchOnSlide(this.this$0, top);
            }

            public void onViewDragStateChanged(int state) {
                if (!this.this$0.getDisableDragging() && state == 1) {
                    BandyerBottomSheetBehaviour.access$setStateInternal(this.this$0, 1);
                }
            }

            public void onViewReleased(@NotNull View releasedChild, float xvel, float yvel) {
                Intrinsics.checkNotNullParameter((Object)releasedChild, (String)"releasedChild");
                if (this.this$0.getDisableDragging()) {
                    return;
                }
                int top = releasedChild.getTop();
                int targetState = 0;
                if (yvel < (float)300 && yvel != 0.0f) {
                    if (!this.this$0.getSkipAnchor() && yvel > (float)-4000 && this.this$0.getLastStableState() == 5) {
                        top = BandyerBottomSheetBehaviour.access$getMAnchorPoint$p(this.this$0);
                        targetState = 3;
                    } else {
                        top = BandyerBottomSheetBehaviour.access$getMMinOffset$p(this.this$0);
                        targetState = 4;
                    }
                } else if (yvel > (float)300 && yvel != 0.0f) {
                    if (!this.this$0.getSkipAnchor() && yvel < (float)10000 && this.this$0.getLastStableState() == 4) {
                        top = BandyerBottomSheetBehaviour.access$getMAnchorPoint$p(this.this$0);
                        targetState = 3;
                    } else if (!this.this$0.getSkipCollapsed()) {
                        top = BandyerBottomSheetBehaviour.access$getMMaxOffset$p(this.this$0);
                        targetState = 5;
                    } else if (!this.this$0.getSkipAnchor()) {
                        top = BandyerBottomSheetBehaviour.access$getMAnchorPoint$p(this.this$0);
                        targetState = 3;
                    } else if (this.this$0.isHideable() && BandyerBottomSheetBehaviour.access$shouldHide(this.this$0, releasedChild, yvel)) {
                        top = BandyerBottomSheetBehaviour.access$getMParentHeight$p(this.this$0);
                        targetState = 6;
                    } else {
                        int n;
                        switch (this.this$0.getLastStableState()) {
                            case 5: {
                                n = BandyerBottomSheetBehaviour.access$getMMaxOffset$p(this.this$0);
                                break;
                            }
                            case 3: {
                                n = BandyerBottomSheetBehaviour.access$getMAnchorPoint$p(this.this$0);
                                break;
                            }
                            default: {
                                n = BandyerBottomSheetBehaviour.access$getMMinOffset$p(this.this$0);
                            }
                        }
                        top = n;
                        targetState = this.this$0.getLastStableState() == 6 ? 4 : this.this$0.getLastStableState();
                    }
                } else if (Math.abs(top - BandyerBottomSheetBehaviour.access$getMMinOffset$p(this.this$0)) < Math.abs(top - BandyerBottomSheetBehaviour.access$getMMaxOffset$p(this.this$0))) {
                    top = BandyerBottomSheetBehaviour.access$getMMinOffset$p(this.this$0);
                    targetState = 4;
                } else if (!this.this$0.getSkipCollapsed()) {
                    top = BandyerBottomSheetBehaviour.access$getMMaxOffset$p(this.this$0);
                    targetState = 5;
                } else if (this.this$0.isHideable() && BandyerBottomSheetBehaviour.access$shouldHide(this.this$0, releasedChild, yvel)) {
                    top = BandyerBottomSheetBehaviour.access$getMParentHeight$p(this.this$0);
                    targetState = 6;
                } else {
                    int n;
                    switch (this.this$0.getLastStableState()) {
                        case 5: {
                            n = BandyerBottomSheetBehaviour.access$getMMaxOffset$p(this.this$0);
                            break;
                        }
                        case 3: {
                            n = BandyerBottomSheetBehaviour.access$getMAnchorPoint$p(this.this$0);
                            break;
                        }
                        default: {
                            n = BandyerBottomSheetBehaviour.access$getMMinOffset$p(this.this$0);
                        }
                    }
                    top = n;
                    targetState = this.this$0.getLastStableState() == 6 ? 4 : this.this$0.getLastStableState();
                }
                ViewDragHelper viewDragHelper = BandyerBottomSheetBehaviour.access$getMViewDragHelper$p(this.this$0);
                Intrinsics.checkNotNull((Object)viewDragHelper);
                if (viewDragHelper.settleCapturedViewAt(releasedChild.getLeft(), top)) {
                    BandyerBottomSheetBehaviour.access$setStateInternal(this.this$0, 2);
                    ViewCompat.postOnAnimation((View)releasedChild, (Runnable)this.this$0.new SettleRunnable(releasedChild, targetState));
                } else {
                    BandyerBottomSheetBehaviour.access$setStateInternal(this.this$0, targetState);
                }
            }

            public int clampViewPositionVertical(@NotNull View child, int top, int dy) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                return this.constrain(top, BandyerBottomSheetBehaviour.access$getMMinOffset$p(this.this$0), this.this$0.isHideable() ? BandyerBottomSheetBehaviour.access$getMParentHeight$p(this.this$0) : BandyerBottomSheetBehaviour.access$getMMaxOffset$p(this.this$0));
            }

            public final int constrain(int amount, int low, int high) {
                return amount < low ? low : (amount > high ? high : amount);
            }

            public int clampViewPositionHorizontal(@NotNull View child, int left, int dx) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                return child.getLeft();
            }

            public int getViewVerticalDragRange(@NotNull View child) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                return this.this$0.isHideable() ? BandyerBottomSheetBehaviour.access$getMParentHeight$p(this.this$0) - BandyerBottomSheetBehaviour.access$getMMinOffset$p(this.this$0) : BandyerBottomSheetBehaviour.access$getMMaxOffset$p(this.this$0) - BandyerBottomSheetBehaviour.access$getMMinOffset$p(this.this$0);
            }
            {
                this.this$0 = this$0;
            }
        };
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BottomSheetBehavior_Layout);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026ttomSheetBehavior_Layout)");
        TypedArray a = typedArray;
        this.setPeekHeight(a.getDimensionPixelSize(R.styleable.BottomSheetBehavior_Layout_behavior_peekHeight, 0));
        this.isHideable = a.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_hideable, false);
        a.recycle();
        TypedArray typedArray2 = context.obtainStyledAttributes(attrs, R.styleable.BandyerBottomSheetBehavior);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray2, (String)"context.obtainStyledAttr\u2026ndyerBottomSheetBehavior)");
        a = typedArray2;
        if (attrs != null) {
            this.mAnchorPoint = (int)a.getDimension(R.styleable.BandyerBottomSheetBehavior_bandyer_anchorPoint, -1.0f);
            this.skipAnchor = this.mAnchorPoint < 0;
            this.mState = a.getInt(R.styleable.BandyerBottomSheetBehavior_bandyer_defaultStatus, 5);
        }
        a.recycle();
        ViewConfiguration viewConfiguration = configuration = ViewConfiguration.get((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)viewConfiguration, (String)"configuration");
        this.mMinimumVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.clickGestureDetector = new GestureDetector(context, new GestureDetector.OnGestureListener(this){
            final /* synthetic */ BandyerBottomSheetBehaviour this$0;

            public void onShowPress(@Nullable MotionEvent e) {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean onSingleTapUp(@NotNull MotionEvent e) {
                ViewParent viewParent;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getPointerCount() != 1) return false;
                WeakReference weakReference = BandyerBottomSheetBehaviour.access$getMViewRef$p(this.this$0);
                if (!((weakReference != null && (weakReference = (View)weakReference.get()) != null ? weakReference.getParent() : (viewParent = null)) instanceof ViewGroup)) {
                    viewParent = null;
                }
                ViewGroup viewGroup = (ViewGroup)viewParent;
                if (viewGroup == null) return false;
                if (!viewGroup.performClick()) return false;
                return true;
            }

            public boolean onDown(@Nullable MotionEvent e) {
                return false;
            }

            public boolean onFling(@Nullable MotionEvent e1, @Nullable MotionEvent e2, float velocityX, float velocityY) {
                return false;
            }

            public boolean onScroll(@Nullable MotionEvent e1, @Nullable MotionEvent e2, float distanceX, float distanceY) {
                return false;
            }

            public void onLongPress(@Nullable MotionEvent e) {
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public static final /* synthetic */ void access$setMViewDragHelper$p(BandyerBottomSheetBehaviour $this, ViewDragHelper viewDragHelper) {
        $this.mViewDragHelper = viewDragHelper;
    }

    public static final /* synthetic */ void access$setMState$p(BandyerBottomSheetBehaviour $this, int n) {
        $this.mState = n;
    }

    public static final /* synthetic */ boolean access$getMTouchingScrollingChild$p(BandyerBottomSheetBehaviour $this) {
        return $this.mTouchingScrollingChild;
    }

    public static final /* synthetic */ void access$setMTouchingScrollingChild$p(BandyerBottomSheetBehaviour $this, boolean bl) {
        $this.mTouchingScrollingChild = bl;
    }

    public static final /* synthetic */ int access$getMActivePointerId$p(BandyerBottomSheetBehaviour $this) {
        return $this.mActivePointerId;
    }

    public static final /* synthetic */ void access$setMActivePointerId$p(BandyerBottomSheetBehaviour $this, int n) {
        $this.mActivePointerId = n;
    }

    public static final /* synthetic */ WeakReference access$getMNestedScrollingChildRef$p(BandyerBottomSheetBehaviour $this) {
        return $this.mNestedScrollingChildRef;
    }

    public static final /* synthetic */ void access$setMNestedScrollingChildRef$p(BandyerBottomSheetBehaviour $this, WeakReference weakReference) {
        $this.mNestedScrollingChildRef = weakReference;
    }

    public static final /* synthetic */ WeakReference access$getMViewRef$p(BandyerBottomSheetBehaviour $this) {
        return $this.mViewRef;
    }

    public static final /* synthetic */ void access$setMViewRef$p(BandyerBottomSheetBehaviour $this, WeakReference weakReference) {
        $this.mViewRef = weakReference;
    }

    public static final /* synthetic */ void access$dispatchOnSlide(BandyerBottomSheetBehaviour $this, int top) {
        $this.dispatchOnSlide(top);
    }

    public static final /* synthetic */ int access$getMAnchorPoint$p(BandyerBottomSheetBehaviour $this) {
        return $this.mAnchorPoint;
    }

    public static final /* synthetic */ void access$setMAnchorPoint$p(BandyerBottomSheetBehaviour $this, int n) {
        $this.mAnchorPoint = n;
    }

    public static final /* synthetic */ int access$getMMinOffset$p(BandyerBottomSheetBehaviour $this) {
        return $this.mMinOffset;
    }

    public static final /* synthetic */ void access$setMMinOffset$p(BandyerBottomSheetBehaviour $this, int n) {
        $this.mMinOffset = n;
    }

    public static final /* synthetic */ int access$getMMaxOffset$p(BandyerBottomSheetBehaviour $this) {
        return $this.mMaxOffset;
    }

    public static final /* synthetic */ void access$setMMaxOffset$p(BandyerBottomSheetBehaviour $this, int n) {
        $this.mMaxOffset = n;
    }

    public static final /* synthetic */ boolean access$shouldHide(BandyerBottomSheetBehaviour $this, View child, float yvel) {
        return $this.shouldHide(child, yvel);
    }

    public static final /* synthetic */ int access$getMParentHeight$p(BandyerBottomSheetBehaviour $this) {
        return $this.getMParentHeight();
    }

    public static final /* synthetic */ void access$setMParentHeight$p(BandyerBottomSheetBehaviour $this, int n) {
        $this.mParentHeight = n;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH&J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH&J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\bH&\u00a8\u0006\u000e"}, d2={"Lcom/bandyer/sdk_design/bottom_sheet/behaviours/BandyerBottomSheetBehaviour$BottomSheetCallback;", "", "()V", "onDrawn", "", "bottomSheet", "Landroid/view/View;", "state", "", "slideOffset", "", "onSlide", "onStateChanged", "newState", "bandyer-android-design_release"})
    public static abstract class BottomSheetCallback {
        public abstract void onStateChanged(@NotNull View var1, int var2);

        public abstract void onSlide(@NotNull View var1, float var2);

        public abstract void onDrawn(@NotNull View var1, int var2, @FloatRange(from=0.0, to=1.0) float var3);
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/bandyer/sdk_design/bottom_sheet/behaviours/BandyerBottomSheetBehaviour$State;", "", "bandyer-android-design_release"})
    public static @interface State {
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/bandyer/sdk_design/bottom_sheet/behaviours/BandyerBottomSheetBehaviour$ScrollVelocityTracker;", "", "(Lcom/bandyer/sdk_design/bottom_sheet/behaviours/BandyerBottomSheetBehaviour;)V", "mPreviousScrollTime", "", "<set-?>", "", "scrollVelocity", "getScrollVelocity", "()F", "clear", "", "recordScroll", "dy", "", "bandyer-android-design_release"})
    private final class ScrollVelocityTracker {
        private long mPreviousScrollTime;
        private float scrollVelocity;

        public final float getScrollVelocity() {
            return this.scrollVelocity;
        }

        public final void recordScroll(int dy) {
            long now = System.currentTimeMillis();
            if (this.mPreviousScrollTime != 0L) {
                long elapsed = now - this.mPreviousScrollTime;
                this.scrollVelocity = (float)dy / (float)elapsed * (float)1000;
            }
            this.mPreviousScrollTime = now;
        }

        public final void clear() {
            this.mPreviousScrollTime = 0L;
            this.scrollVelocity = 0.0f;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/bandyer/sdk_design/bottom_sheet/behaviours/BandyerBottomSheetBehaviour$SettleRunnable;", "Ljava/lang/Runnable;", "mView", "Landroid/view/View;", "mTargetState", "", "(Lcom/bandyer/sdk_design/bottom_sheet/behaviours/BandyerBottomSheetBehaviour;Landroid/view/View;I)V", "run", "", "bandyer-android-design_release"})
    private final class SettleRunnable
    implements Runnable {
        private final View mView;
        private final int mTargetState;

        @Override
        public void run() {
            ViewDragHelper viewDragHelper = BandyerBottomSheetBehaviour.this.mViewDragHelper;
            Intrinsics.checkNotNull((Object)viewDragHelper);
            if (viewDragHelper.continueSettling(true)) {
                ViewCompat.postOnAnimation((View)this.mView, (Runnable)this);
            } else {
                if (BandyerBottomSheetBehaviour.this.mState != this.mTargetState) {
                    BandyerBottomSheetBehaviour.this.setStateInternal(this.mTargetState);
                }
                BandyerBottomSheetBehaviour.this.notifyOnDrawn(this.mView);
            }
        }

        public SettleRunnable(View mView, int mTargetState) {
            Intrinsics.checkNotNullParameter((Object)mView, (String)"mView");
            this.mView = mView;
            this.mTargetState = mTargetState;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\bH\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/bandyer/sdk_design/bottom_sheet/behaviours/BandyerBottomSheetBehaviour$SavedState;", "Landroid/view/View$BaseSavedState;", "source", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "superState", "Landroid/os/Parcelable;", "state", "", "(Landroid/os/Parcelable;I)V", "getState$bandyer_android_design_release$annotations", "()V", "getState$bandyer_android_design_release", "()I", "writeToParcel", "", "out", "flags", "Companion", "bandyer-android-design_release"})
    public static final class SavedState
    extends View.BaseSavedState {
        private final int state;
        @JvmField
        @NotNull
        public static final Parcelable.Creator<SavedState> CREATOR;
        public static final Companion Companion;

        public static /* synthetic */ void getState$bandyer_android_design_release$annotations() {
        }

        public final int getState$bandyer_android_design_release() {
            return this.state;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            super.writeToParcel(out, flags);
            out.writeInt(this.state);
        }

        public SavedState(@NotNull Parcel source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            super(source);
            this.state = source.readInt();
        }

        public SavedState(@NotNull Parcelable superState, int state) {
            Intrinsics.checkNotNullParameter((Object)superState, (String)"superState");
            super(superState);
            this.state = state;
        }

        static {
            Companion = new Companion(null);
            CREATOR = (Parcelable.Creator)new Parcelable.Creator<SavedState>(){

                @NotNull
                public SavedState createFromParcel(@NotNull Parcel source) {
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    return new SavedState(source);
                }

                @NotNull
                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/bandyer/sdk_design/bottom_sheet/behaviours/BandyerBottomSheetBehaviour$SavedState$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/bandyer/sdk_design/bottom_sheet/behaviours/BandyerBottomSheetBehaviour$SavedState;", "bandyer-android-design_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0011\"\b\b\u0001\u0010\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u0002H\u0012\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/bandyer/sdk_design/bottom_sheet/behaviours/BandyerBottomSheetBehaviour$Companion;", "", "()V", "HIDE_FRICTION", "", "HIDE_THRESHOLD", "MAX_VELOCITY_SKIP_ANCHOR_STATE", "", "MIN_VELOCITY", "MIN_VELOCITY_SKIP_ANCHOR_STATE", "STATE_ANCHOR_POINT", "STATE_COLLAPSED", "STATE_DRAGGING", "STATE_EXPANDED", "STATE_HIDDEN", "STATE_SETTLING", "from", "Lcom/bandyer/sdk_design/bottom_sheet/behaviours/BandyerBottomSheetBehaviour;", "V", "Landroid/view/View;", "view", "(Landroid/view/View;)Lcom/bandyer/sdk_design/bottom_sheet/behaviours/BandyerBottomSheetBehaviour;", "bandyer-android-design_release"})
    public static final class Companion {
        @NotNull
        public final <V extends View> BandyerBottomSheetBehaviour<V> from(@NotNull V view) {
            Intrinsics.checkNotNullParameter(view, (String)"view");
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            if (!(layoutParams instanceof CoordinatorLayout.LayoutParams)) {
                layoutParams = null;
            }
            CoordinatorLayout.LayoutParams layoutParams2 = (CoordinatorLayout.LayoutParams)layoutParams;
            if (layoutParams2 == null) {
                throw (Throwable)new IllegalArgumentException("The view is not a child of CoordinatorLayout");
            }
            CoordinatorLayout.LayoutParams params = layoutParams2;
            CoordinatorLayout.Behavior behavior = params.getBehavior();
            if (!(behavior instanceof BandyerBottomSheetBehaviour)) {
                behavior = null;
            }
            BandyerBottomSheetBehaviour bandyerBottomSheetBehaviour = (BandyerBottomSheetBehaviour)behavior;
            if (bandyerBottomSheetBehaviour == null) {
                throw (Throwable)new IllegalArgumentException("The view is not associated with BandyerBottomSheetBehaviour");
            }
            return bandyerBottomSheetBehaviour;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

