/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.widget.edittext;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.bambora.nativepayment.utils.CompatHelper;
import com.bambora.nativepayment.widget.CardNumberFormat;
import com.bambora.nativepayment.widget.edittext.CardFormEditText;
import com.bambora.nativepayment.widget.textwatcher.CardNumberTextWatcher;

public class CardNumberEditText
extends CardFormEditText
implements CardNumberTextWatcher.CardTypeListener {
    private static final int MAX_LENGTH = 19;
    private static final String DEFAULT_HINT = "5555 5555 5555 5555";

    public CardNumberEditText(Context context) {
        super(context);
        this.setupView();
    }

    public CardNumberEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupView();
    }

    public CardNumberEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setupView();
    }

    @TargetApi(value=21)
    public CardNumberEditText(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setupView();
    }

    private void setupView() {
        this.addTextChangedListener(new CardNumberTextWatcher(this, this));
    }

    @Override
    public Integer getDefaultMaxLength() {
        return 19;
    }

    @Override
    public String getDefaultHint() {
        return DEFAULT_HINT;
    }

    @Override
    public void onCardTypeChanged(CardNumberFormat cardNumberFormat) {
        Integer iconResId = cardNumberFormat.getIconResId();
        Drawable iconDrawable = iconResId != null ? CompatHelper.getDrawable(this.getContext(), iconResId, null) : null;
        this.setCompoundDrawablesWithIntrinsicBounds(null, null, iconDrawable, null);
        this.setMaxLengthFilter(cardNumberFormat.getMaxInputLength());
    }
}

