/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.widget;

import java.util.List;

public class FormInputHelper {
    public static String clearNonDigits(String input) {
        return input.replaceAll("[^\\d]", "");
    }

    public static String getDeletedChars(CharSequence sequence, int startBefore, int countBefore) {
        StringBuilder deletingChars = new StringBuilder();
        for (int i = startBefore; i < startBefore + countBefore; ++i) {
            deletingChars.append(sequence.charAt(i));
        }
        return deletingChars.toString();
    }

    public static CharSequence formatNumberSequence(String sequence, List<Integer> groupSizes, char groupDelimiter) {
        sequence = FormInputHelper.clearNonDigits(sequence);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < sequence.length() + 1; ++i) {
            if (FormInputHelper.shouldBeDelimiter(i, groupSizes)) {
                stringBuilder.append(String.valueOf(groupDelimiter));
            }
            if (i >= sequence.length()) continue;
            stringBuilder.append(sequence.charAt(i));
        }
        return stringBuilder;
    }

    public static boolean isFormatted(String sequence, char delimiter, List<Integer> groupSizes) {
        int groupIndex = 0;
        if (groupSizes.size() <= 0) {
            return true;
        }
        int delimiterPosition = groupSizes.get(groupIndex);
        for (int i = 0; i < sequence.length(); ++i) {
            if (i == delimiterPosition) {
                if (sequence.charAt(i) != delimiter) {
                    return false;
                }
                if (groupSizes.size() <= groupIndex + 1) continue;
                delimiterPosition += groupSizes.get(++groupIndex) + 1;
                continue;
            }
            if (sequence.charAt(i) != delimiter) continue;
            return false;
        }
        return true;
    }

    public static boolean shouldBeDelimiter(int index, List<Integer> groupSizes) {
        int delimiterPosition = 0;
        for (int i = 0; i < groupSizes.size(); ++i) {
            if (index != (delimiterPosition += groupSizes.get(i).intValue())) continue;
            return true;
        }
        return false;
    }
}

