/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.widget;

import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bambora.nativepayment.R;
import com.bambora.nativepayment.handlers.BNPaymentHandler;
import com.bambora.nativepayment.interfaces.ICardRegistrationCallback;
import com.bambora.nativepayment.models.CardRegistrationFormGuiSetting;
import com.bambora.nativepayment.models.creditcard.CreditCard;
import com.bambora.nativepayment.network.RequestError;
import com.bambora.nativepayment.utils.CompatHelper;
import com.bambora.nativepayment.widget.edittext.CardFormEditText;
import com.bambora.nativepayment.widget.edittext.CardHolderEditText;
import com.bambora.nativepayment.widget.edittext.CardNumberEditText;
import com.bambora.nativepayment.widget.edittext.ExpiryDateEditText;
import io.card.payment.CardIOActivity;
import java.util.HashMap;
import java.util.Map;

public class CardRegistrationFormFragment
extends Fragment
implements CardFormEditText.IOnValidationEventListener,
ICardRegistrationCallback {
    private ICardRegistrationCallback resultListenerForInternal;
    private ICardRegistrationCallback resultListenerForExternal;
    private TextView pageTitle;
    private CardHolderEditText cardHolderEditText;
    private CardNumberEditText cardNumberEditText;
    private ExpiryDateEditText expiryDateEditText;
    private CardFormEditText securityCodeEditText;
    private Map<EditText, Boolean> inputValidStates = new HashMap<EditText, Boolean>();
    private Button registrationButton;
    private CardRegistrationFormGuiSetting registrationGuiSetting;
    private ProgressBar progressBar;
    private RelativeLayout registrationCardFormLayout;
    private int cameraSCANCODE = 0;
    private Boolean viewLoaded = false;
    private Button cameraButton;
    private int cardIOColor;
    private View.OnClickListener onRegisterButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            CardRegistrationFormFragment.this.startLoadingUI();
            BNPaymentHandler.getInstance().registerCreditCard((Context)CardRegistrationFormFragment.this.getActivity(), CardRegistrationFormFragment.this.cardHolderEditText.getText().toString(), CardRegistrationFormFragment.this.cardNumberEditText.getText().toString(), CardRegistrationFormFragment.this.expiryDateEditText.getEnteredExpiryMonth(), CardRegistrationFormFragment.this.expiryDateEditText.getEnteredExpiryYear(), CardRegistrationFormFragment.this.securityCodeEditText.getText().toString(), CardRegistrationFormFragment.this.resultListenerForInternal);
        }
    };
    private View.OnClickListener onCameraScanClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            Intent scanIntent = new Intent((Context)CardRegistrationFormFragment.this.getActivity(), CardIOActivity.class);
            scanIntent.putExtra("io.card.payment.requireExpiry", true);
            scanIntent.putExtra("io.card.payment.scanExpiry", true);
            scanIntent.putExtra("io.card.payment.requireCVV", false);
            scanIntent.putExtra("io.card.payment.requireCardholderName", false);
            scanIntent.putExtra("io.card.payment.suppressManual", true);
            scanIntent.putExtra("io.card.payment.guideColor", CardRegistrationFormFragment.this.cardIOColor);
            scanIntent.putExtra("io.card.payment.hideLogo", true);
            scanIntent.putExtra("io.card.payment.returnCardImage", false);
            scanIntent.putExtra("io.card.payment.suppressConfirmation", false);
            CardRegistrationFormFragment.this.startActivityForResult(scanIntent, CardRegistrationFormFragment.this.cameraSCANCODE);
        }
    };

    public void setRegistrationResultListener(ICardRegistrationCallback resultListener) {
        this.resultListenerForExternal = resultListener;
    }

    public void setTitle(String title) {
        if (this.pageTitle != null) {
            this.pageTitle.setText((CharSequence)title);
        }
    }

    public void setFormGuiSetting(CardRegistrationFormGuiSetting registrationGuiSetting) {
        this.registrationGuiSetting = registrationGuiSetting;
        if (this.viewLoaded.booleanValue()) {
            this.viewCustomization();
        }
    }

    @Override
    public void onFocusChanged(EditText view, boolean hasFocus, boolean inputValid) {
        if (hasFocus) {
            view.setTextColor(CompatHelper.getColor((Context)this.getActivity(), R.color.bn_black, null));
        } else if (!inputValid) {
            view.setTextColor(CompatHelper.getColor((Context)this.getActivity(), R.color.bn_red, null));
        }
    }

    @Override
    public void onInputValidated(EditText view, boolean inputValid) {
        this.inputValidStates.put(view, inputValid);
        this.updateButtonState();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.native_card_registration_form, container, false);
        this.registrationCardFormLayout = (RelativeLayout)view.findViewById(R.id.registrationCardFormLayout);
        this.pageTitle = (TextView)view.findViewById(R.id.tv_title);
        this.cardHolderEditText = (CardHolderEditText)view.findViewById(R.id.et_card_holder);
        this.cardNumberEditText = (CardNumberEditText)view.findViewById(R.id.et_card_number);
        this.expiryDateEditText = (ExpiryDateEditText)view.findViewById(R.id.et_expiry_date);
        this.securityCodeEditText = (CardFormEditText)view.findViewById(R.id.et_security_code);
        this.cameraButton = (Button)view.findViewById(R.id.camera_button);
        this.cameraButton.setOnClickListener(this.onCameraScanClickListener);
        this.registrationButton = (Button)view.findViewById(R.id.btn_register);
        this.registrationButton.setOnClickListener(this.onRegisterButtonClickListener);
        this.cardHolderEditText.setValidationListener(this);
        this.cardNumberEditText.setValidationListener(this);
        this.expiryDateEditText.setValidationListener(this);
        this.securityCodeEditText.setValidationListener(this);
        this.inputValidStates.put(this.cardHolderEditText, true);
        this.inputValidStates.put(this.cardNumberEditText, false);
        this.inputValidStates.put(this.expiryDateEditText, false);
        this.inputValidStates.put(this.securityCodeEditText, true);
        this.progressBar = new ProgressBar((Context)this.getActivity(), null, 16842874);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13);
        this.registrationCardFormLayout.addView((View)this.progressBar, (ViewGroup.LayoutParams)params);
        this.progressBar.setVisibility(4);
        this.resultListenerForInternal = this;
        if (this.registrationGuiSetting != null) {
            this.viewCustomization();
        }
        return view;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.viewLoaded = true;
    }

    private void viewCustomization() {
        if (this.registrationGuiSetting == null) {
            return;
        }
        this.TitleCustomization();
        this.RegisterButtonCustomization();
        this.CardHolderCustomization();
        this.CardNumberCustomization();
        this.ExpiryDateCustomization();
        this.SecurityCodeCustomization();
        this.LoadingBarCustomization();
        this.CardIOCustomization();
    }

    private void TitleCustomization() {
        if (this.registrationGuiSetting.TitleText != null && this.registrationGuiSetting.TitleText.trim().length() > 0 && this.pageTitle != null) {
            this.pageTitle.setText((CharSequence)this.registrationGuiSetting.TitleText);
        }
    }

    private void RegisterButtonCustomization() {
        if (this.registrationButton != null) {
            if (this.registrationGuiSetting.RegisterButtonText != null && this.registrationGuiSetting.RegisterButtonText.trim().length() > 0 && this.registrationButton != null) {
                this.registrationButton.setText((CharSequence)this.registrationGuiSetting.RegisterButtonText);
            }
            int colorValue = CompatHelper.getCustomizedColor((Context)this.getActivity(), this.registrationGuiSetting.RegisterButtonColor, "Register Button Color is invalid!");
            this.registrationButton.setAlpha(0.5f);
            this.registrationButton.setBackgroundColor(colorValue);
        }
    }

    private void CardHolderCustomization() {
        if (this.cardHolderEditText != null && this.registrationGuiSetting.CardHolderWatermark != null && this.registrationGuiSetting.CardHolderWatermark.trim().length() > 0) {
            this.cardHolderEditText.setHint(this.registrationGuiSetting.CardHolderWatermark);
        }
    }

    private void CardNumberCustomization() {
        if (this.registrationGuiSetting.CardNumberWatermark != null && this.registrationGuiSetting.CardNumberWatermark.trim().length() > 0 && this.cardNumberEditText != null) {
            this.cardNumberEditText.setHint(this.registrationGuiSetting.CardNumberWatermark);
        }
    }

    private void ExpiryDateCustomization() {
        if (this.registrationGuiSetting.ExpiryDateWatermark != null && this.registrationGuiSetting.ExpiryDateWatermark.trim().length() > 0 && this.expiryDateEditText != null) {
            this.expiryDateEditText.setHint(this.registrationGuiSetting.ExpiryDateWatermark);
        }
    }

    private void SecurityCodeCustomization() {
        if (this.registrationGuiSetting.SecurityCodeWatermark != null && this.registrationGuiSetting.SecurityCodeWatermark.trim().length() > 0 && this.securityCodeEditText != null) {
            this.securityCodeEditText.setHint(this.registrationGuiSetting.SecurityCodeWatermark);
        }
    }

    private void LoadingBarCustomization() {
        if (this.progressBar != null) {
            int colorValue = CompatHelper.getCustomizedColor((Context)this.getActivity(), this.registrationGuiSetting.LoadingBarColor, "Loading Bar Color is invalid!");
            this.progressBar.getIndeterminateDrawable().setColorFilter(colorValue, PorterDuff.Mode.MULTIPLY);
        }
    }

    private void CardIOCustomization() {
        if (this.registrationGuiSetting.CardIOEnable == null || this.registrationGuiSetting.CardIOEnable.booleanValue()) {
            this.cardIOColor = CompatHelper.getCustomizedColor((Context)this.getActivity(), this.registrationGuiSetting.CardIOColorText, "CardIO Frame Color is invalid!");
        } else {
            this.cameraButton.setVisibility(8);
        }
    }

    private void updateButtonState() {
        boolean enabled = true;
        for (EditText key : this.inputValidStates.keySet()) {
            if (this.inputValidStates.get(key).booleanValue()) continue;
            enabled = false;
            break;
        }
        if (enabled) {
            this.registrationButton.setAlpha(1.0f);
        } else {
            this.registrationButton.setAlpha(0.5f);
        }
        this.registrationButton.setEnabled(enabled);
    }

    private void startLoadingUI() {
        this.registrationButton.setAlpha(0.5f);
        this.registrationButton.setEnabled(false);
        this.progressBar.setVisibility(0);
    }

    private void stopLoadingUI() {
        this.registrationButton.setAlpha(1.0f);
        this.registrationButton.setEnabled(true);
        this.updateButtonState();
        this.progressBar.setVisibility(4);
    }

    @Override
    public void onRegistrationSuccess(CreditCard creditCard) {
        this.stopLoadingUI();
        this.resultListenerForExternal.onRegistrationSuccess(creditCard);
    }

    @Override
    public void onRegistrationError(RequestError error) {
        this.stopLoadingUI();
        this.resultListenerForExternal.onRegistrationError(error);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == this.cameraSCANCODE && data != null && data.hasExtra("io.card.payment.scanResult")) {
            io.card.payment.CreditCard scanResult = (io.card.payment.CreditCard)data.getParcelableExtra("io.card.payment.scanResult");
            String scanedNumber = scanResult.getFormattedCardNumber();
            this.cardNumberEditText.setText(scanedNumber);
            this.cardNumberEditText.requestFocus();
            String expiryMonth = String.valueOf(scanResult.expiryMonth);
            if (expiryMonth.length() == 1) {
                expiryMonth = "0" + expiryMonth;
            }
            String expiryYear = String.valueOf(scanResult.expiryYear).substring(2);
            String expireDate = expiryMonth + expiryYear;
            this.expiryDateEditText.setText(expireDate);
            this.expiryDateEditText.requestFocus();
        }
    }
}

