/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.widget;

import com.bambora.nativepayment.R;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class CardNumberFormat {
    public static final String VALIDATION_PATTERN = "^(?:4[0-9]{12}(?:[0-9]{3})?|(?:5[1-5][0-9]{2}|222[1-9]|22[3-9][0-9]|2[3-6][0-9]{2}|27[01][0-9]|2720)[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|6(?:011|5[0-9]{2})[0-9]{12}|(?:2131|1800|35\\d{3})\\d{11})$";
    private CardType cardType;
    private int maxInputLength;
    private List<Integer> formatGroupSizes;
    private Integer iconResId;

    public CardNumberFormat() {
        this.setCardType(CardType.UNKNOWN);
    }

    public CardType getCardType() {
        return this.cardType;
    }

    public Integer getIconResId() {
        return this.iconResId;
    }

    public int getMaxInputLength() {
        return this.maxInputLength;
    }

    public String getValidationString() {
        return VALIDATION_PATTERN;
    }

    public List<Integer> getFormatGroupSizes() {
        return this.formatGroupSizes;
    }

    public boolean updateCardType(CharSequence cardNumberInput) {
        CardType oldCardType = this.cardType;
        String stripped = this.stripFromNonDigits(cardNumberInput);
        for (CardType newCardType : CardType.values()) {
            Pattern typePattern = Pattern.compile(newCardType.typePattern());
            if (!typePattern.matcher(stripped).matches()) continue;
            this.setCardType(newCardType);
            return oldCardType != newCardType;
        }
        this.setCardType(CardType.UNKNOWN);
        return oldCardType != CardType.UNKNOWN;
    }

    private void setCardType(CardType cardType) {
        this.cardType = cardType;
        switch (this.cardType) {
            case VISA: {
                this.maxInputLength = 19;
                this.iconResId = R.drawable.ic_visa;
                this.formatGroupSizes = Arrays.asList(4, 4, 4, 4);
                break;
            }
            case MASTERCARD: {
                this.maxInputLength = 19;
                this.iconResId = R.drawable.ic_master_card;
                this.formatGroupSizes = Arrays.asList(4, 4, 4, 4);
                break;
            }
            case AMERICAN_EXPRESS: {
                this.maxInputLength = 17;
                this.iconResId = R.drawable.ic_amex;
                this.formatGroupSizes = Arrays.asList(4, 6, 5);
                break;
            }
            case DINERS_CLUB: {
                this.maxInputLength = 16;
                this.iconResId = R.drawable.ic_diners;
                this.formatGroupSizes = Arrays.asList(4, 6, 5);
                break;
            }
            default: {
                this.maxInputLength = 19;
                this.iconResId = null;
                this.formatGroupSizes = Arrays.asList(4, 4, 4, 4);
            }
        }
    }

    private String stripFromNonDigits(CharSequence input) {
        return String.valueOf(input).replaceAll("[^\\d]", "");
    }

    public static enum CardType {
        VISA("^4\\d*"),
        MASTERCARD("^5[1-5]\\d*"),
        AMERICAN_EXPRESS("^3[47]\\d*"),
        DINERS_CLUB("^3(?:0[0-5]|[68])\\d*"),
        UNKNOWN("");

        private String typePattern;

        private CardType(String typePattern) {
            this.typePattern = typePattern;
        }

        public String typePattern() {
            return this.typePattern;
        }
    }
}

