/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.viewmodels;

import android.content.Context;
import android.util.Log;
import com.bambora.nativepayment.handlers.BNPaymentHandler;
import com.bambora.nativepayment.managers.CreditCardManager;
import com.bambora.nativepayment.models.creditcard.CreditCard;
import com.bambora.nativepayment.models.creditcard.RegistrationFormError;
import com.bambora.nativepayment.models.creditcard.RegistrationFormSettings;
import com.bambora.nativepayment.models.creditcard.RegistrationResult;
import com.bambora.nativepayment.models.creditcard.RegistrationResultAction;
import com.bambora.nativepayment.services.PaymentApiService;
import com.bambora.nativepayment.webview.CreditCardRegistrationJsInterface;
import com.bambora.nativepayment.webview.ICreditCardRegistrationView;

public class CreditCardRegistrationViewModel
implements CreditCardRegistrationJsInterface.IJavascriptCallbackListener {
    private Context context;
    private ICreditCardRegistrationView view;
    private CreditCardManager creditCardManager;
    private RegistrationFormSettings formSettings = new RegistrationFormSettings();

    public CreditCardRegistrationViewModel(Context context, ICreditCardRegistrationView view) {
        this.context = context;
        this.view = view;
        this.creditCardManager = new CreditCardManager();
    }

    public void setCssUrl(String cssUrl) {
        this.formSettings.setCssUrl(cssUrl);
    }

    public void setCardNumberHint(String cardNumberHint) {
        this.formSettings.setCardNumberInputHint(cardNumberHint);
    }

    public void setCardExpiryHint(String cardExpiryHint) {
        this.formSettings.setCardExpiryInputHint(cardExpiryHint);
    }

    public void setCardCvvHint(String cardCvvHint) {
        this.formSettings.setCvvInputHint(cardCvvHint);
    }

    public void setSubmitButtonText(String text) {
        this.formSettings.setSubmitButtonText(text);
    }

    @Override
    public void onJavascriptCall(RegistrationResult result) {
        this.handleRegistrationResult(result);
    }

    public void getRegistrationFormUrl() {
        BNPaymentHandler.getInstance().initiateHostedPaymentPage(this.formSettings, new PaymentApiService.IHppResultListener(){

            @Override
            public void onHppInitiated(String url) {
                CreditCardRegistrationViewModel.this.view.loadRegistrationUrl(url);
            }

            @Override
            public void onError(RegistrationFormError registrationFormError) {
                CreditCardRegistrationViewModel.this.view.notifyError(registrationFormError);
            }
        });
    }

    private void handleRegistrationResult(RegistrationResult result) {
        RegistrationResultAction.ActionCode actionCode = result != null ? result.getActionCode() : RegistrationResultAction.ActionCode.UNKNOWN;
        switch (actionCode) {
            case SUBMISSION_STARTED: {
                this.view.notifyRegistrationStarted();
                break;
            }
            case SUCCESS: {
                this.handleSuccessResult(result);
                break;
            }
            case SUBMISSION_DECLINED: {
                this.view.notifyError(RegistrationFormError.SUBMISSION_DECLINED);
                break;
            }
            case SYSTEM_ERROR: {
                this.view.notifyError(RegistrationFormError.SYSTEM_ERROR);
                break;
            }
            case SESSION_ERROR: {
                this.view.notifyError(RegistrationFormError.SESSION_ERROR);
                break;
            }
            default: {
                this.view.notifyError(RegistrationFormError.UNKNOWN);
            }
        }
    }

    private void handleSuccessResult(RegistrationResult result) {
        if (result != null) {
            CreditCard creditCard = new CreditCard(result);
            this.saveCreditCard(creditCard);
        } else {
            Log.e((String)this.getClass().getSimpleName(), (String)"Error parsing registration result. No CreditCard attached.");
            this.view.notifyError(RegistrationFormError.UNKNOWN);
        }
    }

    private void saveCreditCard(CreditCard creditCard) {
        this.creditCardManager.saveCreditCard(this.context, creditCard, new CreditCardManager.IOnCreditCardSaved(){

            @Override
            public void onCreditCardSaved(CreditCard creditCard) {
                CreditCardRegistrationViewModel.this.view.notifyRegistrationSuccess(creditCard);
            }
        });
    }
}

