/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.utils;

import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HashUtils {
    private static final String UTF8_ENCODING = "UTF-8";
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();

    private HashUtils() {
    }

    public static String generateHmac(String type, String value, String key) throws GeneralSecurityException {
        SecretKeySpec secret = new SecretKeySpec(key.getBytes(Charset.forName(UTF8_ENCODING)), type);
        Mac mac = Mac.getInstance(type);
        mac.init(secret);
        byte[] bytes = mac.doFinal(value.getBytes(Charset.forName(UTF8_ENCODING)));
        return HashUtils.bytesToHex(bytes);
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String generatePow(String uuid, String path, int powDifficulty) throws Exception {
        int salt = 0;
        int timeStamp = (int)(System.currentTimeMillis() / 1000L);
        String stringToHash = timeStamp + ":" + uuid + ":" + path + ":1234";
        byte[] bytesToHash = stringToHash.getBytes(Charset.forName(UTF8_ENCODING));
        int stringLength = stringToHash.length();
        int bytesToHashLength = bytesToHash.length;
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(bytesToHash, 0, stringLength);
        byte[] sha1hash = md.digest();
        while (!HashUtils.validPow(sha1hash, powDifficulty)) {
            bytesToHash[bytesToHashLength - 1] = (byte)(59 + ++salt % 68);
            bytesToHash[bytesToHashLength - 2] = (byte)(59 + (salt >>> 8) % 68);
            bytesToHash[bytesToHashLength - 3] = (byte)(127 - (salt >>> 16) % 68);
            bytesToHash[bytesToHashLength - 4] = (byte)(127 - (salt >>> 24) % 68);
            md.update(bytesToHash, 0, stringToHash.length());
            sha1hash = md.digest();
        }
        String hash = HashUtils.bytesToHex(sha1hash);
        return new String(bytesToHash, UTF8_ENCODING) + ":" + hash;
    }

    private static boolean validPow(byte[] hash, int powDifficulty) {
        for (int i = 0; i < powDifficulty; ++i) {
            byte byteToCheck = hash[i / 8];
            byte mask = (byte)(-128 >> i % 8);
            int maskByteToCheck = byteToCheck & mask;
            if (maskByteToCheck == 0) continue;
            return false;
        }
        return true;
    }
}

