/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.services;

import android.content.Context;
import com.bambora.nativepayment.handlers.BNPaymentHandler;
import com.bambora.nativepayment.interfaces.VisaCheckoutDataCallback;
import com.bambora.nativepayment.interfaces.VisaCheckoutTransactionCallback;
import com.bambora.nativepayment.models.VisaCheckoutLaunchParams;
import com.bambora.nativepayment.models.VisaCheckoutResponse;
import com.bambora.nativepayment.models.VisaCheckoutTransactionParams;
import com.bambora.nativepayment.network.ApiService;
import com.bambora.nativepayment.network.Callback;
import com.bambora.nativepayment.network.Request;
import com.bambora.nativepayment.network.RequestError;
import com.bambora.nativepayment.network.RequestMethod;
import com.bambora.nativepayment.network.Response;

public class VisaCheckoutApiService
extends ApiService {
    public Request<VisaCheckoutLaunchParams> getVisaCheckoutData() {
        return new Request<VisaCheckoutLaunchParams>(this, VisaCheckoutLaunchParams.class).endpoint("visacheckout_params").method(RequestMethod.GET);
    }

    public Request<VisaCheckoutResponse> processTransaction(VisaCheckoutTransactionParams visaCheckoutTransactionParams) {
        return new Request<VisaCheckoutResponse>(this, VisaCheckoutResponse.class).endpoint("visacheckout_transaction").method(RequestMethod.POST).body(visaCheckoutTransactionParams);
    }

    private static VisaCheckoutApiService createService() {
        return BNPaymentHandler.getInstance().createService(VisaCheckoutApiService.class);
    }

    public static class VisaCheckoutService {
        public static void getVisaCheckoutData(Context context, final VisaCheckoutDataCallback callBack) {
            Request<VisaCheckoutLaunchParams> request = VisaCheckoutApiService.createService().getVisaCheckoutData();
            request.execute(new Callback<VisaCheckoutLaunchParams>(){

                @Override
                public void onSuccess(Response<VisaCheckoutLaunchParams> response) {
                    if (callBack != null) {
                        VisaCheckoutLaunchParams visaCheckoutLaunchParams = response.getBody();
                        callBack.onVisaCheckoutDataSuccess(visaCheckoutLaunchParams);
                    }
                }

                @Override
                public void onError(RequestError error) {
                    if (callBack != null) {
                        callBack.onVisaCheckoutDataError(error);
                    }
                }
            });
        }

        public static void processTransaction(Context context, VisaCheckoutTransactionParams visaCheckoutTransactionParams, final VisaCheckoutTransactionCallback callBack) {
            Request<VisaCheckoutResponse> request = VisaCheckoutApiService.createService().processTransaction(visaCheckoutTransactionParams);
            request.execute(new Callback<VisaCheckoutResponse>(){

                @Override
                public void onSuccess(Response<VisaCheckoutResponse> response) {
                    if (callBack != null) {
                        VisaCheckoutResponse visaCheckoutResponse = response.getBody();
                        callBack.onVisaCheckoutTransactionSuccess(visaCheckoutResponse);
                    }
                }

                @Override
                public void onError(RequestError error) {
                    if (callBack != null) {
                        callBack.onVisaCheckoutTransactionError(error);
                    }
                }
            });
        }
    }
}

