/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.services;

import android.content.Context;
import com.bambora.nativepayment.handlers.BNPaymentHandler;
import com.bambora.nativepayment.interfaces.ICardRegistrationCallback;
import com.bambora.nativepayment.interfaces.ITransactionExtListener;
import com.bambora.nativepayment.interfaces.ITransactionListener;
import com.bambora.nativepayment.logging.BNLog;
import com.bambora.nativepayment.managers.CreditCardManager;
import com.bambora.nativepayment.models.PaymentSettings;
import com.bambora.nativepayment.models.PaymentType;
import com.bambora.nativepayment.models.TransactionResponse;
import com.bambora.nativepayment.models.creditcard.CreditCard;
import com.bambora.nativepayment.models.creditcard.RegistrationFormError;
import com.bambora.nativepayment.models.creditcard.RegistrationFormSettings;
import com.bambora.nativepayment.models.creditcard.RegistrationParams;
import com.bambora.nativepayment.models.creditcard.RegistrationResponse;
import com.bambora.nativepayment.network.ApiService;
import com.bambora.nativepayment.network.Callback;
import com.bambora.nativepayment.network.Request;
import com.bambora.nativepayment.network.RequestError;
import com.bambora.nativepayment.network.RequestMethod;
import com.bambora.nativepayment.network.Response;
import com.bambora.nativepayment.storage.TransactionFileStorage;
import java.util.HashMap;

public class PaymentApiService
extends ApiService {
    public Request<RegistrationResponse> initiateHpp(RegistrationFormSettings formSettings) {
        return new Request<RegistrationResponse>(this, RegistrationResponse.class).endpoint("hpp/").method(RequestMethod.POST).body(formSettings);
    }

    public Request<CreditCard> authorizeCreditCard(RegistrationParams registrationParams) {
        return new Request<CreditCard>(this, CreditCard.class).endpoint("cardregistration/").method(RequestMethod.POST).body(registrationParams);
    }

    public Request<TransactionResponse> makeTransaction(String paymentId, PaymentSettings paymentSettings) {
        return new Request<TransactionResponse>(this, TransactionResponse.class).endpoint("payments/{paymentId}/card_token/").endpointParameter("paymentId", paymentId).method(RequestMethod.POST).body(paymentSettings);
    }

    private static PaymentApiService createService() {
        return BNPaymentHandler.getInstance().createService(PaymentApiService.class);
    }

    public static class PaymentService {
        private static TransactionFileStorage transactionFileStorage = new TransactionFileStorage();

        public static Request initiateHppRegistration(RegistrationFormSettings formSettings, final IHppResultListener resultListener) {
            Request<RegistrationResponse> request = PaymentApiService.createService().initiateHpp(formSettings);
            request.execute(new Callback<RegistrationResponse>(){

                @Override
                public void onSuccess(Response<RegistrationResponse> response) {
                    String url = response.getBody().sessionUrl;
                    if (resultListener != null) {
                        if (url != null) {
                            resultListener.onHppInitiated(url);
                        } else {
                            BNLog.e(this.getClass().getSimpleName(), "Credit card registration failed to initiate. URL is null.");
                            resultListener.onError(RegistrationFormError.PAGE_LOAD_ERROR);
                        }
                    }
                }

                @Override
                public void onError(RequestError error) {
                    if (resultListener != null) {
                        resultListener.onError(RegistrationFormError.PAGE_LOAD_ERROR);
                    }
                }
            });
            return request;
        }

        public static Request registerCreditCard(RegistrationParams registrationParams, final ICardRegistrationCallback callback) {
            Request<CreditCard> request = PaymentApiService.createService().authorizeCreditCard(registrationParams);
            request.execute(new Callback<CreditCard>(){

                @Override
                public void onSuccess(Response<CreditCard> response) {
                    if (callback != null) {
                        CreditCard creditCard = response.getBody();
                        if (creditCard != null) {
                            callback.onRegistrationSuccess(creditCard);
                        } else {
                            callback.onRegistrationError(null);
                        }
                    }
                }

                @Override
                public void onError(RequestError error) {
                    if (callback != null) {
                        callback.onRegistrationError(error);
                    }
                }
            });
            return request;
        }

        public static Request makeTransaction(String paymentId, PaymentSettings paymentSettings, final ITransactionListener listener) {
            Request<TransactionResponse> request = PaymentApiService.createService().makeTransaction(paymentId, paymentSettings);
            request.execute(new Callback<TransactionResponse>(){

                @Override
                public void onSuccess(Response<TransactionResponse> response) {
                    if (listener != null) {
                        listener.onTransactionSuccess();
                    }
                }

                @Override
                public void onError(RequestError error) {
                    if (listener != null) {
                        listener.onTransactionError(error);
                    }
                }
            });
            return request;
        }

        public static Request makeTransactionToken(String paymentId, PaymentSettings paymentSettings, final ITransactionExtListener listener) {
            Request<TransactionResponse> request = PaymentApiService.createService().makeTransaction(paymentId, paymentSettings);
            request.execute(new Callback<TransactionResponse>(){

                @Override
                public void onSuccess(Response<TransactionResponse> response) {
                    if (listener != null) {
                        HashMap<String, String> responseMap = new HashMap<String, String>();
                        TransactionResponse transactionResponse = response.getBody();
                        if (transactionResponse.receipt != null) {
                            responseMap.put("receipt", transactionResponse.receipt);
                        }
                        listener.onTransactionSuccess(responseMap);
                    }
                }

                @Override
                public void onError(RequestError error) {
                    if (listener != null) {
                        listener.onTransactionError(error);
                    }
                }
            });
            return request;
        }

        public static Request makeTransactionCard(final Context context, String paymentId, final PaymentSettings paymentSettings, final ITransactionExtListener listener, final CreditCardManager.IOnCreditCardSaved onSavedListener) {
            Request<TransactionResponse> request = PaymentApiService.createService().makeTransaction(paymentId, paymentSettings);
            request.execute(new Callback<TransactionResponse>(){

                @Override
                public void onSuccess(Response<TransactionResponse> response) {
                    if (listener != null) {
                        HashMap<String, String> responseMap = new HashMap<String, String>();
                        TransactionResponse transactionResponse = response.getBody();
                        if (transactionResponse.receipt != null) {
                            responseMap.put("receipt", transactionResponse.receipt);
                        }
                        if ((paymentSettings.paymentType == PaymentType.PaymentTypeEnum.PaymentCard || paymentSettings.paymentType == PaymentType.PaymentTypeEnum.PreAuthCard) && transactionResponse.truncatedCard.trim().length() > 0) {
                            CreditCard creditCard = new CreditCard(transactionResponse);
                            CreditCardManager creditCardManager = new CreditCardManager();
                            creditCardManager.saveCreditCard(context, creditCard, onSavedListener);
                        }
                        listener.onTransactionSuccess(responseMap);
                    }
                }

                @Override
                public void onError(RequestError error) {
                    if (listener != null) {
                        listener.onTransactionError(error);
                    }
                }
            });
            return request;
        }

        public static Request submitSinglePaymentToken(String paymentId, PaymentSettings paymentSettings, ITransactionExtListener listener) {
            return PaymentService.makeTransactionToken(paymentId, paymentSettings, listener);
        }
    }

    public static interface IHppResultListener {
        public void onHppInitiated(String var1);

        public void onError(RegistrationFormError var1);
    }
}

