/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.services;

import com.bambora.nativepayment.handlers.BNPaymentHandler;
import com.bambora.nativepayment.interfaces.ICertificateLoadCallback;
import com.bambora.nativepayment.models.CertificatesResponse;
import com.bambora.nativepayment.network.ApiService;
import com.bambora.nativepayment.network.Callback;
import com.bambora.nativepayment.network.Request;
import com.bambora.nativepayment.network.RequestError;
import com.bambora.nativepayment.network.RequestMethod;
import com.bambora.nativepayment.network.Response;
import com.bambora.nativepayment.security.EncryptionCertificate;
import java.util.List;

public class CertificateApiService
extends ApiService {
    public Request<CertificatesResponse> getEncryptionCertificates() {
        return new Request<CertificatesResponse>(this, CertificatesResponse.class).endpoint("certificates/").method(RequestMethod.GET);
    }

    private static CertificateApiService createService() {
        return BNPaymentHandler.getInstance().createService(CertificateApiService.class);
    }

    public static class CertificateService {
        public static void getCertificates(final ICertificateLoadCallback callback) {
            Request<CertificatesResponse> request = CertificateApiService.createService().getEncryptionCertificates();
            request.execute(new Callback<CertificatesResponse>(){

                @Override
                public void onSuccess(Response<CertificatesResponse> response) {
                    CertificatesResponse certificatesResponse = response.getBody();
                    if (callback != null) {
                        callback.onCertificatesLoaded(certificatesResponse.getEncryptionCertificates());
                    }
                }

                @Override
                public void onError(RequestError error) {
                    if (callback != null) {
                        callback.onError();
                    }
                }
            });
        }
    }

    public static interface ICertificateCallback {
        public void onCertificatesLoaded(List<EncryptionCertificate> var1);
    }
}

