/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.models.creditcard;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class RegistrationResultAction {
    private static final String KEY_CODE = "code";
    private static final String KEY_SOURCE = "source";
    private static final String KEY_TYPE = "type";
    public String code;
    public String source;
    public String type;

    public ActionCode getActionCode() {
        return this.code != null ? ActionCode.fromString(this.code) : ActionCode.UNKNOWN;
    }

    public RegistrationResultAction(JSONObject jsonObject) throws JSONException {
        this.code = jsonObject.optString(KEY_CODE);
        this.source = jsonObject.optString(KEY_SOURCE);
        this.type = jsonObject.optString(KEY_TYPE);
    }

    public static enum ActionCode {
        SUBMISSION_STARTED("100"),
        SUCCESS("200"),
        SUBMISSION_DECLINED("300"),
        SESSION_ERROR("400"),
        SYSTEM_ERROR("1000"),
        UNKNOWN("9999");

        private String value;
        private static Map<String, ActionCode> stringToActionCodeMap;

        private ActionCode(String value) {
            this.value = value;
        }

        public static ActionCode fromString(String value) {
            ActionCode actionCode = stringToActionCodeMap.get(value);
            return actionCode != null ? actionCode : UNKNOWN;
        }

        static {
            stringToActionCodeMap = new HashMap<String, ActionCode>();
            for (ActionCode actionCode : ActionCode.values()) {
                stringToActionCodeMap.put(actionCode.value, actionCode);
            }
        }
    }
}

