/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.models.creditcard;

import com.bambora.nativepayment.interfaces.IJsonResponse;
import com.bambora.nativepayment.json.JsonContainer;
import com.bambora.nativepayment.models.TransactionResponse;
import com.bambora.nativepayment.models.creditcard.RegistrationResult;
import com.bambora.nativepayment.utils.JsonUtils;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

public class CreditCard
implements Serializable,
IJsonResponse<CreditCard> {
    private static final String KEY_RECURRING_PAYMENT_ID = "recurringPaymentID";
    private static final String KEY_CARD_HOLDER_NAME = "cardHolderName";
    private static final String KEY_CARD_NUMBER = "cardNumber";
    private static final String KEY_CARD_TYPE = "cardType";
    private static final String KEY_EXPIRY_MONTH = "expiryMonth";
    private static final String KEY_EXPIRY_YEAR = "expiryYear";
    private String alias;
    private String truncatedCardNumber;
    private String cardHolderName;
    private Integer expiryMonth;
    private Integer expiryYear;
    private String paymentType;
    private String transactionId;
    private String creditCardToken;

    public CreditCard() {
    }

    public CreditCard(String truncatedCardNumber, Integer expiryMonth, Integer expiryYear, String paymentType, String transactionId, String creditCardToken) {
        this.cardHolderName = "";
        this.truncatedCardNumber = truncatedCardNumber;
        this.expiryMonth = expiryMonth;
        this.expiryYear = expiryYear;
        this.paymentType = paymentType;
        this.transactionId = transactionId;
        this.creditCardToken = creditCardToken;
    }

    public CreditCard(RegistrationResult registrationResult) {
        if (registrationResult != null) {
            this.truncatedCardNumber = registrationResult.truncatedCardNumber;
            this.cardHolderName = registrationResult.cardHolderName;
            this.expiryMonth = registrationResult.expiryMonth;
            this.expiryYear = registrationResult.expiryYear;
            this.paymentType = registrationResult.paymentType;
            this.transactionId = registrationResult.transactionId;
            this.creditCardToken = registrationResult.subscriptionId;
        }
    }

    public CreditCard(TransactionResponse transactionResponse) {
        this.cardHolderName = transactionResponse.cardHolderName;
        this.creditCardToken = transactionResponse.creditCardToken;
        this.truncatedCardNumber = transactionResponse.truncatedCard;
        this.paymentType = transactionResponse.cardType;
    }

    @Override
    public CreditCard fromJson(JsonContainer jsonContainer) throws JSONException {
        JSONObject jsonObject = jsonContainer.getJsonObject();
        this.creditCardToken = JsonUtils.getStringIfExists(jsonObject, KEY_RECURRING_PAYMENT_ID);
        this.cardHolderName = JsonUtils.getStringIfExists(jsonObject, KEY_CARD_HOLDER_NAME);
        this.truncatedCardNumber = JsonUtils.getStringIfExists(jsonObject, KEY_CARD_NUMBER);
        this.paymentType = JsonUtils.getStringIfExists(jsonObject, KEY_CARD_TYPE);
        this.expiryMonth = JsonUtils.getIntIfExists(jsonObject, KEY_EXPIRY_MONTH);
        this.expiryYear = JsonUtils.getIntIfExists(jsonObject, KEY_EXPIRY_YEAR);
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getTruncatedCardNumber() {
        return this.truncatedCardNumber;
    }

    public String getCardHolderName() {
        return this.cardHolderName;
    }

    public Integer getExpiryMonth() {
        return this.expiryMonth;
    }

    public Integer getExpiryYear() {
        return this.expiryYear;
    }

    public String getPaymentType() {
        return this.paymentType;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getCreditCardToken() {
        return this.creditCardToken;
    }

    public boolean isEqualTo(CreditCard otherCard) {
        return otherCard.getCreditCardToken().equals(this.creditCardToken);
    }
}

