/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.logging;

import android.util.Log;
import com.bambora.nativepayment.handlers.BNPaymentHandler;
import com.bambora.nativepayment.network.Request;
import com.bambora.nativepayment.network.Response;

public class BNLog {
    private static final String DIVIDER = "--------------------------------------\n";

    public static void d(String tag, String msg) {
        if (BNLog.debug()) {
            Log.d((String)tag, (String)msg);
        }
    }

    public static void e(String tag, String msg) {
        if (BNLog.debug()) {
            Log.e((String)tag, (String)msg);
        }
    }

    public static void e(String tag, String msg, Throwable throwable) {
        if (BNLog.debug()) {
            Log.e((String)tag, (String)msg, (Throwable)throwable);
        }
    }

    public static void w(String tag, String msg, Throwable throwable) {
        if (BNLog.debug()) {
            Log.w((String)tag, (String)msg, (Throwable)throwable);
        }
    }

    public static boolean debug() {
        try {
            Class.forName("android.os.AsyncTask");
            return BNPaymentHandler.getInstance().getDebug();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void requestResult(String logTag, Request request, Response response) {
        boolean success = response != null && response.error == null;
        String title = success ? "BN request completed successfully\n" : "BN request failed\n";
        StringBuilder logMessage = new StringBuilder();
        logMessage.append(DIVIDER).append(title).append(DIVIDER);
        if (response != null) {
            logMessage.append(response.toString());
        }
        if (request != null) {
            logMessage.append(DIVIDER).append("Original request\n").append(DIVIDER).append(request.toString());
        }
        logMessage.append(DIVIDER);
        if (success) {
            BNLog.d(logTag, logMessage.toString());
        } else {
            BNLog.e(logTag, logMessage.toString());
        }
    }

    public static void jsonParseError(String logTag, Exception exception) {
        BNLog.e(logTag, "Failed to parse JSON string.", exception);
    }
}

