/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.json;

import com.bambora.nativepayment.logging.BNLog;
import com.bambora.nativepayment.utils.DateUtils;
import java.text.ParseException;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class BNJsonObject
extends JSONObject {
    private static final String LOG_TAG = "BNJsonObject";

    public BNJsonObject() {
    }

    public BNJsonObject(String json) throws JSONException {
        super(json);
    }

    public static BNJsonObject copyFrom(JSONObject jsonObject) {
        try {
            return new BNJsonObject(jsonObject.toString());
        }
        catch (JSONException exception) {
            BNLog.e(LOG_TAG, "Failed to initiate BNJsonObject.", exception);
            return new BNJsonObject();
        }
    }

    public Date optDate(String name) {
        String dateString = this.optString(name);
        if (!dateString.isEmpty()) {
            try {
                return DateUtils.parseISO8601DateString(dateString);
            }
            catch (ParseException e) {
                BNLog.e(LOG_TAG, "Failed to parse date string: " + dateString, e);
            }
        }
        return null;
    }
}

