/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.widget.textwatcher;

import android.text.Editable;
import android.text.TextWatcher;
import com.bambora.nativepayment.widget.CardInputValidator;
import com.bambora.nativepayment.widget.FormInputHelper;
import java.util.Arrays;
import java.util.List;

public class ExpiryDateTextWatcher
implements TextWatcher {
    private static final char DELIMITER = '/';
    private static final String VALID_INPUT = "^(0[1-9]|1[0-2])\\d{2}$";
    private CardInputValidator formatter;
    private boolean deleting;
    private String deleted;
    private int startIndex;

    public ExpiryDateTextWatcher(CardInputValidator inputFormatter) {
        this.formatter = inputFormatter;
        this.formatter.setValidationPattern(VALID_INPUT);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        this.deleting = after < count;
        this.deleted = this.deleting ? FormInputHelper.getDeletedChars(s, start, count) : "";
        this.startIndex = start;
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        String formattedInput = s.toString();
        if (this.deleting && this.deleted.equals(String.valueOf('/')) && s.length() > 0 && this.startIndex > 0) {
            s.delete(this.startIndex - 1, this.startIndex);
        }
        List<Integer> groupSizes = Arrays.asList(2, 2);
        if (!FormInputHelper.isFormatted(s.toString(), '/', groupSizes)) {
            formattedInput = FormInputHelper.formatNumberSequence(formattedInput, groupSizes, '/').toString();
            s.replace(0, s.length(), (CharSequence)formattedInput);
        }
    }
}

