/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.widget.textwatcher;

import android.text.Editable;
import android.text.TextWatcher;
import com.bambora.nativepayment.widget.CardInputValidator;
import com.bambora.nativepayment.widget.CardNumberFormat;
import com.bambora.nativepayment.widget.FormInputHelper;

public class CardNumberTextWatcher
implements TextWatcher {
    private static final char SPACE = ' ';
    private CardNumberFormat numberFormat = new CardNumberFormat();
    private boolean deleting;
    private CharSequence deleted;
    private int startIndex;
    private CardInputValidator validator;
    private CardTypeListener cardTypeListener;

    public CardNumberTextWatcher(CardInputValidator inputFormatter, CardTypeListener cardTypeListener) {
        this.validator = inputFormatter;
        this.cardTypeListener = cardTypeListener;
        this.validator.setValidationPattern(this.numberFormat.getValidationString());
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        this.deleting = after < count;
        this.deleted = this.deleting ? FormInputHelper.getDeletedChars(s, start, count) : "";
        this.startIndex = start;
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        this.updateCardType(s);
    }

    public void afterTextChanged(Editable s) {
        this.validator.setValidationPattern(this.numberFormat.getValidationString());
        if (this.deleting && this.deleted.equals(String.valueOf(' ')) && s.length() > 0) {
            s.delete(this.startIndex - 1, this.startIndex);
        }
        if (!FormInputHelper.isFormatted(s.toString(), ' ', this.numberFormat.getFormatGroupSizes())) {
            CharSequence formatted = FormInputHelper.formatNumberSequence(s.toString(), this.numberFormat.getFormatGroupSizes(), ' ');
            s.replace(0, s.length(), formatted);
        }
    }

    private void updateCardType(CharSequence input) {
        boolean updated = this.numberFormat.updateCardType(input);
        if (updated) {
            this.notifyTypeChanged();
        }
    }

    private void notifyTypeChanged() {
        if (this.cardTypeListener != null) {
            this.cardTypeListener.onCardTypeChanged(this.numberFormat);
        }
    }

    public static interface CardTypeListener {
        public void onCardTypeChanged(CardNumberFormat var1);
    }
}

