/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.widget;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.bambora.nativepayment.R;
import com.bambora.nativepayment.interfaces.ITransactionExtListener;
import com.bambora.nativepayment.managers.CreditCardManager;
import com.bambora.nativepayment.models.PaymentSettings;
import com.bambora.nativepayment.models.SubmitPaymentCardFormGuiSetting;
import com.bambora.nativepayment.widget.TransactionCardFormFragment;

public class TransactionCardFormLayout
extends FrameLayout {
    TransactionCardFormFragment transactionCardFormFragment;

    public TransactionCardFormLayout(Context context) {
        super(context);
        this.setupView(context);
    }

    public TransactionCardFormLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupView(context);
    }

    public TransactionCardFormLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setupView(context);
    }

    @TargetApi(value=21)
    public TransactionCardFormLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setupView(context);
    }

    private void setupView(Context context) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        inflater.inflate(R.layout.native_transaction_frame_form, (ViewGroup)this);
        Activity activity = (Activity)context;
        FragmentManager fragmentManager = activity.getFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        this.transactionCardFormFragment = new TransactionCardFormFragment();
        fragmentTransaction.add(R.id.frame_layout, (Fragment)this.transactionCardFormFragment).commit();
    }

    public void setTransactionCardResultListener(ITransactionExtListener resultListener) {
        this.transactionCardFormFragment.setTransactionCardResultListener(resultListener);
    }

    public void setSavedCardListener(CreditCardManager.IOnCreditCardSaved onSavedListener) {
        this.transactionCardFormFragment.setSavedCardListener(onSavedListener);
    }

    public void setTransactionParams(PaymentSettings paymentSettings, String paymentId) {
        this.transactionCardFormFragment.setTransactionParams(paymentSettings, paymentId);
    }

    public void setFormGuiSetting(SubmitPaymentCardFormGuiSetting guiSetting) {
        this.transactionCardFormFragment.setFormGuiSetting(guiSetting);
    }
}

