/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.webview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.webkit.WebView;
import com.bambora.nativepayment.R;
import com.bambora.nativepayment.models.creditcard.CreditCard;
import com.bambora.nativepayment.models.creditcard.RegistrationFormError;
import com.bambora.nativepayment.viewmodels.CreditCardRegistrationViewModel;
import com.bambora.nativepayment.webview.CreditCardRegistrationJsInterface;
import com.bambora.nativepayment.webview.CreditCardRegistrationWebViewClient;
import com.bambora.nativepayment.webview.ICreditCardRegistrationView;

public class CreditCardRegistrationWebView
extends WebView
implements ICreditCardRegistrationView,
CreditCardRegistrationWebViewClient.IOnPageFinishedListener {
    private CreditCardRegistrationViewModel viewModel;
    private IStateChangeListener stateChangeListener;

    public CreditCardRegistrationWebView(Context context) {
        super(context);
        this.initView(context, null);
    }

    public CreditCardRegistrationWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public CreditCardRegistrationWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    public void setStateChangeListener(IStateChangeListener listener) {
        this.stateChangeListener = listener;
    }

    public void setCssUrl(String cssUrl) {
        this.viewModel.setCssUrl(cssUrl);
    }

    public void setCardNumberHint(String cardNumberHint) {
        this.viewModel.setCardNumberHint(cardNumberHint);
    }

    public void setCardExpiryHint(String cardExpiryHint) {
        this.viewModel.setCardExpiryHint(cardExpiryHint);
    }

    public void setCardCvvHint(String cardCvvHint) {
        this.viewModel.setCardCvvHint(cardCvvHint);
    }

    public void setSubmitButtonText(String text) {
        this.viewModel.setSubmitButtonText(text);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.viewModel.getRegistrationFormUrl();
    }

    @Override
    public void loadRegistrationUrl(String url) {
        this.loadUrl(url);
    }

    @Override
    public void onPageFinished() {
        if (this.stateChangeListener != null) {
            this.stateChangeListener.onPageFinished();
        }
    }

    @Override
    public void notifyRegistrationStarted() {
        if (this.stateChangeListener != null) {
            this.stateChangeListener.onRegistrationStarted();
        }
    }

    @Override
    public void notifyRegistrationSuccess(CreditCard creditCard) {
        if (this.stateChangeListener != null) {
            this.stateChangeListener.onRegistrationCompleted(creditCard);
        }
    }

    @Override
    public void notifyError(RegistrationFormError error) {
        if (this.stateChangeListener != null) {
            this.stateChangeListener.onFailure(error);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void initView(Context context, AttributeSet attributeSet) {
        this.viewModel = new CreditCardRegistrationViewModel(this.getContext(), this);
        this.setWebViewClient(new CreditCardRegistrationWebViewClient(this));
        this.getAttributes(context, attributeSet);
        this.getSettings().setJavaScriptEnabled(true);
        this.addJavascriptInterface(new CreditCardRegistrationJsInterface(this.viewModel), "Android");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray styledAttributes = context.obtainStyledAttributes(attrs, R.styleable.CreditCardRegistrationWebView);
        try {
            this.setCardNumberHint(styledAttributes.getString(R.styleable.CreditCardRegistrationWebView_card_number_hint));
            this.setCardExpiryHint(styledAttributes.getString(R.styleable.CreditCardRegistrationWebView_card_expiry_hint));
            this.setCardCvvHint(styledAttributes.getString(R.styleable.CreditCardRegistrationWebView_card_cvv_hint));
            this.setSubmitButtonText(styledAttributes.getString(R.styleable.CreditCardRegistrationWebView_submit_button_text));
        }
        finally {
            styledAttributes.recycle();
        }
    }

    public static interface IStateChangeListener {
        public void onPageFinished();

        public void onRegistrationStarted();

        public void onRegistrationCompleted(CreditCard var1);

        public void onFailure(RegistrationFormError var1);
    }
}

