/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    private static final String SHORT_ISO_8601_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HHmmssZ";

    private DateUtils() {
    }

    public static String getDateHeader(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String dateHeader = dateFormat.format(date);
        dateHeader = dateHeader + " GMT";
        return dateHeader;
    }

    public static Date parseISO8601DateString(String dateString) throws ParseException {
        String shortIso = dateString.replace(":", "").replace("Z", "+0000");
        SimpleDateFormat dateFormat = new SimpleDateFormat(SHORT_ISO_8601_DATE_TIME_FORMAT, Locale.ENGLISH);
        return dateFormat.parse(shortIso);
    }

    public static int getDifferenceInDays(Date date1, Date date2) {
        long millis = date2.getTime() - date1.getTime();
        return (int)(millis / 1000L / 60L / 60L / 24L);
    }

    public static Date addDays(Date date, int nrOfDays) {
        long millis = nrOfDays * 24 * 60 * 60 * 1000;
        return new Date(date.getTime() + millis);
    }
}

