/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.storage;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class FileStorage {
    protected void saveObjectToDisk(final Context context, final String fileName, final Serializable object, final IOnObjectSaved listener) {
        AsyncTask<Void, Void, Void> writeToFileTask = new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... voids) {
                try {
                    FileOutputStream fileOutputStream = context.openFileOutput(fileName, 0);
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeObject(object);
                    objectOutputStream.close();
                    fileOutputStream.close();
                    FileStorage.this.postResultToUiThread(listener);
                    return null;
                }
                catch (IOException e) {
                    Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("Failed to save object to disk. " + e));
                    return null;
                }
            }
        };
        this.executeAsyncTask((AsyncTask)writeToFileTask);
    }

    protected void getObjectFromDisk(final Context context, final String fileName, final IOnObjectRead listener) {
        AsyncTask<Void, Void, Serializable> readFromFileTask = new AsyncTask<Void, Void, Serializable>(){

            protected Serializable doInBackground(Void ... voids) {
                Serializable object = null;
                try {
                    FileInputStream fileInputStream = context.openFileInput(fileName);
                    ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                    object = (Serializable)objectInputStream.readObject();
                    objectInputStream.close();
                    fileInputStream.close();
                    FileStorage.this.postResultToUiThread(listener, object);
                }
                catch (IOException | ClassNotFoundException e) {
                    Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("Failed to read object from disk. " + e));
                    FileStorage.this.postResultToUiThread(listener, null);
                }
                return object;
            }
        };
        this.executeAsyncTask((AsyncTask)readFromFileTask);
    }

    private void executeAsyncTask(AsyncTask task) {
        if (Build.VERSION.SDK_INT >= 11) {
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null);
        } else {
            task.execute(new Object[0]);
        }
    }

    private void postResultToUiThread(final IOnObjectRead listener, final Serializable object) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (listener != null) {
                    listener.notifyOnObjectRead(object);
                }
            }
        });
    }

    private void postResultToUiThread(final IOnObjectSaved listener) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (listener != null) {
                    listener.notifyOnObjectSaved();
                }
            }
        });
    }

    public static interface IOnObjectSaved {
        public void notifyOnObjectSaved();
    }

    public static interface IOnObjectRead {
        public void notifyOnObjectRead(Serializable var1);
    }
}

