/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.security;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class Crypto {
    public static final String RSA_ALGORITHM = "RSA";
    public static final String RSA_ECB_PKCS1_ALGORITHM = "RSA/ECB/PKCS1Padding";
    public static final String AES_ALGORITHM = "AES";
    public static final String AES_CBC_PKCS5_ALGORITHM = "AES/CBC/PKCS5Padding";
    public static final String UTF8_CHARSET = "UTF-8";
    public static final int RSA_KEY_SIZE = 4096;
    public static final int AES_KEY_SIZE_128 = 128;

    public byte[] RSAEncrypt(byte[] data, PublicKey key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException {
        if (data != null) {
            Cipher cipher = Cipher.getInstance(RSA_ECB_PKCS1_ALGORITHM);
            cipher.init(1, key);
            return cipher.doFinal(data);
        }
        return null;
    }

    public byte[] RSADecrypt(byte[] data, PrivateKey key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, UnsupportedEncodingException {
        if (data != null) {
            Cipher cipher = Cipher.getInstance(RSA_ECB_PKCS1_ALGORITHM);
            cipher.init(2, key);
            return cipher.doFinal(data);
        }
        return null;
    }

    public String AESEncryptAndEncode(String data, SecretKey key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        byte[] encrypted = this.AESEncrypt(data, key);
        return Base64.encodeToString((byte[])encrypted, (int)2);
    }

    public byte[] AESEncrypt(String data, SecretKey key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        if (data != null) {
            IvParameterSpec iVpec = new IvParameterSpec(key.getEncoded());
            Cipher cipher = Cipher.getInstance(AES_CBC_PKCS5_ALGORITHM);
            cipher.init(1, (Key)key, iVpec);
            return cipher.doFinal(data.getBytes(UTF8_CHARSET));
        }
        return null;
    }

    public byte[] AESDecrypt(byte[] data, SecretKey key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        if (data != null) {
            IvParameterSpec iVpec = new IvParameterSpec(key.getEncoded());
            Cipher cipher = Cipher.getInstance(AES_CBC_PKCS5_ALGORITHM);
            cipher.init(2, (Key)key, iVpec);
            return cipher.doFinal(data);
        }
        return null;
    }

    public KeyPair generateRSAKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance(RSA_ALGORITHM);
        keyGenerator.initialize(4096);
        return keyGenerator.generateKeyPair();
    }

    public SecretKey generateRandomAES128() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(AES_ALGORITHM);
        keyGenerator.init(128);
        SecretKey key = keyGenerator.generateKey();
        return key;
    }
}

