/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.models;

import com.bambora.nativepayment.interfaces.IJsonResponse;
import com.bambora.nativepayment.json.JsonContainer;
import com.bambora.nativepayment.models.creditcard.TransactionErrorResponse;
import com.bambora.nativepayment.utils.JsonUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class TransactionResponse
implements IJsonResponse<TransactionResponse> {
    private static final String KEY_PAYMENT_ID = "payment";
    private static final String KEY_AMOUNT = "amount";
    private static final String KEY_CURRENCY = "currency";
    private static final String KEY_STATUS = "status";
    private static final String KEY_CODE = "code";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_INFO = "info";
    private static final String KEY_RECEIPT = "receipt";
    private static final String KEY_CARD_TOKEN = "creditCardToken";
    private static final String KEY_CARD_HOLDER_NAME = "cardHolderName";
    private static final String KEY_TRUNCATED_CARD = "truncatedCard";
    private static final String KEY_CARD_TYPE = "cardType";
    public String paymentId;
    public Integer amount;
    public String currency;
    public String receipt;
    public String creditCardToken;
    public String cardHolderName;
    public String truncatedCard;
    public String cardType;
    public Integer status;
    public Integer code;
    public String errorMessage;
    public String errorInfo;

    @Override
    public TransactionResponse fromJson(JsonContainer jsonContainer) throws JSONException {
        JSONObject jsonObject = jsonContainer.getJsonObject();
        this.paymentId = JsonUtils.getStringIfExists(jsonObject, KEY_PAYMENT_ID);
        this.amount = JsonUtils.getIntIfExists(jsonObject, KEY_AMOUNT);
        this.currency = JsonUtils.getStringIfExists(jsonObject, KEY_CURRENCY);
        this.status = JsonUtils.getIntIfExists(jsonObject, KEY_STATUS);
        this.code = JsonUtils.getIntIfExists(jsonObject, KEY_CODE);
        this.errorMessage = JsonUtils.getStringIfExists(jsonObject, KEY_MESSAGE);
        this.errorInfo = JsonUtils.getStringIfExists(jsonObject, KEY_INFO);
        this.receipt = JsonUtils.getStringIfExists(jsonObject, KEY_RECEIPT);
        this.creditCardToken = JsonUtils.getStringIfExists(jsonObject, KEY_CARD_TOKEN);
        this.cardHolderName = JsonUtils.getStringIfExists(jsonObject, KEY_CARD_HOLDER_NAME);
        this.truncatedCard = JsonUtils.getStringIfExists(jsonObject, KEY_TRUNCATED_CARD);
        this.cardType = JsonUtils.getStringIfExists(jsonObject, KEY_CARD_TYPE);
        return this;
    }

    public TransactionErrorResponse getError() {
        return new TransactionErrorResponse(this.status, this.code, this.errorMessage, this.errorInfo);
    }
}

